/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghpatexpress;

import generic.stl.VectorSTL;
import ghidra.pcodeCPort.context.ParserWalker;
import ghidra.pcodeCPort.context.Token;
import ghidra.pcodeCPort.slghpatexpress.ExpressUtils;
import ghidra.pcodeCPort.slghpatexpress.PatternValue;
import ghidra.pcodeCPort.slghpatexpress.TokenPattern;
import ghidra.pcodeCPort.translate.Translate;
import ghidra.pcodeCPort.utils.Utils;
import ghidra.pcodeCPort.utils.XmlUtils;
import ghidra.sleigh.grammar.Location;
import java.io.PrintStream;
import org.jdom.Element;

public class TokenField
extends PatternValue {
    private Token tok;
    private boolean bigendian;
    private boolean signbit;
    private int bitstart;
    private int bitend;
    private int bytestart;
    private int byteend;
    private int shift;

    public TokenField(Location location) {
        super(location);
    }

    @Override
    public TokenPattern genMinPattern(VectorSTL<TokenPattern> ops) {
        return new TokenPattern(this.location, this.tok);
    }

    @Override
    public long minValue() {
        return 0L;
    }

    @Override
    public long maxValue() {
        long res = 0L;
        res ^= 0xFFFFFFFFFFFFFFFFL;
        res = Utils.zzz_zero_extend(res, this.bitend - this.bitstart);
        return res;
    }

    public TokenField(Location location, Token tk, boolean s, int bstart, int bend) {
        super(location);
        this.tok = tk;
        this.bigendian = this.tok.isBigEndian();
        this.signbit = s;
        this.bitstart = bstart;
        this.bitend = bend;
        if (tk.isBigEndian()) {
            this.byteend = (tk.getSize() * 8 - this.bitstart - 1) / 8;
            this.bytestart = (tk.getSize() * 8 - this.bitend - 1) / 8;
        } else {
            this.bytestart = this.bitstart / 8;
            this.byteend = this.bitend / 8;
        }
        this.shift = this.bitstart % 8;
    }

    @Override
    public long getValue(ParserWalker pos) {
        long res = ExpressUtils.getInstructionBytes(pos, this.bytestart, this.byteend, this.bigendian);
        res >>>= this.shift;
        res = this.signbit ? Utils.zzz_sign_extend(res, this.bitend - this.bitstart) : Utils.zzz_zero_extend(res, this.bitend - this.bitstart);
        return res;
    }

    @Override
    public TokenPattern genPattern(long val) {
        return new TokenPattern(this.location, this.tok, val, this.bitstart, this.bitend);
    }

    @Override
    public void saveXml(PrintStream s) {
        s.append("<tokenfield");
        s.append(" bigendian=\"");
        if (this.bigendian) {
            s.append("true\"");
        } else {
            s.append("false\"");
        }
        s.append(" signbit=\"");
        if (this.signbit) {
            s.append("true\"");
        } else {
            s.append("false\"");
        }
        s.append(" bitstart=\"").print(this.bitstart);
        s.append("\"");
        s.append(" bitend=\"").print(this.bitend);
        s.append("\"");
        s.append(" bytestart=\"").print(this.bytestart);
        s.append("\"");
        s.append(" byteend=\"").print(this.byteend);
        s.append("\"");
        s.append(" shift=\"").print(this.shift);
        s.append("\"/>\n");
    }

    @Override
    public void restoreXml(Element el, Translate trans) {
        this.tok = null;
        this.bigendian = XmlUtils.decodeBoolean(el.getAttributeValue("bigendian"));
        this.signbit = XmlUtils.decodeBoolean(el.getAttributeValue("signbit"));
        this.bitstart = XmlUtils.decodeUnknownInt(el.getAttributeValue("bitstart"));
        this.bitend = XmlUtils.decodeUnknownInt(el.getAttributeValue("bitend"));
        this.bytestart = XmlUtils.decodeUnknownInt(el.getAttributeValue("bytestart"));
        this.byteend = XmlUtils.decodeUnknownInt(el.getAttributeValue("byteend"));
        this.shift = XmlUtils.decodeUnknownInt(el.getAttributeValue("shift"));
    }
}

