/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import com.google.common.base.Objects;

public class StringDiff {
    int start;
    int end;
    public String text;

    public static StringDiff allTextReplaced(String newText) {
        return new StringDiff(-1, -1, newText);
    }

    public static StringDiff textDeleted(int start, int end) {
        return new StringDiff(start, end, null);
    }

    public static StringDiff textInserted(String newText, int start) {
        return new StringDiff(start, -1, newText);
    }

    public static StringDiff restore(String text, int start, int end) {
        return new StringDiff(start, end, text);
    }

    private StringDiff(int start, int end, String text) {
        this.start = start;
        this.end = end;
        this.text = text;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        result = 31 * result + this.start;
        result = 31 * result + this.end;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringDiff other = (StringDiff)obj;
        if (!Objects.equal((Object)this.text, (Object)other.text)) {
            return false;
        }
        if (this.start != other.start) {
            return false;
        }
        return this.end == other.end;
    }

    public String toString() {
        if (this.text != null) {
            if (this.start >= 0) {
                return "StringDiff: inserted <" + this.text + "> at " + this.start;
            }
            return "StringDiff: replace with <" + this.text + ">";
        }
        return "StringDiff: deleted text from " + this.start + " to " + this.end;
    }
}

