/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import ghidra.program.database.mem.ByteSourceRange;
import ghidra.program.model.address.Address;
import ghidra.program.model.mem.MemoryBlock;

public class BitMappedByteSourceRange
extends ByteSourceRange {
    public BitMappedByteSourceRange(MemoryBlock block, Address start, long sourceId, long offset, long size) {
        super(block, start, size, sourceId, offset);
    }

    @Override
    public Address getEnd() {
        return this.getStart().add(this.size * 8L - 1L);
    }

    @Override
    public ByteSourceRange intersect(ByteSourceRange range) {
        long minEndOffset;
        if (this.sourceId != range.sourceId) {
            return null;
        }
        long maxOffset = Math.max(this.byteSourceOffset, range.byteSourceOffset);
        if (maxOffset > (minEndOffset = Math.min(this.byteSourceOffset + this.size - 1L, range.byteSourceOffset + range.size - 1L))) {
            return null;
        }
        long sourceSize = minEndOffset - maxOffset + 1L;
        return new BitMappedByteSourceRange(this.block, this.start.add((maxOffset - this.byteSourceOffset) / 8L), this.sourceId, maxOffset, sourceSize);
    }
}

