/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionLocation;

public class FunctionSignatureSourceFieldLocation
extends FunctionLocation {
    private String source;

    public FunctionSignatureSourceFieldLocation(Program program, Address locationAddr, Address functionAddr, String source, int charOffset) {
        super(program, locationAddr, functionAddr, 0, 0, charOffset);
        this.source = source;
    }

    public FunctionSignatureSourceFieldLocation() {
    }

    public String getSignatureSource() {
        return this.source;
    }

    @Override
    public String toString() {
        return super.toString() + ", Function signature source = " + this.source;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionSignatureSourceFieldLocation other = (FunctionSignatureSourceFieldLocation)obj;
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putString("_SIGNATURE_SOURCE", this.source);
    }

    @Override
    public void restoreState(Program p, SaveState obj) {
        super.restoreState(p, obj);
        this.source = obj.getString("_SIGNATURE_SOURCE", null);
    }
}

