/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.DialogComponentProvider;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GIconLabel;
import docking.widgets.label.GLabel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import resources.ResourceManager;

public class VersionControlDialog
extends DialogComponentProvider {
    static final int OK = 0;
    public static final int APPLY_TO_ALL = 1;
    public static final int CANCEL = 2;
    private JCheckBox keepCB;
    private JCheckBox keepFileCB;
    private JLabel descriptionLabel;
    private JTextArea commentsTextArea;
    private JButton allButton;
    private int actionID;
    private boolean addToVersionControl;

    public VersionControlDialog(boolean addToVersionControl) {
        super(addToVersionControl ? "Add File to Version Control" : "Check In File(s)", true);
        this.addToVersionControl = addToVersionControl;
        this.addWorkPanel(this.buildMainPanel());
        this.allButton = new JButton("Apply to All");
        this.allButton.setMnemonic('A');
        this.allButton.addActionListener(e -> {
            this.actionID = 1;
            this.close();
        });
        this.addOKButton();
        this.addButton(this.allButton);
        this.addCancelButton();
        String tag = addToVersionControl ? "Add_to_Version_Control" : "CheckIn";
        this.setHelpLocation(new HelpLocation("Repository", tag));
        this.setRememberLocation(false);
        this.setRememberSize(false);
    }

    protected void cancelCallback() {
        this.actionID = 2;
        this.close();
    }

    protected void okCallback() {
        this.actionID = 0;
        this.close();
    }

    int showDialog(PluginTool tool, Component parent) {
        tool.showDialog((DialogComponentProvider)this, parent);
        return this.actionID;
    }

    void setMultiFiles(boolean multi) {
        this.allButton.setEnabled(multi);
    }

    boolean keepCheckedOut() {
        return this.keepCB.isSelected();
    }

    void setKeepCheckedOut(boolean selected) {
        this.keepCB.setSelected(selected);
    }

    boolean shouldCreateKeepFile() {
        if (this.addToVersionControl) {
            return false;
        }
        return this.keepFileCB.isSelected();
    }

    void setCreateKeepFile(boolean selected) {
        if (!this.addToVersionControl) {
            this.keepFileCB.setSelected(selected);
        }
    }

    String getComments() {
        return this.commentsTextArea.getText();
    }

    public void setKeepCheckboxEnabled(boolean enabled) {
        this.keepCB.setEnabled(enabled);
        this.keepCB.setToolTipText(enabled ? "" : "Must keep Checked Out because the file is in use");
    }

    private JPanel buildMainPanel() {
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BoxLayout(innerPanel, 1));
        ImageIcon icon = ResourceManager.loadImage((String)(this.addToVersionControl ? "images/vcAdd.png" : "images/vcCheckIn.png"));
        this.descriptionLabel = new GDLabel(this.addToVersionControl ? "Add comments to describe the file." : "Add comments to describe changes", 2);
        JPanel dPanel = new JPanel(new BorderLayout(10, 0));
        dPanel.add((Component)new GIconLabel((Icon)icon), "West");
        dPanel.add((Component)this.descriptionLabel, "Center");
        JPanel cPanel = new JPanel(new BorderLayout());
        cPanel.add((Component)new GLabel("Comments:", 2));
        this.commentsTextArea = new JTextArea(4, 20);
        JScrollPane sp = new JScrollPane(this.commentsTextArea);
        this.keepCB = new GCheckBox("Keep File Checked Out", true);
        JPanel kPanel = new JPanel(new BorderLayout());
        kPanel.add((Component)this.keepCB, "West");
        innerPanel.add(Box.createVerticalStrut(10));
        innerPanel.add(dPanel);
        innerPanel.add(Box.createVerticalStrut(5));
        innerPanel.add(cPanel);
        innerPanel.add(sp);
        innerPanel.add(Box.createVerticalStrut(5));
        innerPanel.add(kPanel);
        if (!this.addToVersionControl) {
            this.keepFileCB = new GCheckBox("Create \".keep\" file", false);
            JPanel kpPanel = new JPanel(new BorderLayout());
            kpPanel.add((Component)this.keepFileCB, "West");
            innerPanel.add(kpPanel);
        }
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        mainPanel.add(innerPanel);
        return mainPanel;
    }

    public void setCurrentFileName(String filename) {
        String description = this.addToVersionControl ? "Add comments to describe " + filename + "." : "Add comments to describe changes to " + filename + ".";
        this.descriptionLabel.setText(description);
    }
}

