/*
 * Decompiled with CFR 0.152.
 */
package org.xeustechnologies.jcl.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.xeustechnologies.jcl.JarClassLoader;
import org.xeustechnologies.jcl.exception.JclContextException;

public class JclContext {
    private static final Map<String, JarClassLoader> loaders = Collections.synchronizedMap(new HashMap());
    public static final String DEFAULT_NAME = "jcl";

    public JclContext() {
        this.validate();
    }

    private void validate() {
        if (JclContext.isLoaded()) {
            throw new JclContextException("Context already loaded. Destroy the existing context to create a new one.");
        }
    }

    public static boolean isLoaded() {
        return !loaders.isEmpty();
    }

    public void addJcl(String name, JarClassLoader jcl) {
        if (loaders.containsKey(name)) {
            throw new JclContextException("JarClassLoader[" + name + "] already exist. Name must be unique");
        }
        loaders.put(name, jcl);
    }

    public static void destroy() {
        if (JclContext.isLoaded()) {
            loaders.clear();
        }
    }

    public static JarClassLoader get() {
        return loaders.get(DEFAULT_NAME);
    }

    public static JarClassLoader get(String name) {
        return loaders.get(name);
    }

    public static Map<String, JarClassLoader> getAll() {
        return Collections.unmodifiableMap(loaders);
    }
}

