/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.beats;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.beats.Batch;
import org.logstash.beats.InvalidFrameProtocolException;
import org.logstash.beats.Message;
import org.logstash.beats.Protocol;
import org.logstash.beats.V1Batch;
import org.logstash.beats.V2Batch;

public class BeatsParser
extends ByteToMessageDecoder {
    private static final Logger logger = LogManager.getLogger(BeatsParser.class);
    private Batch batch;
    private States currentState = States.READ_HEADER;
    private int requiredBytes = 0;
    private int sequence = 0;
    private boolean decodingCompressedBuffer = false;

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws InvalidFrameProtocolException, IOException {
        if (!this.hasEnoughBytes(in)) {
            if (this.decodingCompressedBuffer) {
                throw new InvalidFrameProtocolException("Insufficient bytes in compressed content to decode: " + (Object)((Object)this.currentState));
            }
            return;
        }
        block0 : switch (this.currentState) {
            case READ_HEADER: {
                logger.trace("Running: READ_HEADER");
                int version = Protocol.version(in.readByte());
                if (this.batch == null) {
                    if (version == 2) {
                        this.batch = new V2Batch();
                        logger.trace("Frame version 2 detected");
                    } else {
                        logger.trace("Frame version 1 detected");
                        this.batch = new V1Batch();
                    }
                }
                this.transition(States.READ_FRAME_TYPE);
                break;
            }
            case READ_FRAME_TYPE: {
                byte frameType = in.readByte();
                switch (frameType) {
                    case 87: {
                        this.transition(States.READ_WINDOW_SIZE);
                        break block0;
                    }
                    case 74: {
                        this.transition(States.READ_JSON_HEADER);
                        break block0;
                    }
                    case 67: {
                        this.transition(States.READ_COMPRESSED_FRAME_HEADER);
                        break block0;
                    }
                    case 68: {
                        this.transition(States.READ_DATA_FIELDS);
                        break block0;
                    }
                }
                throw new InvalidFrameProtocolException("Invalid Frame Type, received: " + frameType);
            }
            case READ_WINDOW_SIZE: {
                logger.trace("Running: READ_WINDOW_SIZE");
                this.batch.setBatchSize((int)in.readUnsignedInt());
                if (!this.batch.isEmpty()) {
                    logger.warn("New window size received but the current batch was not complete, sending the current batch");
                    out.add(this.batch);
                    this.batchComplete();
                }
                this.transition(States.READ_HEADER);
                break;
            }
            case READ_DATA_FIELDS: {
                logger.trace("Running: READ_DATA_FIELDS");
                this.sequence = (int)in.readUnsignedInt();
                int fieldsCount = (int)in.readUnsignedInt();
                if (fieldsCount <= 0) {
                    throw new InvalidFrameProtocolException("Invalid number of fields, received: " + fieldsCount);
                }
                HashMap<String, String> dataMap = new HashMap<String, String>(fieldsCount);
                for (int count = 0; count < fieldsCount; ++count) {
                    int fieldLength = (int)in.readUnsignedInt();
                    ByteBuf fieldBuf = in.readBytes(fieldLength);
                    String field = fieldBuf.toString(Charset.forName("UTF8"));
                    fieldBuf.release();
                    int dataLength = (int)in.readUnsignedInt();
                    ByteBuf dataBuf = in.readBytes(dataLength);
                    String data = dataBuf.toString(Charset.forName("UTF8"));
                    dataBuf.release();
                    dataMap.put(field, data);
                }
                Message message = new Message(this.sequence, dataMap);
                ((V1Batch)this.batch).addMessage(message);
                if (this.batch.isComplete()) {
                    out.add(this.batch);
                    this.batchComplete();
                }
                this.transition(States.READ_HEADER);
                break;
            }
            case READ_JSON_HEADER: {
                logger.trace("Running: READ_JSON_HEADER");
                this.sequence = (int)in.readUnsignedInt();
                int jsonPayloadSize = (int)in.readUnsignedInt();
                if (jsonPayloadSize <= 0) {
                    throw new InvalidFrameProtocolException("Invalid json length, received: " + jsonPayloadSize);
                }
                this.transition(States.READ_JSON, jsonPayloadSize);
                break;
            }
            case READ_COMPRESSED_FRAME_HEADER: {
                logger.trace("Running: READ_COMPRESSED_FRAME_HEADER");
                this.transition(States.READ_COMPRESSED_FRAME, in.readInt());
                break;
            }
            case READ_COMPRESSED_FRAME: {
                logger.trace("Running: READ_COMPRESSED_FRAME");
                this.inflateCompressedFrame(ctx, in, buffer -> {
                    this.transition(States.READ_HEADER);
                    this.decodingCompressedBuffer = true;
                    try {
                        while (buffer.readableBytes() > 0) {
                            this.decode(ctx, (ByteBuf)buffer, out);
                        }
                    }
                    finally {
                        this.decodingCompressedBuffer = false;
                        this.transition(States.READ_HEADER);
                    }
                });
                break;
            }
            case READ_JSON: {
                logger.trace("Running: READ_JSON");
                ((V2Batch)this.batch).addMessage(this.sequence, in, this.requiredBytes);
                if (this.batch.isComplete()) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Sending batch size: " + this.batch.size() + ", windowSize: " + this.batch.getBatchSize() + " , seq: " + this.sequence);
                    }
                    out.add(this.batch);
                    this.batchComplete();
                }
                this.transition(States.READ_HEADER);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inflateCompressedFrame(ChannelHandlerContext ctx, ByteBuf in, CheckedConsumer<ByteBuf> fn) throws IOException {
        ByteBuf buffer = ctx.alloc().buffer(this.requiredBytes);
        try {
            this.decompressImpl(in, buffer);
            fn.accept(buffer);
        }
        finally {
            buffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decompressImpl(ByteBuf in, ByteBuf out) throws IOException {
        Inflater inflater = new Inflater();
        try (ByteBufOutputStream buffOutput = new ByteBufOutputStream(out);
             InflaterOutputStream inflaterStream = new InflaterOutputStream((OutputStream)buffOutput, inflater);){
            in.readBytes((OutputStream)inflaterStream, this.requiredBytes);
        }
        finally {
            inflater.end();
        }
    }

    private boolean hasEnoughBytes(ByteBuf in) {
        return in.readableBytes() >= this.requiredBytes;
    }

    private void transition(States next) {
        this.transition(next, next.length);
    }

    private void transition(States nextState, int requiredBytes) {
        if (logger.isTraceEnabled()) {
            logger.trace("Transition, from: " + (Object)((Object)this.currentState) + ", to: " + (Object)((Object)nextState) + ", requiring " + requiredBytes + " bytes");
        }
        this.currentState = nextState;
        this.requiredBytes = requiredBytes;
    }

    private void batchComplete() {
        this.requiredBytes = 0;
        this.sequence = 0;
        this.batch = null;
    }

    @FunctionalInterface
    private static interface CheckedConsumer<T> {
        public void accept(T var1) throws IOException;
    }

    private static enum States {
        READ_HEADER(1),
        READ_FRAME_TYPE(1),
        READ_WINDOW_SIZE(4),
        READ_JSON_HEADER(8),
        READ_COMPRESSED_FRAME_HEADER(4),
        READ_COMPRESSED_FRAME(-1),
        READ_JSON(-1),
        READ_DATA_FIELDS(-1);

        private int length;

        private States(int length) {
            this.length = length;
        }
    }
}

