/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.util.Map;
import java.util.Set;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VkCommandBuffer;
import org.lwjgl.vulkan.VkWriteDescriptorSet;

public class KHRPushDescriptor {
    public static final int VK_KHR_PUSH_DESCRIPTOR_SPEC_VERSION = 2;
    public static final String VK_KHR_PUSH_DESCRIPTOR_EXTENSION_NAME = "VK_KHR_push_descriptor";
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR = 1000080000;
    public static final int VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR = 1;
    public static final int VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS_KHR = 1;

    protected KHRPushDescriptor() {
        throw new UnsupportedOperationException();
    }

    static boolean checkCapsDevice(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_KHR_PUSH_DESCRIPTOR_EXTENSION_NAME) && VK.checkExtension(VK_KHR_PUSH_DESCRIPTOR_EXTENSION_NAME, VK.isSupported(provider, "vkCmdPushDescriptorSetKHR", caps) && VK.isSupported(provider, "vkCmdPushDescriptorSetWithTemplateKHR", caps, ext.contains("Vulkan11")));
    }

    public static void nvkCmdPushDescriptorSetKHR(VkCommandBuffer commandBuffer, int pipelineBindPoint, long layout, int set, int descriptorWriteCount, long pDescriptorWrites) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdPushDescriptorSetKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPJPV((long)commandBuffer.address(), (int)pipelineBindPoint, (long)layout, (int)set, (int)descriptorWriteCount, (long)pDescriptorWrites, (long)__functionAddress);
    }

    public static void vkCmdPushDescriptorSetKHR(VkCommandBuffer commandBuffer, @NativeType(value="VkPipelineBindPoint") int pipelineBindPoint, @NativeType(value="VkPipelineLayout") long layout, @NativeType(value="uint32_t") int set, @NativeType(value="VkWriteDescriptorSet const *") VkWriteDescriptorSet.Buffer pDescriptorWrites) {
        KHRPushDescriptor.nvkCmdPushDescriptorSetKHR(commandBuffer, pipelineBindPoint, layout, set, pDescriptorWrites.remaining(), pDescriptorWrites.address());
    }

    public static void vkCmdPushDescriptorSetWithTemplateKHR(VkCommandBuffer commandBuffer, @NativeType(value="VkDescriptorUpdateTemplate") long descriptorUpdateTemplate, @NativeType(value="VkPipelineLayout") long layout, @NativeType(value="uint32_t") int set, @NativeType(value="void const *") long pData) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdPushDescriptorSetWithTemplateKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)pData);
        }
        JNI.callPJJPV((long)commandBuffer.address(), (long)descriptorUpdateTemplate, (long)layout, (int)set, (long)pData, (long)__functionAddress);
    }
}

