/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.llvm.LLVMOrcLazyCompileCallbackFnI;
import org.lwjgl.llvm.LLVMOrcSymbolResolverFnI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class LLVMORC {
    protected LLVMORC() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="LLVMOrcJITStackRef")
    public static long LLVMOrcCreateInstance(@NativeType(value="LLVMTargetMachineRef") long TM) {
        long __functionAddress = Functions.OrcCreateInstance;
        if (Checks.CHECKS) {
            Checks.check((long)TM);
        }
        return JNI.invokePP((long)TM, (long)__functionAddress);
    }

    public static long nLLVMOrcGetErrorMsg(long JITStack) {
        long __functionAddress = Functions.OrcGetErrorMsg;
        if (Checks.CHECKS) {
            Checks.check((long)JITStack);
        }
        return JNI.invokePP((long)JITStack, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMOrcGetErrorMsg(@NativeType(value="LLVMOrcJITStackRef") long JITStack) {
        long __result = LLVMORC.nLLVMOrcGetErrorMsg(JITStack);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static void nLLVMOrcGetMangledSymbol(long JITStack, long MangledSymbol, long Symbol) {
        long __functionAddress = Functions.OrcGetMangledSymbol;
        if (Checks.CHECKS) {
            Checks.check((long)JITStack);
        }
        JNI.invokePPPV((long)JITStack, (long)MangledSymbol, (long)Symbol, (long)__functionAddress);
    }

    public static void LLVMOrcGetMangledSymbol(@NativeType(value="LLVMOrcJITStackRef") long JITStack, @NativeType(value="char **") PointerBuffer MangledSymbol, @NativeType(value="char const *") ByteBuffer Symbol) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)MangledSymbol, (int)1);
            Checks.checkNT1((ByteBuffer)Symbol);
        }
        LLVMORC.nLLVMOrcGetMangledSymbol(JITStack, MemoryUtil.memAddress((CustomBuffer)MangledSymbol), MemoryUtil.memAddress((ByteBuffer)Symbol));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMOrcGetMangledSymbol(@NativeType(value="LLVMOrcJITStackRef") long JITStack, @NativeType(value="char **") PointerBuffer MangledSymbol, @NativeType(value="char const *") CharSequence Symbol) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)MangledSymbol, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Symbol, true);
            long SymbolEncoded = stack.getPointerAddress();
            LLVMORC.nLLVMOrcGetMangledSymbol(JITStack, MemoryUtil.memAddress((CustomBuffer)MangledSymbol), SymbolEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nLLVMOrcDisposeMangledSymbol(long MangledSymbol) {
        long __functionAddress = Functions.OrcDisposeMangledSymbol;
        JNI.invokePV((long)MangledSymbol, (long)__functionAddress);
    }

    public static void LLVMOrcDisposeMangledSymbol(@NativeType(value="char *") ByteBuffer MangledSymbol) {
        LLVMORC.nLLVMOrcDisposeMangledSymbol(MemoryUtil.memAddress((ByteBuffer)MangledSymbol));
    }

    public static long nLLVMOrcCreateLazyCompileCallback(long JITStack, long RetAddr, long Callback2, long CallbackCtx) {
        long __functionAddress = Functions.OrcCreateLazyCompileCallback;
        if (Checks.CHECKS) {
            Checks.check((long)JITStack);
            Checks.check((long)CallbackCtx);
        }
        return JNI.invokePPPPP((long)JITStack, (long)RetAddr, (long)Callback2, (long)CallbackCtx, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcCreateLazyCompileCallback(@NativeType(value="LLVMOrcJITStackRef") long JITStack, @NativeType(value="LLVMOrcTargetAddress *") LongBuffer RetAddr, @NativeType(value="uint64_t (*) (LLVMOrcJITStackRef, void *)") LLVMOrcLazyCompileCallbackFnI Callback2, @NativeType(value="void *") long CallbackCtx) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)RetAddr, (int)1);
        }
        return LLVMORC.nLLVMOrcCreateLazyCompileCallback(JITStack, MemoryUtil.memAddress((LongBuffer)RetAddr), Callback2.address(), CallbackCtx);
    }

    public static long nLLVMOrcCreateIndirectStub(long JITStack, long StubName, long InitAddr) {
        long __functionAddress = Functions.OrcCreateIndirectStub;
        if (Checks.CHECKS) {
            Checks.check((long)JITStack);
        }
        return JNI.invokePPJP((long)JITStack, (long)StubName, (long)InitAddr, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcCreateIndirectStub(@NativeType(value="LLVMOrcJITStackRef") long JITStack, @NativeType(value="char const *") ByteBuffer StubName, @NativeType(value="LLVMOrcTargetAddress") long InitAddr) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)StubName);
        }
        return LLVMORC.nLLVMOrcCreateIndirectStub(JITStack, MemoryUtil.memAddress((ByteBuffer)StubName), InitAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcCreateIndirectStub(@NativeType(value="LLVMOrcJITStackRef") long JITStack, @NativeType(value="char const *") CharSequence StubName, @NativeType(value="LLVMOrcTargetAddress") long InitAddr) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(StubName, true);
            long StubNameEncoded = stack.getPointerAddress();
            long l = LLVMORC.nLLVMOrcCreateIndirectStub(JITStack, StubNameEncoded, InitAddr);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMOrcSetIndirectStubPointer(long JITStack, long StubName, long NewAddr) {
        long __functionAddress = Functions.OrcSetIndirectStubPointer;
        if (Checks.CHECKS) {
            Checks.check((long)JITStack);
        }
        return JNI.invokePPJP((long)JITStack, (long)StubName, (long)NewAddr, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcSetIndirectStubPointer(@NativeType(value="LLVMOrcJITStackRef") long JITStack, @NativeType(value="char const *") ByteBuffer StubName, @NativeType(value="LLVMOrcTargetAddress") long NewAddr) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)StubName);
        }
        return LLVMORC.nLLVMOrcSetIndirectStubPointer(JITStack, MemoryUtil.memAddress((ByteBuffer)StubName), NewAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcSetIndirectStubPointer(@NativeType(value="LLVMOrcJITStackRef") long JITStack, @NativeType(value="char const *") CharSequence StubName, @NativeType(value="LLVMOrcTargetAddress") long NewAddr) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(StubName, true);
            long StubNameEncoded = stack.getPointerAddress();
            long l = LLVMORC.nLLVMOrcSetIndirectStubPointer(JITStack, StubNameEncoded, NewAddr);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMOrcAddEagerlyCompiledIR(long JITStack, long RetHandle, long Mod, long SymbolResolver, long SymbolResolverCtx) {
        long __functionAddress = Functions.OrcAddEagerlyCompiledIR;
        if (Checks.CHECKS) {
            Checks.check((long)JITStack);
            Checks.check((long)Mod);
            Checks.check((long)SymbolResolverCtx);
        }
        return JNI.invokePPPPPP((long)JITStack, (long)RetHandle, (long)Mod, (long)SymbolResolver, (long)SymbolResolverCtx, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcAddEagerlyCompiledIR(@NativeType(value="LLVMOrcJITStackRef") long JITStack, @NativeType(value="LLVMOrcModuleHandle *") LongBuffer RetHandle, @NativeType(value="LLVMModuleRef") long Mod, @NativeType(value="uint64_t (*) (char const *, void *)") LLVMOrcSymbolResolverFnI SymbolResolver, @NativeType(value="void *") long SymbolResolverCtx) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)RetHandle, (int)1);
        }
        return LLVMORC.nLLVMOrcAddEagerlyCompiledIR(JITStack, MemoryUtil.memAddress((LongBuffer)RetHandle), Mod, SymbolResolver.address(), SymbolResolverCtx);
    }

    public static long nLLVMOrcAddLazilyCompiledIR(long JITStack, long RetHandle, long Mod, long SymbolResolver, long SymbolResolverCtx) {
        long __functionAddress = Functions.OrcAddLazilyCompiledIR;
        if (Checks.CHECKS) {
            Checks.check((long)JITStack);
            Checks.check((long)Mod);
            Checks.check((long)SymbolResolverCtx);
        }
        return JNI.invokePPPPPP((long)JITStack, (long)RetHandle, (long)Mod, (long)SymbolResolver, (long)SymbolResolverCtx, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcAddLazilyCompiledIR(@NativeType(value="LLVMOrcJITStackRef") long JITStack, @NativeType(value="LLVMOrcModuleHandle *") LongBuffer RetHandle, @NativeType(value="LLVMModuleRef") long Mod, @NativeType(value="uint64_t (*) (char const *, void *)") LLVMOrcSymbolResolverFnI SymbolResolver, @NativeType(value="void *") long SymbolResolverCtx) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)RetHandle, (int)1);
        }
        return LLVMORC.nLLVMOrcAddLazilyCompiledIR(JITStack, MemoryUtil.memAddress((LongBuffer)RetHandle), Mod, SymbolResolver.address(), SymbolResolverCtx);
    }

    public static long nLLVMOrcAddObjectFile(long JITStack, long RetHandle, long Obj, long SymbolResolver, long SymbolResolverCtx) {
        long __functionAddress = Functions.OrcAddObjectFile;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)JITStack);
            Checks.check((long)Obj);
            Checks.check((long)SymbolResolverCtx);
        }
        return JNI.invokePPPPPP((long)JITStack, (long)RetHandle, (long)Obj, (long)SymbolResolver, (long)SymbolResolverCtx, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcAddObjectFile(@NativeType(value="LLVMOrcJITStackRef") long JITStack, @NativeType(value="LLVMOrcModuleHandle *") LongBuffer RetHandle, @NativeType(value="LLVMMemoryBufferRef") long Obj, @NativeType(value="uint64_t (*) (char const *, void *)") LLVMOrcSymbolResolverFnI SymbolResolver, @NativeType(value="void *") long SymbolResolverCtx) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)RetHandle, (int)1);
        }
        return LLVMORC.nLLVMOrcAddObjectFile(JITStack, MemoryUtil.memAddress((LongBuffer)RetHandle), Obj, SymbolResolver.address(), SymbolResolverCtx);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcRemoveModule(@NativeType(value="LLVMOrcJITStackRef") long JITStack, @NativeType(value="LLVMOrcModuleHandle") long H) {
        long __functionAddress = Functions.OrcRemoveModule;
        if (Checks.CHECKS) {
            Checks.check((long)JITStack);
        }
        return JNI.invokePJP((long)JITStack, (long)H, (long)__functionAddress);
    }

    public static long nLLVMOrcGetSymbolAddress(long JITStack, long RetAddr, long SymbolName) {
        long __functionAddress = Functions.OrcGetSymbolAddress;
        if (Checks.CHECKS) {
            Checks.check((long)JITStack);
        }
        return JNI.invokePPPP((long)JITStack, (long)RetAddr, (long)SymbolName, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcGetSymbolAddress(@NativeType(value="LLVMOrcJITStackRef") long JITStack, @NativeType(value="LLVMOrcTargetAddress *") LongBuffer RetAddr, @NativeType(value="char const *") ByteBuffer SymbolName) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)RetAddr, (int)1);
            Checks.checkNT1((ByteBuffer)SymbolName);
        }
        return LLVMORC.nLLVMOrcGetSymbolAddress(JITStack, MemoryUtil.memAddress((LongBuffer)RetAddr), MemoryUtil.memAddress((ByteBuffer)SymbolName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcGetSymbolAddress(@NativeType(value="LLVMOrcJITStackRef") long JITStack, @NativeType(value="LLVMOrcTargetAddress *") LongBuffer RetAddr, @NativeType(value="char const *") CharSequence SymbolName) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)RetAddr, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(SymbolName, true);
            long SymbolNameEncoded = stack.getPointerAddress();
            long l = LLVMORC.nLLVMOrcGetSymbolAddress(JITStack, MemoryUtil.memAddress((LongBuffer)RetAddr), SymbolNameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMOrcGetSymbolAddressIn(long JITStack, long RetAddr, long H, long SymbolName) {
        long __functionAddress = Functions.OrcGetSymbolAddressIn;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)JITStack);
        }
        return JNI.invokePPJPP((long)JITStack, (long)RetAddr, (long)H, (long)SymbolName, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcGetSymbolAddressIn(@NativeType(value="LLVMOrcJITStackRef") long JITStack, @NativeType(value="LLVMOrcTargetAddress *") LongBuffer RetAddr, @NativeType(value="LLVMOrcModuleHandle") long H, @NativeType(value="char const *") ByteBuffer SymbolName) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)RetAddr, (int)1);
            Checks.checkNT1((ByteBuffer)SymbolName);
        }
        return LLVMORC.nLLVMOrcGetSymbolAddressIn(JITStack, MemoryUtil.memAddress((LongBuffer)RetAddr), H, MemoryUtil.memAddress((ByteBuffer)SymbolName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcGetSymbolAddressIn(@NativeType(value="LLVMOrcJITStackRef") long JITStack, @NativeType(value="LLVMOrcTargetAddress *") LongBuffer RetAddr, @NativeType(value="LLVMOrcModuleHandle") long H, @NativeType(value="char const *") CharSequence SymbolName) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)RetAddr, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(SymbolName, true);
            long SymbolNameEncoded = stack.getPointerAddress();
            long l = LLVMORC.nLLVMOrcGetSymbolAddressIn(JITStack, MemoryUtil.memAddress((LongBuffer)RetAddr), H, SymbolNameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcDisposeInstance(@NativeType(value="LLVMOrcJITStackRef") long JITStack) {
        long __functionAddress = Functions.OrcDisposeInstance;
        if (Checks.CHECKS) {
            Checks.check((long)JITStack);
        }
        return JNI.invokePP((long)JITStack, (long)__functionAddress);
    }

    public static void LLVMOrcRegisterJITEventListener(@NativeType(value="LLVMOrcJITStackRef") long JITStack, @NativeType(value="LLVMJITEventListenerRef") long L) {
        long __functionAddress = Functions.OrcRegisterJITEventListener;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)JITStack);
        }
        JNI.invokePPV((long)JITStack, (long)L, (long)__functionAddress);
    }

    public static void LLVMOrcUnregisterJITEventListener(@NativeType(value="LLVMOrcJITStackRef") long JITStack, @NativeType(value="LLVMJITEventListenerRef") long L) {
        long __functionAddress = Functions.OrcUnregisterJITEventListener;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)JITStack);
        }
        JNI.invokePPV((long)JITStack, (long)L, (long)__functionAddress);
    }

    public static final class Functions {
        public static final long OrcCreateInstance = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcCreateInstance");
        public static final long OrcGetErrorMsg = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcGetErrorMsg");
        public static final long OrcGetMangledSymbol = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcGetMangledSymbol");
        public static final long OrcDisposeMangledSymbol = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcDisposeMangledSymbol");
        public static final long OrcCreateLazyCompileCallback = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcCreateLazyCompileCallback");
        public static final long OrcCreateIndirectStub = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcCreateIndirectStub");
        public static final long OrcSetIndirectStubPointer = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcSetIndirectStubPointer");
        public static final long OrcAddEagerlyCompiledIR = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcAddEagerlyCompiledIR");
        public static final long OrcAddLazilyCompiledIR = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcAddLazilyCompiledIR");
        public static final long OrcAddObjectFile = LLVMCore.getLibrary().getFunctionAddress((CharSequence)"LLVMOrcAddObjectFile");
        public static final long OrcRemoveModule = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcRemoveModule");
        public static final long OrcGetSymbolAddress = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcGetSymbolAddress");
        public static final long OrcGetSymbolAddressIn = LLVMCore.getLibrary().getFunctionAddress((CharSequence)"LLVMOrcGetSymbolAddressIn");
        public static final long OrcDisposeInstance = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcDisposeInstance");
        public static final long OrcRegisterJITEventListener = LLVMCore.getLibrary().getFunctionAddress((CharSequence)"LLVMOrcRegisterJITEventListener");
        public static final long OrcUnregisterJITEventListener = LLVMCore.getLibrary().getFunctionAddress((CharSequence)"LLVMOrcUnregisterJITEventListener");

        private Functions() {
        }
    }
}

