/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;

public final class PercentDecodingReaderInputStream
extends InputStream {
    private final Reader delegate;

    public PercentDecodingReaderInputStream(Reader delegate) {
        this.delegate = delegate;
    }

    @Override
    public int read() throws IOException {
        int c = this.delegate.read();
        if (c == -1) {
            return -1;
        }
        if (c == 37) {
            return this.readHexByte();
        }
        if (c < 128) {
            return c;
        }
        throw new MalformedURLException("Unescaped non-ASCII character.");
    }

    private int readHexByte() throws IOException {
        int c = this.delegate.read();
        if (this.isHexDigit(c)) {
            int hi = Character.getNumericValue(c) << 4;
            c = this.delegate.read();
            if (this.isHexDigit(c)) {
                return hi | Character.getNumericValue(c);
            }
            throw new MalformedURLException("Malformed percent escape.");
        }
        throw new MalformedURLException("Malformed percent escape.");
    }

    private boolean isHexDigit(int c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

