/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.impl.I2PSessionMuxedImpl;
import net.i2p.crypto.KeyGenerator;
import net.i2p.crypto.SigType;
import net.i2p.data.Certificate;
import net.i2p.data.Destination;
import net.i2p.data.KeyCertificate;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.SimpleDataStructure;
import net.i2p.util.RandomSource;

public class I2PClientImpl
implements I2PClient {
    @Override
    public Destination createDestination(OutputStream destKeyStream) throws I2PException, IOException {
        return this.createDestination(destKeyStream, DEFAULT_SIGTYPE);
    }

    @Override
    public Destination createDestination(OutputStream destKeyStream, SigType type) throws I2PException, IOException {
        Certificate cert = type == SigType.DSA_SHA1 ? Certificate.NULL_CERT : new KeyCertificate(type);
        return this.createDestination(destKeyStream, cert);
    }

    @Override
    public Destination createDestination(OutputStream destKeyStream, Certificate cert) throws I2PException, IOException {
        SimpleDataStructure[] signingKeys;
        Destination d = new Destination();
        Object[] keypair = KeyGenerator.getInstance().generatePKIKeypair();
        PublicKey publicKey = (PublicKey)keypair[0];
        PrivateKey privateKey = (PrivateKey)keypair[1];
        if (cert.getCertificateType() == 5) {
            KeyCertificate kcert = cert.toKeyCertificate();
            SigType type = kcert.getSigType();
            try {
                signingKeys = KeyGenerator.getInstance().generateSigningKeys(type);
            }
            catch (GeneralSecurityException gse) {
                throw new I2PException("keygen fail", gse);
            }
        } else {
            signingKeys = KeyGenerator.getInstance().generateSigningKeys();
        }
        SigningPublicKey signingPubKey = (SigningPublicKey)signingKeys[0];
        SigningPrivateKey signingPrivKey = (SigningPrivateKey)signingKeys[1];
        d.setPublicKey(publicKey);
        d.setSigningPublicKey(signingPubKey);
        if (cert.getCertificateType() == 5) {
            KeyCertificate kcert = cert.toKeyCertificate();
            SigType type = kcert.getSigType();
            int len = type.getPubkeyLen();
            if (len < 128) {
                byte[] pad = new byte[128 - len];
                RandomSource.getInstance().nextBytes(pad);
                d.setPadding(pad);
            } else if (len > 128) {
                System.arraycopy(signingPubKey.getData(), 128, kcert.getPayload(), 4, len - 128);
            }
        }
        d.setCertificate(cert);
        d.writeBytes(destKeyStream);
        privateKey.writeBytes(destKeyStream);
        signingPrivKey.writeBytes(destKeyStream);
        destKeyStream.flush();
        return d;
    }

    @Override
    public I2PSession createSession(InputStream destKeyStream, Properties options) throws I2PSessionException {
        return this.createSession(I2PAppContext.getGlobalContext(), destKeyStream, options);
    }

    public I2PSession createSession(I2PAppContext context, InputStream destKeyStream, Properties options) throws I2PSessionException {
        return new I2PSessionMuxedImpl(context, destKeyStream, options);
    }
}

