/*
 * Decompiled with CFR 0.152.
 */
package circlet.todo;

import circlet.client.api.TodoContent;
import circlet.client.api.TodoItemContent;
import circlet.client.api.TodoItemContentKind;
import circlet.client.api.TodoItemContentMdText;
import circlet.client.api.TodoItemRecord;
import circlet.client.api.TodoStatus;
import circlet.todo.CategoryPresentation;
import circlet.todo.KnownCategories;
import circlet.todo.TodoEditorGroup;
import circlet.todo.TodoEditorVmInitialized;
import circlet.todo.TodoEditorVmKt;
import circlet.todo.TodoItemCategory;
import circlet.todo.TodoListItemVm;
import circlet.todo.TodoListVmTreeModel;
import circlet.ui.CircletFontIconTypeface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import libraries.klogging.BaseLogger;
import libraries.klogging.KLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import platform.common.MdMarkup;
import platform.common.Unfurl;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u001c\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001*\u00020\u000f\u001a \u0010\u0010\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0001*\u00020\u000fH\u0002\u001a\"\u0010\u0011\u001a\u00020\u0012*\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00022\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u001a\u0012\u0010\u0017\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019\" \u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0011\u0010\t\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0011\u0010\f\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u001a"}, d2={"defCalcResult", "Lkotlin/Triple;", "Lcirclet/todo/TodoItemCategory;", "", "", "knownCategories", "", "getKnownCategories", "()Ljava/util/Map;", "todoItemAllCategory", "getTodoItemAllCategory", "()Lcirclet/todo/TodoItemCategory;", "todoItemPlainCategory", "getTodoItemPlainCategory", "calcCategoryAndLinkAndSortingKey", "Lcirclet/client/api/TodoItemRecord;", "calcCategoryFromLightContent", "filter", "Lcirclet/todo/TodoListVmTreeModel;", "category", "onEmpty", "Lkotlin/Function0;", "", "filterPart", "open", "", "app-state"})
public final class TodoItemCategoryKt {
    @NotNull
    private static final TodoItemCategory todoItemAllCategory = new TodoItemCategory("all", 0, new CategoryPresentation("All", null), true);
    @NotNull
    private static final TodoItemCategory todoItemPlainCategory = new TodoItemCategory("task", 50, new CategoryPresentation("Tasks", CircletFontIconTypeface.INSTANCE.getEDIT()), false, 8, null);
    @NotNull
    private static final Map<String, TodoItemCategory> knownCategories;
    @NotNull
    private static final Triple<TodoItemCategory, String, Integer> defCalcResult;

    @NotNull
    public static final TodoItemCategory getTodoItemAllCategory() {
        return todoItemAllCategory;
    }

    @NotNull
    public static final TodoItemCategory getTodoItemPlainCategory() {
        return todoItemPlainCategory;
    }

    @NotNull
    public static final Map<String, TodoItemCategory> getKnownCategories() {
        return knownCategories;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Triple<TodoItemCategory, String, Integer> calcCategoryAndLinkAndSortingKey(@NotNull TodoItemRecord $this$calcCategoryAndLinkAndSortingKey) {
        Intrinsics.checkNotNullParameter((Object)$this$calcCategoryAndLinkAndSortingKey, (String)"<this>");
        Triple<TodoItemCategory, String, Integer> light = TodoItemCategoryKt.calcCategoryFromLightContent($this$calcCategoryAndLinkAndSortingKey);
        if (light != null) {
            return light;
        }
        KLogger $this$catch$iv = TodoEditorVmKt.getLog();
        boolean $i$f$catch = false;
        KLogger $this$internalCatch_u24default$iv$iv = $this$catch$iv;
        List except$iv$iv = CollectionsKt.emptyList();
        boolean $i$f$internalCatch = false;
        try {
            List list2;
            List list3;
            boolean bl = false;
            TodoItemContent todoItemContent = $this$calcCategoryAndLinkAndSortingKey.getContent();
            TodoItemContentMdText todoItemContentMdText = todoItemContent instanceof TodoItemContentMdText ? (TodoItemContentMdText)todoItemContent : null;
            if (todoItemContentMdText == null) {
                list3 = null;
            } else {
                MdMarkup mdMarkup = todoItemContentMdText.getMdMarkup();
                list3 = list2 = mdMarkup == null ? null : mdMarkup.getUnfurl();
            }
            if (list3 == null) {
                list2 = CollectionsKt.emptyList();
            }
            List mdMarkup = list2;
            TodoItemCategory category = null;
            String link = null;
            Iterable $this$forEach$iv = mdMarkup;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string2;
                Unfurl it = (Unfurl)element$iv;
                boolean bl2 = false;
                String $this$calcCategoryAndLinkAndSortingKey_u24lambda_u2d4_u24lambda_u2d2_u24lambda_u2d1 = string2 = it.getLink();
                boolean bl3 = false;
                Map<String, TodoItemCategory> $this$forEach$iv2 = TodoItemCategoryKt.getKnownCategories();
                boolean $i$f$forEach2 = false;
                Iterator<Map.Entry<String, TodoItemCategory>> iterator2 = $this$forEach$iv2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<String, TodoItemCategory> element$iv2;
                    Map.Entry<String, TodoItemCategory> it2 = element$iv2 = iterator2.next();
                    boolean bl4 = false;
                    if (!StringsKt.contains$default((CharSequence)$this$calcCategoryAndLinkAndSortingKey_u24lambda_u2d4_u24lambda_u2d2_u24lambda_u2d1, (CharSequence)('/' + it2.getKey() + '/'), (boolean)false, (int)2, null)) continue;
                    if (category != null) {
                        return defCalcResult;
                    }
                    category = it2.getValue();
                    link = $this$calcCategoryAndLinkAndSortingKey_u24lambda_u2d4_u24lambda_u2d2_u24lambda_u2d1;
                }
            }
            TodoItemCategory res = category;
            if (res != null) {
                String string3 = link;
                if (string3 == null) {
                    string3 = "";
                }
                return new Triple((Object)res, (Object)string3, (Object)res.getPriority());
            }
            String text2 = $this$calcCategoryAndLinkAndSortingKey.getContent().display();
            Map<String, TodoItemCategory> $this$forEach$iv3 = TodoItemCategoryKt.getKnownCategories();
            boolean $i$f$forEach3 = false;
            Iterator<Map.Entry<String, TodoItemCategory>> iterator3 = $this$forEach$iv3.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry<String, TodoItemCategory> element$iv;
                Map.Entry<String, TodoItemCategory> it = element$iv = iterator3.next();
                boolean bl5 = false;
                if (!StringsKt.contains$default((CharSequence)text2, (CharSequence)('/' + it.getKey() + '/'), (boolean)false, (int)2, null)) continue;
                return new Triple((Object)it.getValue(), (Object)"", (Object)it.getValue().getPriority());
            }
            return defCalcResult;
        }
        catch (Throwable th$iv$iv) {
            void th$iv;
            boolean bl;
            block17: {
                boolean $i$f$isCancellationException = false;
                if (th$iv$iv instanceof InterruptedException || th$iv$iv instanceof CancellationException) {
                    throw th$iv$iv;
                }
                Iterable $this$any$iv$iv$iv = except$iv$iv;
                boolean $i$f$any = false;
                if ($this$any$iv$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv$iv$iv : $this$any$iv$iv$iv) {
                        KClass it$iv$iv = (KClass)element$iv$iv$iv;
                        boolean bl6 = false;
                        if (!it$iv$iv.isInstance((Object)th$iv$iv)) continue;
                        bl = true;
                        break block17;
                    }
                    bl = false;
                }
            }
            if (bl) {
                throw th$iv$iv;
            }
            Throwable throwable = th$iv$iv;
            KLogger $this$catch_u24lambda_u2d0$iv = $this$internalCatch_u24default$iv$iv;
            boolean bl7 = false;
            BaseLogger.DefaultImpls.error$default($this$catch_u24lambda_u2d0$iv, (Throwable)th$iv, null, 2, null);
            return defCalcResult;
        }
    }

    private static final Triple<TodoItemCategory, String, Integer> calcCategoryFromLightContent(TodoItemRecord $this$calcCategoryFromLightContent) {
        Triple triple;
        TodoItemContent todoItemContent = $this$calcCategoryFromLightContent.getContent();
        TodoContent todoContent = todoItemContent instanceof TodoContent ? (TodoContent)todoItemContent : null;
        if (todoContent == null) {
            return null;
        }
        TodoContent content2 = todoContent;
        TodoItemContentKind todoItemContentKind = content2.getKind();
        if (todoItemContentKind == null) {
            todoItemContentKind = TodoItemContentKind.NONE;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[todoItemContentKind.ordinal()]) {
            case 1: {
                triple = defCalcResult;
                break;
            }
            case 2: {
                triple = defCalcResult;
                break;
            }
            case 3: {
                TodoItemCategory todoItemCategory = KnownCategories.INSTANCE.getChat();
                String string2 = content2.getLink();
                if (string2 == null) {
                    string2 = "";
                }
                triple = new Triple((Object)todoItemCategory, (Object)string2, (Object)KnownCategories.INSTANCE.getChat().getPriority());
                break;
            }
            case 4: {
                TodoItemCategory todoItemCategory = KnownCategories.INSTANCE.getIssue();
                String string3 = content2.getLink();
                if (string3 == null) {
                    string3 = "";
                }
                triple = new Triple((Object)todoItemCategory, (Object)string3, (Object)KnownCategories.INSTANCE.getIssue().getPriority());
                break;
            }
            case 5: {
                TodoItemCategory todoItemCategory = KnownCategories.INSTANCE.getBlog();
                String string4 = content2.getLink();
                if (string4 == null) {
                    string4 = "";
                }
                triple = new Triple((Object)todoItemCategory, (Object)string4, (Object)KnownCategories.INSTANCE.getBlog().getPriority());
                break;
            }
            case 6: {
                TodoItemCategory todoItemCategory = KnownCategories.INSTANCE.getDocument();
                String string5 = content2.getLink();
                if (string5 == null) {
                    string5 = "";
                }
                triple = new Triple((Object)todoItemCategory, (Object)string5, (Object)KnownCategories.INSTANCE.getDocument().getPriority());
                break;
            }
            case 7: {
                TodoItemCategory todoItemCategory = KnownCategories.INSTANCE.getMeeting();
                String string6 = content2.getLink();
                if (string6 == null) {
                    string6 = "";
                }
                triple = new Triple((Object)todoItemCategory, (Object)string6, (Object)KnownCategories.INSTANCE.getDocument().getPriority());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Triple res = triple;
        return res;
    }

    @NotNull
    public static final TodoListVmTreeModel filter(@NotNull TodoListVmTreeModel $this$filter, @Nullable TodoItemCategory category, @NotNull Function0<Unit> onEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$filter, (String)"<this>");
        Intrinsics.checkNotNullParameter(onEmpty, (String)"onEmpty");
        try {
            if (category == null || Intrinsics.areEqual((Object)category, (Object)todoItemAllCategory)) {
                return $this$filter;
            }
            Map items2 = new LinkedHashMap();
            Map<TodoEditorGroup, List<TodoListItemVm>> $this$forEach$iv = $this$filter.getTree();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<TodoEditorGroup, List<TodoListItemVm>>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<TodoEditorGroup, List<TodoListItemVm>> element$iv;
                Map.Entry<TodoEditorGroup, List<TodoListItemVm>> it = element$iv = iterator2.next();
                boolean bl = false;
                TodoEditorGroup group = it.getKey();
                Iterable $this$forEach$iv2 = it.getValue();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Object object;
                    TodoListItemVm it2 = (TodoListItemVm)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it2.getCategory().getName(), (Object)category.getName())) continue;
                    Map $this$getOrPut$iv = items2;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(group);
                    if (value$iv == null) {
                        boolean bl3 = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv.put(group, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((List)object).add(it2);
                }
            }
            if (items2.isEmpty()) {
                onEmpty.invoke();
                return $this$filter;
            }
            return new TodoListVmTreeModel(items2);
        }
        catch (Exception e) {
            TodoEditorVmInitialized.Companion.getLogger().error((Throwable)e, "filter");
            return $this$filter;
        }
    }

    @NotNull
    public static final TodoListVmTreeModel filterPart(@NotNull TodoListVmTreeModel $this$filterPart, boolean open2) {
        Intrinsics.checkNotNullParameter((Object)$this$filterPart, (String)"<this>");
        Map items2 = new LinkedHashMap();
        Map<TodoEditorGroup, List<TodoListItemVm>> $this$forEach$iv = $this$filterPart.getTree();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<TodoEditorGroup, List<TodoListItemVm>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<TodoEditorGroup, List<TodoListItemVm>> element$iv;
            Map.Entry<TodoEditorGroup, List<TodoListItemVm>> it = element$iv = iterator2.next();
            boolean bl = false;
            TodoEditorGroup group = it.getKey();
            Iterable $this$forEach$iv2 = it.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object object;
                TodoListItemVm it2 = (TodoListItemVm)element$iv2;
                boolean bl2 = false;
                TodoStatus status2 = it2.getRecord().getStatus();
                if ((!open2 || status2 != TodoStatus.Open) && (open2 || status2 != TodoStatus.Closed)) continue;
                Map $this$getOrPut$iv = items2;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(group);
                if (value$iv == null) {
                    boolean bl3 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(group, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(it2);
            }
        }
        return new TodoListVmTreeModel(items2);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"blog", (Object)KnownCategories.INSTANCE.getBlog()), TuplesKt.to((Object)"im", (Object)KnownCategories.INSTANCE.getChat()), TuplesKt.to((Object)"issues", (Object)KnownCategories.INSTANCE.getIssue()), TuplesKt.to((Object)KnownCategories.INSTANCE.getYoutrackJb().getName(), (Object)KnownCategories.INSTANCE.getYoutrackJb())};
        knownCategories = MapsKt.mapOf((Pair[])pairArray);
        defCalcResult = new Triple((Object)todoItemPlainCategory, (Object)"", (Object)todoItemPlainCategory.getPriority());
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TodoItemContentKind.values().length];
            nArray[TodoItemContentKind.NONE.ordinal()] = 1;
            nArray[TodoItemContentKind.REGULAR.ordinal()] = 2;
            nArray[TodoItemContentKind.MESSAGE.ordinal()] = 3;
            nArray[TodoItemContentKind.ISSUE.ordinal()] = 4;
            nArray[TodoItemContentKind.BLOG.ordinal()] = 5;
            nArray[TodoItemContentKind.DOCUMENT.ordinal()] = 6;
            nArray[TodoItemContentKind.MEETING.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

