/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.gateway.auth;

import com.intellij.collaboration.auth.services.OAuthRequest;
import com.intellij.collaboration.auth.services.PkceUtils;
import com.intellij.space.gateway.auth.SpaceGatewayCredentialsAcquirer;
import com.intellij.space.gateway.auth.SpaceGatewayOAuthDatedCredentials;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.CharRange;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0004H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/intellij/space/gateway/auth/SpaceGatewayOAuthRequest;", "Lcom/intellij/collaboration/auth/services/OAuthRequest;", "Lcom/intellij/space/gateway/auth/SpaceGatewayOAuthDatedCredentials;", "server", "", "(Ljava/lang/String;)V", "authUrlWithParameters", "Lcom/intellij/util/Url;", "getAuthUrlWithParameters", "()Lcom/intellij/util/Url;", "authorizationCodeUrl", "getAuthorizationCodeUrl", "codeVerifier", "credentialsAcquirer", "Lcom/intellij/space/gateway/auth/SpaceGatewayCredentialsAcquirer;", "getCredentialsAcquirer", "()Lcom/intellij/space/gateway/auth/SpaceGatewayCredentialsAcquirer;", "generateCodeChallenge", "Companion", "intellij.space.gateway"})
public final class SpaceGatewayOAuthRequest
implements OAuthRequest<SpaceGatewayOAuthDatedCredentials> {
    private final String codeVerifier;
    @NotNull
    private final Url authorizationCodeUrl;
    @NotNull
    private final Url authUrlWithParameters;
    @NotNull
    private final SpaceGatewayCredentialsAcquirer credentialsAcquirer;
    @NotNull
    public static final String CLIENT_ID = "gateway-space-integration";
    private static final int STRING_LENGTH = 64;
    private static final List<Character> charPool;
    @NotNull
    public static final String authorizationCodeUrlRaw = "jetbrains-gateway://spaceAuth";
    @NotNull
    public static final Companion Companion;

    @NotNull
    public Url getAuthorizationCodeUrl() {
        return this.authorizationCodeUrl;
    }

    @NotNull
    public Url getAuthUrlWithParameters() {
        return this.authUrlWithParameters;
    }

    @NotNull
    public SpaceGatewayCredentialsAcquirer getCredentialsAcquirer() {
        return this.credentialsAcquirer;
    }

    /*
     * WARNING - void declaration
     */
    private final String generateCodeChallenge() {
        String string2;
        block1: {
            void var2_2;
            Base64.Encoder encoder = Base64.getEncoder();
            Intrinsics.checkNotNullExpressionValue((Object)encoder, (String)"Base64.getEncoder()");
            String base64 = PkceUtils.INSTANCE.generateShaCodeChallenge(this.codeVerifier, encoder);
            String $this$takeWhile$iv = StringsKt.replace$default((String)StringsKt.replace$default((String)base64, (char)'+', (char)'-', (boolean)false, (int)4, null), (char)'/', (char)'_', (boolean)false, (int)4, null);
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (it != '=') continue;
                String string3 = $this$takeWhile$iv;
                int n2 = 0;
                String string4 = string3.substring(n2, index$iv);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                break block1;
            }
            string2 = var2_2;
        }
        return string2;
    }

    public SpaceGatewayOAuthRequest(@NotNull String server2) {
        Intrinsics.checkNotNullParameter((Object)server2, (String)"server");
        this.codeVerifier = SpaceGatewayOAuthRequest.Companion.generateRandomVerifier();
        this.authorizationCodeUrl = Urls.newFromEncoded((String)authorizationCodeUrlRaw);
        Url url2 = Urls.newFromEncoded((String)(server2 + "/oauth/auth")).addParameters(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"response_type", (Object)"code"), TuplesKt.to((Object)"client_id", (Object)CLIENT_ID), TuplesKt.to((Object)"redirect_uri", (Object)this.getAuthorizationCodeUrl().toExternalForm()), TuplesKt.to((Object)"scope", (Object)"**"), TuplesKt.to((Object)"access_type", (Object)"offline"), TuplesKt.to((Object)"code_challenge", (Object)this.generateCodeChallenge()), TuplesKt.to((Object)"code_challenge_method", (Object)"S256")}));
        Intrinsics.checkNotNullExpressionValue((Object)url2, (String)"Urls.newFromEncoded(\"$se\u2026e_method\" to \"S256\",\n  ))");
        this.authUrlWithParameters = url2;
        this.credentialsAcquirer = new SpaceGatewayCredentialsAcquirer(server2, this.codeVerifier, authorizationCodeUrlRaw);
    }

    static {
        Companion = new Companion(null);
        char c = 'a';
        CharRange charRange = new CharRange(c, 'z');
        c = 'A';
        CharRange charRange2 = new CharRange(c, 'Z');
        c = '0';
        charPool = CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)charRange), (Iterable)((Iterable)charRange2)), (Iterable)((Iterable)new CharRange(c, '9')));
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\f\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/space/gateway/auth/SpaceGatewayOAuthRequest$Companion;", "", "()V", "CLIENT_ID", "", "STRING_LENGTH", "", "authorizationCodeUrlRaw", "charPool", "", "", "generateRandomVerifier", "intellij.space.gateway"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final String generateRandomVerifier() {
            void $this$mapTo$iv$iv;
            Constable constable;
            int n;
            Collection collection;
            void $this$mapTo$iv$iv2;
            int n2 = 1;
            Iterable $this$map$iv = (Iterable)new IntRange(n2, 64);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                int item$iv$iv;
                int n3 = item$iv$iv = ((IntIterator)iterator2).nextInt();
                collection = destination$iv$iv;
                n = 0;
                constable = Random.Default.nextInt(0, charPool.size());
                collection.add(constable);
            }
            $this$map$iv = (List)destination$iv$iv;
            List list2 = charPool;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p1;
                n = ((Number)item$iv$iv).intValue();
                collection = destination$iv$iv2;
                boolean bl = false;
                constable = Character.valueOf(((Character)list2.get((int)p1)).charValue());
                collection.add(constable);
            }
            String value2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            return value2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

