/*
 * Decompiled with CFR 0.152.
 */
package libraries.io.blobs;

import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.security.MessageDigest;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import libraries.io.blobs.BlobUtils;
import libraries.io.blobs.ContentDigest;
import libraries.io.blobs.MessageDigestPool;
import libraries.io.blobs.MessageDigestsPools;
import libraries.io.channels.ByteBufferPoolKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0002J\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000eJ\u0016\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0017J\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Llibraries/io/blobs/BlobUtils;", "", "()V", "sha256Pool", "Llibraries/io/blobs/MessageDigestPool;", "getSha256Pool", "()Llibraries/io/blobs/MessageDigestPool;", "sha256Pool$delegate", "Lkotlin/Lazy;", "computeDigest", "Llibraries/io/blobs/ContentDigest;", "pool", "action", "Lkotlin/Function1;", "Ljava/security/MessageDigest;", "", "getDigest", "messageDigest", "algorithm", "", "content", "", "getSha256Digest", "Ljava/nio/channels/ReadableByteChannel;", "libraries-io"})
public final class BlobUtils {
    @NotNull
    public static final BlobUtils INSTANCE = new BlobUtils();
    @NotNull
    private static final Lazy sha256Pool$delegate = LazyKt.lazy((Function0)sha256Pool.2.INSTANCE);

    private BlobUtils() {
    }

    private final MessageDigestPool getSha256Pool() {
        Lazy lazy = sha256Pool$delegate;
        return (MessageDigestPool)((Object)lazy.getValue());
    }

    @NotNull
    public final ContentDigest getDigest(@NotNull String algorithm, @NotNull byte[] content2) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        MessageDigestPool digestPool = MessageDigestsPools.INSTANCE.getPool(algorithm);
        return this.computeDigest(digestPool, (Function1<? super MessageDigest, Unit>)((Function1)new Function1<MessageDigest, Unit>(content2){
            final /* synthetic */ byte[] $content;
            {
                this.$content = $content;
                super(1);
            }

            public final void invoke(@NotNull MessageDigest messageDigest) {
                Intrinsics.checkNotNullParameter((Object)messageDigest, (String)"messageDigest");
                messageDigest.update(this.$content);
            }
        }));
    }

    @NotNull
    public final ContentDigest getSha256Digest(@NotNull byte[] content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        return this.computeDigest(this.getSha256Pool(), (Function1<? super MessageDigest, Unit>)((Function1)new Function1<MessageDigest, Unit>(content2){
            final /* synthetic */ byte[] $content;
            {
                this.$content = $content;
                super(1);
            }

            public final void invoke(@NotNull MessageDigest messageDigest) {
                Intrinsics.checkNotNullParameter((Object)messageDigest, (String)"messageDigest");
                messageDigest.update(this.$content);
            }
        }));
    }

    @NotNull
    public final ContentDigest getSha256Digest(@NotNull ReadableByteChannel content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        return this.computeDigest(this.getSha256Pool(), (Function1<? super MessageDigest, Unit>)((Function1)new Function1<MessageDigest, Unit>(content2){
            final /* synthetic */ ReadableByteChannel $content;
            {
                this.$content = $content;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull MessageDigest messageDigest) {
                Intrinsics.checkNotNullParameter((Object)messageDigest, (String)"messageDigest");
                ByteBuffer buffer2 = (ByteBuffer)ByteBufferPoolKt.getIoByteBufferPool().borrow();
                try {
                    while (true) {
                        buffer2.clear();
                        int readCount = this.$content.read(buffer2);
                        if (readCount < 0) {
                            break;
                        }
                        if (readCount == 0) continue;
                        buffer2.flip();
                        messageDigest.update(buffer2);
                    }
                }
                finally {
                    this.$content.close();
                    ByteBufferPoolKt.getIoByteBufferPool().recycle((Object)buffer2);
                }
            }
        }));
    }

    @NotNull
    public final ContentDigest getDigest(@NotNull MessageDigest messageDigest) {
        Intrinsics.checkNotNullParameter((Object)messageDigest, (String)"messageDigest");
        byte[] value2 = messageDigest.digest();
        messageDigest.reset();
        String string2 = messageDigest.getAlgorithm();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"messageDigest.algorithm");
        Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"value");
        return new ContentDigest(string2, value2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ContentDigest computeDigest(MessageDigestPool pool, Function1<? super MessageDigest, Unit> action2) {
        MessageDigest messageDigest = (MessageDigest)pool.borrow();
        try {
            action2.invoke((Object)messageDigest);
            ContentDigest contentDigest = this.getDigest(messageDigest);
            return contentDigest;
        }
        finally {
            pool.recycle(messageDigest);
        }
    }
}

