/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.ContentManager;
import git4idea.GitVcs;
import git4idea.i18n.GitBundle;
import git4idea.log.GitShowExternalLogAction;
import git4idea.log.GitShowExternalLogActionKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lgit4idea/log/GitShowExternalLogAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.vcs.git"})
public final class GitShowExternalLogAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getRequiredData(CommonDataKeys.PROJECT);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getRequiredData(CommonDataKeys.PROJECT)");
        Project project = (Project)object;
        GitVcs gitVcs = GitVcs.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitVcs), (String)"GitVcs.getInstance(project)");
        GitVcs vcs = gitVcs;
        List roots = GitShowExternalLogActionKt.access$getGitRootsFromUser(project);
        if (roots.isEmpty()) {
            return;
        }
        ToolWindow window = ToolWindowManager.Companion.getInstance(project).getToolWindow("Version Control");
        if (project.isDefault() || !ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss() || window == null) {
            String string = GitBundle.message("git.log.external.window.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"git.log.external.window.title\")");
            GitShowExternalLogActionKt.showExternalGitLogInDialog(project, vcs, roots, string);
        } else {
            String string = GitBundle.message("git.log.external.tab.description", CollectionsKt.joinToString$default((Iterable)roots, (CharSequence)"\n", null, null, (int)0, null, (Function1)actionPerformed.description.1.INSTANCE, (int)30, null));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"git.l\u2026irtualFile -> obj.path })");
            String description2 = string;
            ContentManager contentManager = window.getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"window.contentManager");
            GitShowExternalLogActionKt.showExternalGitLogInToolwindow(project, window, vcs, roots, GitShowExternalLogActionKt.access$calcTabName(contentManager, roots), description2);
        }
    }
}

