/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import com.intellij.dvcs.branch.DvcsBranchSettings;
import com.intellij.dvcs.branch.DvcsBranchSettingsKt;
import com.intellij.dvcs.branch.GroupingKey;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.FixingLayoutMatcher;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.FilteringTree;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.FList;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.dashboard.BranchInfo;
import git4idea.ui.branch.dashboard.BranchNodeDescriptor;
import git4idea.ui.branch.dashboard.BranchTreeNode;
import git4idea.ui.branch.dashboard.BranchesDashboardActions;
import git4idea.ui.branch.dashboard.BranchesDashboardController;
import git4idea.ui.branch.dashboard.BranchesTreeComponent;
import git4idea.ui.branch.dashboard.BranchesTreeStateHolder;
import git4idea.ui.branch.dashboard.BranchesTreeStateProvider;
import git4idea.ui.branch.dashboard.FilteringBranchesTree;
import git4idea.ui.branch.dashboard.FilteringBranchesTree$WhenMappings;
import git4idea.ui.branch.dashboard.NodeDescriptorsModel;
import git4idea.ui.branch.dashboard.NodeType;
import git4idea.ui.branch.dashboard.RemoteInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B/\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0002\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010)\u001a\u00020\u00022\u0006\u0010*\u001a\u00020\u0003H\u0014J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0014J\u0012\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u000102H\u0014J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\u0003042\u0006\u0010*\u001a\u00020\u0003H\u0014J\u000e\u00105\u001a\b\u0012\u0004\u0012\u00020\u000206H\u0014J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020\u000308H\u0002J\f\u00109\u001a\b\u0012\u0004\u0012\u0002020:J\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00030<J\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00100:J\f\u0010>\u001a\b\u0012\u0004\u0012\u00020?0<J\u0014\u0010@\u001a\b\u0012\u0004\u0012\u00020A0:2\u0006\u0010B\u001a\u00020\u0010J\u0019\u0010C\u001a\t\u0018\u000102\u00a2\u0006\u0002\bD2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0014J\b\u0010E\u001a\u000200H\u0002J\b\u0010F\u001a\u00020.H\u0016J\b\u0010G\u001a\u00020\u0011H\u0002J\u000e\u0010H\u001a\u00020\u00112\u0006\u0010I\u001a\u00020\u0019J\u0012\u0010J\u001a\u0002002\b\u00101\u001a\u0004\u0018\u000102H\u0014J\u0006\u0010K\u001a\u000200J\u0006\u0010L\u001a\u000200J\b\u0010M\u001a\u000200H\u0002J\u001e\u0010N\u001a\u0002002\u0006\u0010O\u001a\u00020\u00112\f\u0010P\u001a\b\u0012\u0004\u0012\u0002000QH\u0002J\b\u0010R\u001a\u000200H\u0002J\u0016\u0010S\u001a\u0002002\u0006\u0010I\u001a\u00020\u00192\u0006\u0010T\u001a\u00020\u0011J\u000e\u0010U\u001a\u0002002\u0006\u0010V\u001a\u00020\u0011J\b\u0010W\u001a\u000200H\u0002J\b\u0010X\u001a\u00020\u0011H\u0014J\u0012\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00030<*\u00020\u0003H\u0002R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00110\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lgit4idea/ui/branch/dashboard/FilteringBranchesTree;", "Lcom/intellij/ui/FilteringTree;", "Lgit4idea/ui/branch/dashboard/BranchTreeNode;", "Lgit4idea/ui/branch/dashboard/BranchNodeDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "component", "Lgit4idea/ui/branch/dashboard/BranchesTreeComponent;", "uiController", "Lgit4idea/ui/branch/dashboard/BranchesDashboardController;", "rootNode", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lgit4idea/ui/branch/dashboard/BranchesTreeComponent;Lgit4idea/ui/branch/dashboard/BranchesDashboardController;Lgit4idea/ui/branch/dashboard/BranchTreeNode;Lcom/intellij/openapi/Disposable;)V", "branchFilter", "Lkotlin/Function1;", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "", "getComponent", "()Lgit4idea/ui/branch/dashboard/BranchesTreeComponent;", "expandedPaths", "Ljava/util/HashSet;", "Ljavax/swing/tree/TreePath;", "groupingConfig", "", "Lcom/intellij/dvcs/branch/GroupingKey;", "headBranchesNode", "localBranchesNode", "localNodeExist", "nodeDescriptorsModel", "Lgit4idea/ui/branch/dashboard/NodeDescriptorsModel;", "getProject", "()Lcom/intellij/openapi/project/Project;", "remoteBranchesNode", "remoteNodeExist", "treeStateHolder", "Lgit4idea/ui/branch/dashboard/BranchesTreeStateHolder;", "getTreeStateHolder", "()Lgit4idea/ui/branch/dashboard/BranchesTreeStateHolder;", "treeStateProvider", "Lgit4idea/ui/branch/dashboard/BranchesTreeStateProvider;", "createNode", "nodeDescriptor", "createSpeedSearch", "Lcom/intellij/ui/speedSearch/SpeedSearchSupply;", "searchTextField", "Lcom/intellij/ui/SearchTextField;", "expandTreeOnSearchUpdateComplete", "", "pattern", "", "getChildren", "", "getNodeClass", "Ljava/lang/Class;", "getRootNodeDescriptors", "", "getSelectedBranchFilters", "", "getSelectedBranchNodes", "", "getSelectedBranches", "getSelectedRemotes", "Lgit4idea/ui/branch/dashboard/RemoteInfo;", "getSelectedRepositories", "Lgit4idea/repo/GitRepository;", "branchInfo", "getText", "Lcom/intellij/openapi/util/NlsSafe;", "initDefaultTreeExpandState", "installSearchField", "isEmptyModel", "isGroupingEnabled", "key", "onSpeedSearchUpdateComplete", "refreshNodeDescriptorsModel", "refreshTree", "restorePreviouslyExpandedPaths", "runPreservingTreeState", "loadSaved", "runnable", "Lkotlin/Function0;", "setupTreeListeners", "toggleGrouping", "state", "update", "initial", "updateSpeedSearchBackground", "useIdentityHashing", "getDirectChildren", "intellij.vcs.git"})
public final class FilteringBranchesTree
extends FilteringTree<BranchTreeNode, BranchNodeDescriptor> {
    private final HashSet<TreePath> expandedPaths;
    private final BranchTreeNode localBranchesNode;
    private final BranchTreeNode remoteBranchesNode;
    private final BranchTreeNode headBranchesNode;
    private final Function1<BranchInfo, Boolean> branchFilter;
    private final NodeDescriptorsModel nodeDescriptorsModel;
    private boolean localNodeExist;
    private boolean remoteNodeExist;
    private final BranchesTreeStateProvider treeStateProvider;
    private final Map<GroupingKey, Boolean> groupingConfig;
    @NotNull
    private final Project project;
    @NotNull
    private final BranchesTreeComponent component;
    private final BranchesDashboardController uiController;

    private final BranchesTreeStateHolder getTreeStateHolder() {
        Project $this$service$iv = this.project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(BranchesTreeStateHolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        return (BranchesTreeStateHolder)object;
    }

    public final void toggleGrouping(@NotNull GroupingKey key, boolean state) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.groupingConfig.put(key, state);
        this.refreshTree();
    }

    public final boolean isGroupingEnabled(@NotNull GroupingKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return Intrinsics.areEqual((Object)this.groupingConfig.get(key), (Object)true);
    }

    @NotNull
    protected SpeedSearchSupply createSpeedSearch(@NotNull SearchTextField searchTextField) {
        Intrinsics.checkNotNullParameter((Object)searchTextField, (String)"searchTextField");
        return (SpeedSearchSupply)new FilteringTree.FilteringSpeedSearch(this, searchTextField, searchTextField){
            private final HashSet<MinusculeMatcher> customWordMatchers;
            final /* synthetic */ FilteringBranchesTree this$0;
            final /* synthetic */ SearchTextField $searchTextField;

            @Nullable
            public Iterable<TextRange> matchingFragments(@NotNull String text) {
                Collection collection;
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Iterable allTextRanges = super.matchingFragments(text);
                if (this.customWordMatchers.isEmpty()) {
                    return allTextRanges;
                }
                ArrayList<E> wordRanges = new ArrayList<E>();
                for (MinusculeMatcher wordMatcher : this.customWordMatchers) {
                    FList fList;
                    if (wordMatcher.matchingFragments(text) == null) continue;
                    Collection p1 = (Collection)fList;
                    boolean bl = false;
                    wordRanges.addAll(p1);
                }
                return allTextRanges != null ? (Iterable<T>)CollectionsKt.plus((Iterable)allTextRanges, (Iterable)wordRanges) : (!(collection = (Collection)wordRanges).isEmpty() ? (Iterable)wordRanges : null);
            }

            public void updatePattern(@Nullable String string) {
                super.updatePattern(string);
                this.onUpdatePattern(string);
            }

            protected void onUpdatePattern(@Nullable String text) {
                this.customWordMatchers.clear();
                this.customWordMatchers.addAll((Collection<MinusculeMatcher>)this.buildCustomWordMatchers(text));
            }

            private final Set<MinusculeMatcher> buildCustomWordMatchers(String text) {
                if (text == null) {
                    return SetsKt.emptySet();
                }
                HashSet<FixingLayoutMatcher> wordMatchers = new HashSet<FixingLayoutMatcher>();
                for (String word : StringUtil.split((String)text, (String)" ")) {
                    wordMatchers.add(new FixingLayoutMatcher("*" + word, NameUtil.MatchingCaseSensitivity.NONE, ""));
                }
                return wordMatchers;
            }
            {
                this.this$0 = this$0;
                this.$searchTextField = $captured_local_variable$1;
                super((FilteringTree)this$0, $super_call_param$2);
                this.customWordMatchers = new HashSet<E>();
            }
        };
    }

    @NotNull
    public SearchTextField installSearchField() {
        SearchTextField searchTextField = super.installSearchField();
        Intrinsics.checkNotNullExpressionValue((Object)searchTextField, (String)"super.installSearchField()");
        SearchTextField searchField = searchTextField;
        this.component.setSearchField(searchField);
        return searchField;
    }

    private final void setupTreeListeners() {
        this.component.addTreeExpansionListener(new TreeExpansionListener(this){
            final /* synthetic */ FilteringBranchesTree this$0;

            public void treeExpanded(@NotNull TreeExpansionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                FilteringBranchesTree.access$getExpandedPaths$p(this.this$0).add(event.getPath());
                FilteringBranchesTree.access$getTreeStateHolder$p(this.this$0).setStateProvider(FilteringBranchesTree.access$getTreeStateProvider$p(this.this$0));
            }

            public void treeCollapsed(@NotNull TreeExpansionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                FilteringBranchesTree.access$getExpandedPaths$p(this.this$0).remove(event.getPath());
                FilteringBranchesTree.access$getTreeStateHolder$p(this.this$0).setStateProvider(FilteringBranchesTree.access$getTreeStateProvider$p(this.this$0));
            }
            {
                this.this$0 = this$0;
            }
        });
        this.component.addTreeSelectionListener(new TreeSelectionListener(this){
            final /* synthetic */ FilteringBranchesTree this$0;

            public final void valueChanged(TreeSelectionEvent it) {
                FilteringBranchesTree.access$getTreeStateHolder$p(this.this$0).setStateProvider(FilteringBranchesTree.access$getTreeStateProvider$p(this.this$0));
            }
            {
                this.this$0 = filteringBranchesTree;
            }
        });
    }

    @NotNull
    public final List<GitRepository> getSelectedRepositories(@NotNull BranchInfo branchInfo) {
        Intrinsics.checkNotNullParameter((Object)branchInfo, (String)"branchInfo");
        Set<GitRepository> selectedRepositories = this.component.getSelectedRepositories(branchInfo);
        Collection collection = selectedRepositories;
        return !collection.isEmpty() ? CollectionsKt.toList((Iterable)selectedRepositories) : branchInfo.getRepositories();
    }

    @NotNull
    public final List<BranchInfo> getSelectedBranches() {
        return this.component.getSelectedBranches();
    }

    @NotNull
    public final List<String> getSelectedBranchFilters() {
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull(this.component.getSelectedNodes(), (Function1)getSelectedBranchFilters.1.INSTANCE));
    }

    @NotNull
    public final Set<RemoteInfo> getSelectedRemotes() {
        return this.component.getSelectedRemotes();
    }

    @NotNull
    public final Set<BranchNodeDescriptor> getSelectedBranchNodes() {
        return SequencesKt.toSet((Sequence)SequencesKt.map(this.component.getSelectedNodes(), (Function1)getSelectedBranchNodes.1.INSTANCE));
    }

    private final void restorePreviouslyExpandedPaths() {
        TreeUtil.restoreExpandedPaths((JTree)((JTree)((Object)this.component)), (List)CollectionsKt.toList((Iterable)this.expandedPaths));
    }

    protected void expandTreeOnSearchUpdateComplete(@Nullable String pattern) {
        this.restorePreviouslyExpandedPaths();
    }

    protected void onSpeedSearchUpdateComplete(@Nullable String pattern) {
        this.updateSpeedSearchBackground();
    }

    protected boolean useIdentityHashing() {
        return false;
    }

    private final void updateSpeedSearchBackground() {
        FilteringTree.SearchTreeModel searchTreeModel = this.getSearchModel();
        Intrinsics.checkNotNullExpressionValue((Object)searchTreeModel, (String)"searchModel");
        SpeedSearchSupply speedSearchSupply = searchTreeModel.getSpeedSearch();
        if (!(speedSearchSupply instanceof SpeedSearch)) {
            speedSearchSupply = null;
        }
        SpeedSearch speedSearch = (SpeedSearch)speedSearchSupply;
        if (speedSearch == null) {
            return;
        }
        SpeedSearch speedSearch2 = speedSearch;
        SearchTextField searchTextField = this.component.getSearchField();
        if (searchTextField == null || (searchTextField = searchTextField.getTextEditor()) == null) {
            return;
        }
        SearchTextField textEditor = searchTextField;
        if (this.isEmptyModel()) {
            textEditor.setOpaque(true);
            speedSearch2.noHits();
        } else {
            textEditor.setOpaque(false);
            textEditor.setBackground(UIUtil.getTextFieldBackground());
        }
    }

    private final boolean isEmptyModel() {
        return this.getSearchModel().isLeaf((Object)this.localBranchesNode) && this.getSearchModel().isLeaf((Object)this.remoteBranchesNode);
    }

    @NotNull
    protected Class<BranchTreeNode> getNodeClass() {
        return BranchTreeNode.class;
    }

    @NotNull
    protected BranchTreeNode createNode(@NotNull BranchNodeDescriptor nodeDescriptor) {
        BranchTreeNode branchTreeNode;
        Intrinsics.checkNotNullParameter((Object)nodeDescriptor, (String)"nodeDescriptor");
        switch (FilteringBranchesTree$WhenMappings.$EnumSwitchMapping$0[nodeDescriptor.getType().ordinal()]) {
            case 1: {
                branchTreeNode = this.localBranchesNode;
                break;
            }
            case 2: {
                branchTreeNode = this.remoteBranchesNode;
                break;
            }
            case 3: {
                branchTreeNode = this.headBranchesNode;
                break;
            }
            default: {
                branchTreeNode = new BranchTreeNode(nodeDescriptor);
            }
        }
        return branchTreeNode;
    }

    @NotNull
    protected Collection<BranchNodeDescriptor> getChildren(@NotNull BranchNodeDescriptor nodeDescriptor) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)nodeDescriptor, (String)"nodeDescriptor");
        switch (FilteringBranchesTree$WhenMappings.$EnumSwitchMapping$1[nodeDescriptor.getType().ordinal()]) {
            case 1: {
                collection = this.getRootNodeDescriptors();
                break;
            }
            case 2: {
                collection = this.getDirectChildren(this.localBranchesNode.getNodeDescriptor());
                break;
            }
            case 3: {
                collection = this.getDirectChildren(this.remoteBranchesNode.getNodeDescriptor());
                break;
            }
            case 4: {
                collection = this.getDirectChildren(nodeDescriptor);
                break;
            }
            case 5: {
                collection = this.getDirectChildren(nodeDescriptor);
                break;
            }
            default: {
                collection = CollectionsKt.emptyList();
            }
        }
        return collection;
    }

    private final Set<BranchNodeDescriptor> getDirectChildren(BranchNodeDescriptor $this$getDirectChildren) {
        return this.nodeDescriptorsModel.getChildrenForParent($this$getDirectChildren);
    }

    public final void update(boolean initial) {
        boolean branchesReloaded = this.uiController.reloadBranches();
        this.runPreservingTreeState(initial, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ FilteringBranchesTree this$0;

            public final void invoke() {
                this.this$0.getSearchModel().updateStructure();
            }
            {
                this.this$0 = filteringBranchesTree;
                super(0);
            }
        }));
        if (branchesReloaded) {
            this.getTree().revalidate();
            this.getTree().repaint();
        }
    }

    private final void runPreservingTreeState(boolean loadSaved, Function0<Unit> runnable2) {
        if (Registry.is((String)"git.branches.panel.persist.tree.state")) {
            TreeState treeState = loadSaved ? this.getTreeStateHolder().getInitialTreeState() : TreeState.createOn((JTree)((JTree)this.getTree()), (DefaultMutableTreeNode)this.getRoot());
            runnable2.invoke();
            if (treeState != null) {
                treeState.applyTo((JTree)this.getTree());
            } else {
                this.initDefaultTreeExpandState();
            }
        } else {
            runnable2.invoke();
            if (loadSaved) {
                this.initDefaultTreeExpandState();
            }
        }
    }

    private final void initDefaultTreeExpandState() {
        if (TreeUtil.hasManyNodes((Tree)this.getTree(), (int)30000)) {
            TreeUtil.collapseAll((JTree)((JTree)this.getTree()), (int)1);
        } else {
            TreeUtil.expandAll((JTree)((JTree)this.getTree()));
        }
    }

    public final void refreshTree() {
        this.runPreservingTreeState(false, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ FilteringBranchesTree this$0;

            public final void invoke() {
                Tree tree2 = this.this$0.getTree();
                Intrinsics.checkNotNullExpressionValue((Object)tree2, (String)"tree");
                tree2.getSelectionModel().clearSelection();
                this.this$0.refreshNodeDescriptorsModel();
                this.this$0.getSearchModel().updateStructure();
            }
            {
                this.this$0 = filteringBranchesTree;
                super(0);
            }
        }));
    }

    public final void refreshNodeDescriptorsModel() {
        BranchesDashboardController branchesDashboardController;
        BranchesDashboardController $this$with = branchesDashboardController = this.uiController;
        boolean bl = false;
        this.nodeDescriptorsModel.clear();
        Collection collection = $this$with.getLocalBranches();
        this.localNodeExist = !collection.isEmpty();
        collection = $this$with.getRemoteBranches();
        this.remoteNodeExist = !collection.isEmpty();
        this.nodeDescriptorsModel.populateFrom((Sequence<BranchInfo>)SequencesKt.filter((Sequence)SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)$this$with.getLocalBranches()), (Sequence)CollectionsKt.asSequence((Iterable)$this$with.getRemoteBranches())), this.branchFilter), this.groupingConfig);
    }

    @Nullable
    protected String getText(@Nullable BranchNodeDescriptor nodeDescriptor) {
        Object object = nodeDescriptor;
        if (object == null || (object = ((BranchNodeDescriptor)object).getBranchInfo()) == null || (object = ((BranchInfo)object).getBranchName()) == null) {
            BranchNodeDescriptor branchNodeDescriptor = nodeDescriptor;
            object = branchNodeDescriptor != null ? branchNodeDescriptor.getDisplayName() : null;
        }
        return object;
    }

    private final List<BranchNodeDescriptor> getRootNodeDescriptors() {
        List list2;
        List $this$apply = list2 = (List)new ArrayList();
        boolean bl = false;
        if (this.localNodeExist || this.remoteNodeExist) {
            $this$apply.add(this.headBranchesNode.getNodeDescriptor());
        }
        if (this.localNodeExist) {
            $this$apply.add(this.localBranchesNode.getNodeDescriptor());
        }
        if (this.remoteNodeExist) {
            $this$apply.add(this.remoteBranchesNode.getNodeDescriptor());
        }
        return list2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final BranchesTreeComponent getComponent() {
        return this.component;
    }

    /*
     * WARNING - void declaration
     */
    public FilteringBranchesTree(@NotNull Project project, @NotNull BranchesTreeComponent component2, @NotNull BranchesDashboardController uiController, @NotNull BranchTreeNode rootNode, @NotNull Disposable disposable) {
        Application app$iv;
        void $this$with;
        DvcsBranchSettings dvcsBranchSettings;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)component2), (String)"component");
        Intrinsics.checkNotNullParameter((Object)uiController, (String)"uiController");
        Intrinsics.checkNotNullParameter((Object)rootNode, (String)"rootNode");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        super((Tree)component2, (DefaultMutableTreeNode)rootNode);
        this.project = project;
        this.component = component2;
        this.uiController = uiController;
        this.expandedPaths = new HashSet();
        this.localBranchesNode = new BranchTreeNode(new BranchNodeDescriptor(NodeType.LOCAL_ROOT, null, null, null, null, 30, null));
        this.remoteBranchesNode = new BranchTreeNode(new BranchNodeDescriptor(NodeType.REMOTE_ROOT, null, null, null, null, 30, null));
        this.headBranchesNode = new BranchTreeNode(new BranchNodeDescriptor(NodeType.HEAD_NODE, null, null, null, null, 30, null));
        this.branchFilter = (Function1)new Function1<BranchInfo, Boolean>(this){
            final /* synthetic */ FilteringBranchesTree this$0;

            public final boolean invoke(@NotNull BranchInfo branch) {
                Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
                return !FilteringBranchesTree.access$getUiController$p(this.this$0).getShowOnlyMy() || branch.isMy() == ThreeState.YES;
            }
            {
                this.this$0 = filteringBranchesTree;
                super(1);
            }
        };
        this.nodeDescriptorsModel = new NodeDescriptorsModel(this.localBranchesNode.getNodeDescriptor(), this.remoteBranchesNode.getNodeDescriptor());
        this.treeStateProvider = new BranchesTreeStateProvider(this, disposable);
        GitVcsSettings gitVcsSettings = GitVcsSettings.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitVcsSettings), (String)"GitVcsSettings.getInstance(project)");
        DvcsBranchSettings dvcsBranchSettings2 = dvcsBranchSettings = gitVcsSettings.getBranchSettings();
        FilteringBranchesTree filteringBranchesTree = this;
        boolean bl = false;
        HashMap hashMap = MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)GroupingKey.GROUPING_BY_DIRECTORY, (Object)DvcsBranchSettingsKt.isGroupingEnabled((DvcsBranchSettings)$this$with, (GroupingKey)GroupingKey.GROUPING_BY_DIRECTORY)), TuplesKt.to((Object)GroupingKey.GROUPING_BY_REPOSITORY, (Object)DvcsBranchSettingsKt.isGroupingEnabled((DvcsBranchSettings)$this$with, (GroupingKey)GroupingKey.GROUPING_BY_REPOSITORY))});
        filteringBranchesTree.groupingConfig = hashMap;
        ModalityState modalityState$iv = null;
        boolean $i$f$runInEdt = false;
        Application application = app$iv = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
        if (application.isDispatchThread()) {
            boolean bl2 = false;
            PopupHandler.installPopupMenu((JComponent)((JComponent)((Object)this.getComponent())), (ActionGroup)new BranchesDashboardActions.BranchesTreeActionGroup(this.getProject(), this), (String)"BranchesTreePopup");
            this.setupTreeListeners();
        } else {
            boolean $i$f$invokeLater = false;
            Application application2 = ApplicationManager.getApplication();
            Runnable runnable2 = new Runnable(this){
                final /* synthetic */ FilteringBranchesTree this$0;
                {
                    this.this$0 = filteringBranchesTree;
                }

                public final void run() {
                    boolean bl = false;
                    PopupHandler.installPopupMenu((JComponent)((JComponent)((Object)this.this$0.getComponent())), (ActionGroup)new BranchesDashboardActions.BranchesTreeActionGroup(this.this$0.getProject(), this.this$0), (String)"BranchesTreePopup");
                    FilteringBranchesTree.access$setupTreeListeners(this.this$0);
                }
            };
            ModalityState modalityState = ModalityState.defaultModalityState();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
            application2.invokeLater(runnable2, modalityState);
        }
    }

    public /* synthetic */ FilteringBranchesTree(Project project, BranchesTreeComponent branchesTreeComponent, BranchesDashboardController branchesDashboardController, BranchTreeNode branchTreeNode, Disposable disposable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            branchTreeNode = new BranchTreeNode(new BranchNodeDescriptor(NodeType.ROOT, null, null, null, null, 30, null));
        }
        this(project, branchesTreeComponent, branchesDashboardController, branchTreeNode, disposable);
    }

    public static final /* synthetic */ HashSet access$getExpandedPaths$p(FilteringBranchesTree $this) {
        return $this.expandedPaths;
    }

    public static final /* synthetic */ BranchesTreeStateHolder access$getTreeStateHolder$p(FilteringBranchesTree $this) {
        return $this.getTreeStateHolder();
    }

    public static final /* synthetic */ BranchesTreeStateProvider access$getTreeStateProvider$p(FilteringBranchesTree $this) {
        return $this.treeStateProvider;
    }

    public static final /* synthetic */ BranchesDashboardController access$getUiController$p(FilteringBranchesTree $this) {
        return $this.uiController;
    }
}

