/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.ui;

import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.content.Content;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.jediterm.terminal.ProcessTtyConnector;
import com.jediterm.terminal.ui.TerminalWidgetListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalView;

public class TerminalContainer {
    private static final Logger LOG = Logger.getInstance(TerminalContainer.class);
    private final Content myContent;
    private final JBTerminalWidget myTerminalWidget;
    private final Project myProject;
    private final TerminalView myTerminalView;
    private JPanel myPanel;
    private boolean myForceHideUiWhenSessionEnds;
    private final TerminalWidgetListener myListener;

    public TerminalContainer(@NotNull Project project, @NotNull Content content, @NotNull JBTerminalWidget terminalWidget, @NotNull TerminalView terminalView) {
        if (project == null) {
            TerminalContainer.$$$reportNull$$$0(0);
        }
        if (content == null) {
            TerminalContainer.$$$reportNull$$$0(1);
        }
        if (terminalWidget == null) {
            TerminalContainer.$$$reportNull$$$0(2);
        }
        if (terminalView == null) {
            TerminalContainer.$$$reportNull$$$0(3);
        }
        this.myForceHideUiWhenSessionEnds = false;
        this.myProject = project;
        this.myContent = content;
        this.myTerminalWidget = terminalWidget;
        this.myTerminalView = terminalView;
        this.myPanel = TerminalContainer.createPanel(terminalWidget);
        this.myListener = widget -> ApplicationManager.getApplication().invokeLater(() -> this.processSessionCompleted(), this.myProject.getDisposed());
        terminalWidget.addListener(this.myListener);
        terminalView.register(this);
        Disposer.register((Disposable)content, () -> this.cleanup());
    }

    @NotNull
    public JBTerminalWidget getTerminalWidget() {
        JBTerminalWidget jBTerminalWidget = this.myTerminalWidget;
        if (jBTerminalWidget == null) {
            TerminalContainer.$$$reportNull$$$0(4);
        }
        return jBTerminalWidget;
    }

    @NotNull
    public Content getContent() {
        Content content = this.myContent;
        if (content == null) {
            TerminalContainer.$$$reportNull$$$0(5);
        }
        return content;
    }

    public void closeAndHide() {
        this.myForceHideUiWhenSessionEnds = true;
        if (this.myTerminalWidget.getTtyConnector().isConnected()) {
            this.myTerminalWidget.close();
        } else {
            this.processSessionCompleted();
        }
    }

    @NotNull
    private static JPanel createPanel(@NotNull JBTerminalWidget terminalWidget) {
        if (terminalWidget == null) {
            TerminalContainer.$$$reportNull$$$0(6);
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(null);
        panel.setFocusable(false);
        panel.add((Component)terminalWidget.getComponent(), "Center");
        JPanel jPanel = panel;
        if (jPanel == null) {
            TerminalContainer.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            TerminalContainer.$$$reportNull$$$0(8);
        }
        return jPanel;
    }

    public void split(boolean vertically, @NotNull JBTerminalWidget newTerminalWidget) {
        if (newTerminalWidget == null) {
            TerminalContainer.$$$reportNull$$$0(9);
        }
        boolean hasFocus = this.myTerminalWidget.getTerminalPanel().hasFocus();
        JPanel parent = this.myPanel;
        parent.remove(this.myTerminalWidget.getComponent());
        this.myPanel = TerminalContainer.createPanel(this.myTerminalWidget);
        Splitter splitter = TerminalContainer.createSplitter(vertically);
        splitter.setFirstComponent((JComponent)this.myPanel);
        TerminalContainer newContainer = new TerminalContainer(this.myProject, this.myContent, newTerminalWidget, this.myTerminalView);
        splitter.setSecondComponent(newContainer.getComponent());
        parent.add((Component)splitter, "Center");
        parent.revalidate();
        if (hasFocus) {
            this.requestFocus(this.myTerminalWidget);
        }
    }

    @NotNull
    private static Splitter createSplitter(boolean vertically) {
        OnePixelSplitter splitter = new OnePixelSplitter(vertically, 0.5f, 0.1f, 0.9f);
        splitter.setDividerWidth(JBUI.scale((int)1));
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        Color color = scheme.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
        if (color != null) {
            splitter.getDivider().setBackground(color);
        }
        OnePixelSplitter onePixelSplitter = splitter;
        if (onePixelSplitter == null) {
            TerminalContainer.$$$reportNull$$$0(10);
        }
        return onePixelSplitter;
    }

    private void processSessionCompleted() {
        Container parent = this.myPanel.getParent();
        if (parent instanceof Splitter) {
            JBTerminalWidget nextToFocus = null;
            if (this.myTerminalWidget.getTerminalPanel().hasFocus()) {
                nextToFocus = this.getNextSplitTerminal(true);
            }
            Splitter splitter = (Splitter)parent;
            parent = parent.getParent();
            JComponent otherComponent = this.myPanel.equals(splitter.getFirstComponent()) ? splitter.getSecondComponent() : splitter.getFirstComponent();
            Component realComponent = TerminalContainer.unwrapComponent(otherComponent);
            if (realComponent instanceof JBTerminalWidget) {
                TerminalContainer otherContainer = this.myTerminalView.getContainer((JBTerminalWidget)realComponent);
                otherContainer.myPanel = (JPanel)parent;
            }
            realComponent.getParent().remove(realComponent);
            parent.remove((Component)splitter);
            parent.add(realComponent, "Center");
            parent.revalidate();
            if (nextToFocus != null) {
                this.requestFocus(nextToFocus);
            }
            this.cleanup();
            Disposer.dispose((Disposable)this.myTerminalWidget);
        } else {
            this.processSingleTerminalCompleted();
        }
    }

    private void cleanup() {
        this.myTerminalWidget.removeListener(this.myListener);
        this.myTerminalView.unregister(this);
    }

    private void processSingleTerminalCompleted() {
        if (this.myForceHideUiWhenSessionEnds || TerminalOptionsProvider.getInstance().getCloseSessionOnLogout()) {
            this.myTerminalView.closeTab(this.myContent);
        } else {
            String text = TerminalContainer.getSessionCompletedMessage(this.myTerminalWidget);
            this.myTerminalWidget.writePlainMessage("\n" + text + "\n");
            this.myTerminalWidget.getTerminalPanel().setCursorVisible(false);
        }
    }

    @NotNull
    @Nls
    private static String getSessionCompletedMessage(@NotNull JBTerminalWidget widget) {
        if (widget == null) {
            TerminalContainer.$$$reportNull$$$0(11);
        }
        String text = "[" + TerminalBundle.message("session.terminated.text", new Object[0]) + "]";
        ProcessTtyConnector connector = ShellTerminalWidget.getProcessTtyConnector(widget.getTtyConnector());
        if (connector != null) {
            Integer exitCode = null;
            try {
                exitCode = connector.getProcess().exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
            String string = text + "\n[" + IdeCoreBundle.message((String)"finished.with.exit.code.text.message", (Object[])new Object[]{exitCode != null ? exitCode : "unknown"}) + "]";
            if (string == null) {
                TerminalContainer.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            TerminalContainer.$$$reportNull$$$0(13);
        }
        return string;
    }

    public boolean isSplitTerminal() {
        return this.findRootSplitter() != null;
    }

    @Nullable
    public JBTerminalWidget getNextSplitTerminal(boolean forward) {
        List<JBTerminalWidget> terminals = this.listTerminals();
        int ind = terminals.indexOf(this.myTerminalWidget);
        if (ind < 0) {
            LOG.error("All split terminal list (" + terminals.size() + ") doesn't contain this terminal");
            return null;
        }
        if (terminals.size() == 1) {
            return null;
        }
        int newInd = (ind + (forward ? 1 : terminals.size() - 1)) % terminals.size();
        return terminals.get(newInd);
    }

    @NotNull
    private List<JBTerminalWidget> listTerminals() {
        Splitter rootSplitter = this.findRootSplitter();
        if (rootSplitter == null) {
            List<JBTerminalWidget> list = Collections.singletonList(this.myTerminalWidget);
            if (list == null) {
                TerminalContainer.$$$reportNull$$$0(14);
            }
            return list;
        }
        ArrayList<JBTerminalWidget> terminals = new ArrayList<JBTerminalWidget>();
        this.traverseSplitters(rootSplitter, terminals);
        ArrayList<JBTerminalWidget> arrayList = terminals;
        if (arrayList == null) {
            TerminalContainer.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private void traverseSplitters(@NotNull Splitter splitter, @NotNull List<JBTerminalWidget> terminals) {
        if (splitter == null) {
            TerminalContainer.$$$reportNull$$$0(16);
        }
        if (terminals == null) {
            TerminalContainer.$$$reportNull$$$0(17);
        }
        this.traverseParentPanel(splitter.getFirstComponent(), terminals);
        this.traverseParentPanel(splitter.getSecondComponent(), terminals);
    }

    private void traverseParentPanel(@NotNull JComponent parentPanel, @NotNull List<JBTerminalWidget> terminals) {
        Component[] components;
        if (parentPanel == null) {
            TerminalContainer.$$$reportNull$$$0(18);
        }
        if (terminals == null) {
            TerminalContainer.$$$reportNull$$$0(19);
        }
        if ((components = parentPanel.getComponents()).length == 1) {
            Component c = components[0];
            if (c instanceof Splitter) {
                this.traverseSplitters((Splitter)c, terminals);
            } else if (c instanceof JBTerminalWidget) {
                terminals.add((JBTerminalWidget)c);
            }
        }
    }

    @Nullable
    private Splitter findRootSplitter() {
        Splitter splitter = (Splitter)ObjectUtils.tryCast((Object)this.myPanel.getParent(), Splitter.class);
        while (splitter != null) {
            Splitter parentSplitter;
            Container panel = splitter.getParent();
            Splitter splitter2 = parentSplitter = panel != null ? (Splitter)ObjectUtils.tryCast((Object)panel.getParent(), Splitter.class) : null;
            if (parentSplitter != null) {
                splitter = parentSplitter;
                continue;
            }
            return splitter;
        }
        return null;
    }

    @NotNull
    private static Component unwrapComponent(@NotNull JComponent component) {
        Component c;
        Object[] components;
        if (component == null) {
            TerminalContainer.$$$reportNull$$$0(20);
        }
        if ((components = component.getComponents()).length == 1 && ((c = components[0]) instanceof JBTerminalWidget || c instanceof Splitter)) {
            Component component2 = c;
            if (component2 == null) {
                TerminalContainer.$$$reportNull$$$0(21);
            }
            return component2;
        }
        LOG.error("Cannot unwrap " + component + ", children: " + Arrays.toString(components));
        JComponent jComponent = component;
        if (jComponent == null) {
            TerminalContainer.$$$reportNull$$$0(22);
        }
        return jComponent;
    }

    public void requestFocus(@NotNull JBTerminalWidget terminal) {
        if (terminal == null) {
            TerminalContainer.$$$reportNull$$$0(23);
        }
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)terminal.getTerminalPanel(), true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalWidget";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalView";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/ui/TerminalContainer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTerminalWidget";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widget";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitter";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminals";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentPanel";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/ui/TerminalContainer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminalWidget";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createSplitter";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionCompletedMessage";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "listTerminals";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPanel";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSessionCompletedMessage";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "traverseSplitters";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "traverseParentPanel";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "unwrapComponent";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "requestFocus";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

