/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.reposearch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.CollectionFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenDependencyCompletionItem;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;
import org.jetbrains.idea.reposearch.DependencySearchProvider;
import org.jetbrains.idea.reposearch.DependencySearchProvidersFactory;
import org.jetbrains.idea.reposearch.DependencySearchService;
import org.jetbrains.idea.reposearch.DependencySearchServiceKt;
import org.jetbrains.idea.reposearch.RepositoryArtifactData;
import org.jetbrains.idea.reposearch.SearchParameters;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\b\u0007\u0018\u0000 52\u00020\u0001:\u00015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0007J\b\u0010\u0015\u001a\u00020\u0014H\u0016J:\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n2\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00140\u001bj\u0002`\u001cH\u0002J0\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u00072\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00140\u001bj\u0002`\u001cH\u0002J*\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00180\u001e2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0#J4\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00180\u001e2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"2\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00140\u001bj\u0002`\u001cJ\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070%2\u0006\u0010&\u001a\u00020\u0007J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00070%2\b\u0010(\u001a\u0004\u0018\u00010\u0007J\u001c\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00070%2\u0006\u0010&\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u0007J`\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00180\u001e2\u0006\u0010,\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"2\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00140\u001bj\u0002`\u001c2(\u0010-\u001a$\u0012\u0004\u0012\u00020\u0011\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00140\u001bj\u0002`\u001c\u0012\u0004\u0012\u00020\u00140.H\u0002J$\u0010/\u001a\u00020\u00142\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0011012\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u001101H\u0007J2\u00103\u001a\b\u0012\u0004\u0012\u00020\u00180\u001e2\u0006\u0010&\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0#J<\u00103\u001a\b\u0012\u0004\u0012\u00020\u00180\u001e2\u0006\u0010&\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"2\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00140\u001bj\u0002`\u001cJ\u0006\u00104\u001a\u00020\u0014R[\u0010\u0005\u001aO\u0012\u0016\u0012\u0014 \t*\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b0\u0007\u00a2\u0006\u0002\b\b\u0012.\u0012,\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b \t*\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0018\u00010\n\u00a2\u0006\u0002\b\b0\n\u00a2\u0006\u0002\b\b0\u0006\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jetbrains/idea/reposearch/DependencySearchService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm.PlatformType", "Ljava/util/concurrent/CompletableFuture;", "", "Lorg/jetbrains/idea/reposearch/RepositoryArtifactData;", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "localProviders", "", "Lorg/jetbrains/idea/reposearch/DependencySearchProvider;", "remoteProviders", "clearCache", "", "dispose", "fillResultsFromCache", "Lorg/jetbrains/concurrency/AsyncPromise;", "", "future", "consumer", "Lkotlin/Function1;", "Lorg/jetbrains/idea/reposearch/ResultConsumer;", "foundInCache", "Lorg/jetbrains/concurrency/Promise;", "searchString", "fulltextSearch", "parameters", "Lorg/jetbrains/idea/reposearch/SearchParameters;", "Ljava/util/function/Consumer;", "getArtifactIds", "", "groupId", "getGroupIds", "pattern", "getVersions", "artifactId", "performSearch", "cacheKey", "searchMethod", "Lkotlin/Function2;", "setProviders", "local", "", "remote", "suggestPrefix", "updateProviders", "Companion", "intellij.repository.search"})
@ApiStatus.Experimental
public final class DependencySearchService
implements Disposable {
    private final ScheduledExecutorService executorService;
    private final ConcurrentMap<String, CompletableFuture<Collection<RepositoryArtifactData>>> cache;
    private volatile List<DependencySearchProvider> remoteProviders;
    private volatile List<DependencySearchProvider> localProviders;
    private final Project project;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void dispose() {
    }

    public final synchronized void updateProviders() {
        List newRemoteProviders = new ArrayList();
        List newLocalProviders = new ArrayList();
        if (this.project.isDisposed()) {
            return;
        }
        for (DependencySearchProvidersFactory f : DependencySearchServiceKt.access$getEP_NAME$p().getExtensionList()) {
            Iterator<DependencySearchProvider> iterator = f.getProviders(this.project).iterator();
            while (iterator.hasNext()) {
                DependencySearchProvider provider;
                DependencySearchProvider dependencySearchProvider = provider = iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)dependencySearchProvider, (String)"provider");
                if (dependencySearchProvider.isLocal()) {
                    newLocalProviders.add(provider);
                    continue;
                }
                newRemoteProviders.add(provider);
            }
        }
        this.localProviders = newLocalProviders;
        this.remoteProviders = newRemoteProviders;
        this.cache.clear();
    }

    private final Promise<Integer> performSearch(String cacheKey, SearchParameters parameters, Function1<? super RepositoryArtifactData, Unit> consumer, Function2<? super DependencySearchProvider, ? super Function1<? super RepositoryArtifactData, Unit>, Unit> searchMethod) {
        Promise<Integer> cachedValue;
        if (parameters.useCache() && (cachedValue = this.foundInCache(cacheKey, consumer)) != null) {
            return cachedValue;
        }
        CompletableFuture<Set> thisNewFuture = new CompletableFuture<Set>();
        CompletableFuture<Collection<RepositoryArtifactData>> existingFuture = this.cache.putIfAbsent(cacheKey, thisNewFuture);
        if (existingFuture != null && parameters.useCache()) {
            return (Promise)this.fillResultsFromCache(existingFuture, consumer);
        }
        Set localResultSet = new LinkedHashSet();
        Iterable $this$forEach$iv = this.localProviders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DependencySearchProvider lp = (DependencySearchProvider)element$iv;
            boolean bl = false;
            searchMethod.invoke((Object)lp, (Object)new Function1<RepositoryArtifactData, Unit>(searchMethod, localResultSet){
                final /* synthetic */ Function2 $searchMethod$inlined;
                final /* synthetic */ Set $localResultSet$inlined;
                {
                    this.$searchMethod$inlined = function2;
                    this.$localResultSet$inlined = set;
                    super(1);
                }

                public final void invoke(@NotNull RepositoryArtifactData it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$localResultSet$inlined.add(it);
                }
            });
        }
        $this$forEach$iv = localResultSet;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            consumer.invoke(element$iv);
        }
        if (parameters.isLocalOnly() || this.remoteProviders.size() == 0) {
            thisNewFuture.complete(localResultSet);
            return Promises.resolvedPromise((Object)0);
        }
        List promises = new ArrayList(this.remoteProviders.size());
        Set resultSet = Collections.synchronizedSet(localResultSet);
        for (DependencySearchProvider provider : this.remoteProviders) {
            AsyncPromise promise = new AsyncPromise();
            promises.add(promise);
            ProgressIndicatorProvider progressIndicatorProvider = ProgressIndicatorProvider.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)progressIndicatorProvider, (String)"ProgressIndicatorProvider.getInstance()");
            ProgressWrapper wrapper = ProgressWrapper.wrap((ProgressIndicator)progressIndicatorProvider.getProgressIndicator());
            this.executorService.submit(new Runnable(searchMethod, provider, resultSet, consumer, promise, wrapper){
                final /* synthetic */ Function2 $searchMethod;
                final /* synthetic */ DependencySearchProvider $provider;
                final /* synthetic */ Set $resultSet;
                final /* synthetic */ Function1 $consumer;
                final /* synthetic */ AsyncPromise $promise;
                final /* synthetic */ ProgressWrapper $wrapper;

                public final void run() {
                    try {
                        ProgressManager.getInstance().runProcess(new Runnable(this){
                            final /* synthetic */ performSearch.2 this$0;

                            public final void run() {
                                this.this$0.$searchMethod.invoke((Object)this.this$0.$provider, (Object)new Function1<RepositoryArtifactData, Unit>(this){
                                    final /* synthetic */ performSearch.1 this$0;

                                    public final void invoke(@NotNull RepositoryArtifactData it) {
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        if (this.this$0.this$0.$resultSet.add(it)) {
                                            this.this$0.this$0.$consumer.invoke((Object)it);
                                        }
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        super(1);
                                    }
                                });
                                this.this$0.$promise.setResult(null);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }, (ProgressIndicator)this.$wrapper);
                    }
                    catch (Exception e) {
                        this.$promise.setError((Throwable)e);
                    }
                }
                {
                    this.$searchMethod = function2;
                    this.$provider = dependencySearchProvider;
                    this.$resultSet = set;
                    this.$consumer = function1;
                    this.$promise = asyncPromise;
                    this.$wrapper = progressWrapper;
                }
            });
        }
        Promise promise = Promises.all((Collection)promises, resultSet, (boolean)true).then(new Function(existingFuture, resultSet, thisNewFuture){
            final /* synthetic */ CompletableFuture $existingFuture;
            final /* synthetic */ Set $resultSet;
            final /* synthetic */ CompletableFuture $thisNewFuture;

            public final Integer fun(Set<RepositoryArtifactData> it) {
                if (!this.$resultSet.isEmpty() && this.$existingFuture == null) {
                    this.$thisNewFuture.complete(this.$resultSet);
                }
                return 1;
            }
            {
                this.$existingFuture = completableFuture;
                this.$resultSet = set;
                this.$thisNewFuture = completableFuture2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"promises.all(resultSet, \u2026      return@then 1\n    }");
        return promise;
    }

    @NotNull
    public final Promise<Integer> suggestPrefix(@NotNull String groupId, @NotNull String artifactId, @NotNull SearchParameters parameters, @NotNull Consumer<RepositoryArtifactData> consumer) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        return this.suggestPrefix(groupId, artifactId, parameters, (Function1<? super RepositoryArtifactData, Unit>)((Function1)new Function1<RepositoryArtifactData, Unit>(consumer){
            final /* synthetic */ Consumer $consumer;

            public final void invoke(@NotNull RepositoryArtifactData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$consumer.accept(it);
            }
            {
                this.$consumer = consumer;
                super(1);
            }
        }));
    }

    @NotNull
    public final Promise<Integer> suggestPrefix(@NotNull String groupId, @NotNull String artifactId, @NotNull SearchParameters parameters, @NotNull Function1<? super RepositoryArtifactData, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        String cacheKey = "_" + groupId + ":" + artifactId;
        return this.performSearch(cacheKey, parameters, consumer, (Function2<? super DependencySearchProvider, ? super Function1<? super RepositoryArtifactData, Unit>, Unit>)((Function2)new Function2<DependencySearchProvider, Function1<? super RepositoryArtifactData, ? extends Unit>, Unit>(groupId, artifactId){
            final /* synthetic */ String $groupId;
            final /* synthetic */ String $artifactId;

            public final void invoke(@NotNull DependencySearchProvider p, @NotNull Function1<? super RepositoryArtifactData, Unit> c) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                Intrinsics.checkNotNullParameter(c, (String)"c");
                Function1<? super RepositoryArtifactData, Unit> function1 = c;
                p.suggestPrefix(this.$groupId, this.$artifactId, new Consumer(function1){
                    private final /* synthetic */ Function1 function;
                    {
                        this.function = function1;
                    }

                    public final /* synthetic */ void accept(Object p0) {
                        Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(p0), (String)"invoke(...)");
                    }
                });
            }
            {
                this.$groupId = string;
                this.$artifactId = string2;
                super(2);
            }
        }));
    }

    @NotNull
    public final Promise<Integer> fulltextSearch(@NotNull String searchString, @NotNull SearchParameters parameters, @NotNull Consumer<RepositoryArtifactData> consumer) {
        Intrinsics.checkNotNullParameter((Object)searchString, (String)"searchString");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        return this.fulltextSearch(searchString, parameters, (Function1<? super RepositoryArtifactData, Unit>)((Function1)new Function1<RepositoryArtifactData, Unit>(consumer){
            final /* synthetic */ Consumer $consumer;

            public final void invoke(@NotNull RepositoryArtifactData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$consumer.accept(it);
            }
            {
                this.$consumer = consumer;
                super(1);
            }
        }));
    }

    @NotNull
    public final Promise<Integer> fulltextSearch(@NotNull String searchString, @NotNull SearchParameters parameters, @NotNull Function1<? super RepositoryArtifactData, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)searchString, (String)"searchString");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        return this.performSearch(searchString, parameters, consumer, (Function2<? super DependencySearchProvider, ? super Function1<? super RepositoryArtifactData, Unit>, Unit>)((Function2)new Function2<DependencySearchProvider, Function1<? super RepositoryArtifactData, ? extends Unit>, Unit>(searchString){
            final /* synthetic */ String $searchString;

            public final void invoke(@NotNull DependencySearchProvider p, @NotNull Function1<? super RepositoryArtifactData, Unit> c) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                Intrinsics.checkNotNullParameter(c, (String)"c");
                Function1<? super RepositoryArtifactData, Unit> function1 = c;
                p.fulltextSearch(this.$searchString, new /* invalid duplicate definition of identical inner class */);
            }
            {
                this.$searchString = string;
                super(2);
            }
        }));
    }

    @NotNull
    public final Set<String> getGroupIds(@Nullable String pattern) {
        Set result = new LinkedHashSet();
        String string = pattern;
        if (string == null) {
            string = "";
        }
        this.fulltextSearch(string, new SearchParameters(true, true), (Function1<? super RepositoryArtifactData, Unit>)((Function1)new Function1<RepositoryArtifactData, Unit>(result){
            final /* synthetic */ Set $result;

            public final void invoke(@NotNull RepositoryArtifactData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it instanceof MavenRepositoryArtifactInfo) {
                    this.$result.add(((MavenRepositoryArtifactInfo)it).getGroupId());
                }
            }
            {
                this.$result = set;
                super(1);
            }
        }));
        return result;
    }

    @NotNull
    public final Set<String> getArtifactIds(@NotNull String groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        ProgressIndicatorProvider.checkCanceled();
        Set result = new LinkedHashSet();
        this.fulltextSearch(groupId + ":", new SearchParameters(true, true), (Function1<? super RepositoryArtifactData, Unit>)((Function1)new Function1<RepositoryArtifactData, Unit>(groupId, result){
            final /* synthetic */ String $groupId;
            final /* synthetic */ Set $result;

            public final void invoke(@NotNull RepositoryArtifactData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it instanceof MavenRepositoryArtifactInfo && StringUtil.equals((CharSequence)this.$groupId, (CharSequence)((MavenRepositoryArtifactInfo)it).getGroupId())) {
                    this.$result.add(((MavenRepositoryArtifactInfo)it).getArtifactId());
                }
            }
            {
                this.$groupId = string;
                this.$result = set;
                super(1);
            }
        }));
        return result;
    }

    @NotNull
    public final Set<String> getVersions(@NotNull String groupId, @NotNull String artifactId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        ProgressIndicatorProvider.checkCanceled();
        Set result = new LinkedHashSet();
        this.fulltextSearch(groupId + ":" + artifactId, new SearchParameters(true, true), (Function1<? super RepositoryArtifactData, Unit>)((Function1)new Function1<RepositoryArtifactData, Unit>(groupId, artifactId, result){
            final /* synthetic */ String $groupId;
            final /* synthetic */ String $artifactId;
            final /* synthetic */ Set $result;

            public final void invoke(@NotNull RepositoryArtifactData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it instanceof MavenRepositoryArtifactInfo && StringUtil.equals((CharSequence)this.$groupId, (CharSequence)((MavenRepositoryArtifactInfo)it).getGroupId()) && StringUtil.equals((CharSequence)this.$artifactId, (CharSequence)((MavenRepositoryArtifactInfo)it).getArtifactId())) {
                    for (MavenDependencyCompletionItem item : ((MavenRepositoryArtifactInfo)it).getItems()) {
                        if (item.getVersion() == null) continue;
                        String string = item.getVersion();
                        Intrinsics.checkNotNull((Object)string);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"item.version!!");
                        this.$result.add(string);
                    }
                }
            }
            {
                this.$groupId = string;
                this.$artifactId = string2;
                this.$result = set;
                super(1);
            }
        }));
        return result;
    }

    private final Promise<Integer> foundInCache(String searchString, Function1<? super RepositoryArtifactData, Unit> consumer) {
        CompletableFuture future = (CompletableFuture)this.cache.get(searchString);
        if (future != null) {
            return (Promise)this.fillResultsFromCache(future, consumer);
        }
        return null;
    }

    private final AsyncPromise<Integer> fillResultsFromCache(CompletableFuture<Collection<RepositoryArtifactData>> future, Function1<? super RepositoryArtifactData, Unit> consumer) {
        AsyncPromise p = new AsyncPromise();
        future.whenComplete(new BiConsumer(p, consumer){
            final /* synthetic */ AsyncPromise $p;
            final /* synthetic */ Function1 $consumer;

            /*
             * WARNING - void declaration
             */
            public final void accept(@NotNull Collection<? extends RepositoryArtifactData> r, @Nullable Throwable e) {
                Intrinsics.checkNotNullParameter(r, (String)"r");
                if (e != null) {
                    this.$p.setError(e);
                } else {
                    void $this$forEach$iv;
                    Iterable iterable = r;
                    Function1 action$iv = this.$consumer;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        action$iv.invoke(element$iv);
                    }
                    this.$p.setResult(null);
                }
            }
            {
                this.$p = asyncPromise;
                this.$consumer = function1;
            }
        });
        return p;
    }

    @TestOnly
    public final void setProviders(@NotNull List<? extends DependencySearchProvider> local, @NotNull List<? extends DependencySearchProvider> remote) {
        Intrinsics.checkNotNullParameter(local, (String)"local");
        Intrinsics.checkNotNullParameter(remote, (String)"remote");
        this.remoteProviders.clear();
        this.localProviders.clear();
        this.remoteProviders.addAll((Collection<DependencySearchProvider>)remote);
        this.localProviders.addAll((Collection<DependencySearchProvider>)local);
    }

    @TestOnly
    public final void clearCache() {
        this.cache.clear();
    }

    public DependencySearchService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ScheduledExecutorService scheduledExecutorService = AppExecutorUtil.createBoundedScheduledExecutorService((String)"DependencySearch", (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"AppExecutorUtil.createBo\u2026ce(\"DependencySearch\", 2)");
        this.executorService = scheduledExecutorService;
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakKeyWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"CollectionFactory.create\u2026positoryArtifactData>>>()");
        this.cache = concurrentMap;
        this.remoteProviders = new ArrayList();
        this.localProviders = new ArrayList();
        DependencySearchServiceKt.access$getEP_NAME$p().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<DependencySearchProvidersFactory>(){

            public void extensionAdded(@NotNull DependencySearchProvidersFactory extension, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                this.updateProviders();
            }

            public void extensionRemoved(@NotNull DependencySearchProvidersFactory extension, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                this.updateProviders();
            }
        }, (Disposable)this);
        this.updateProviders();
    }

    @JvmStatic
    @NotNull
    public static final DependencySearchService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/idea/reposearch/DependencySearchService$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/idea/reposearch/DependencySearchService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.repository.search"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final DependencySearchService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(DependencySearchService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            return (DependencySearchService)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

