/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttributeDecl;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.options.LanguageOptions;
import com.maddyhome.idea.copyright.psi.UpdateCopyright;
import com.maddyhome.idea.copyright.psi.UpdateCopyrightsProvider;
import com.maddyhome.idea.copyright.psi.UpdatePsiFileCopyright;

public final class UpdateXmlCopyrightsProvider
extends UpdateCopyrightsProvider {
    @Override
    public UpdateCopyright createInstance(Project project, Module module, VirtualFile file, FileType base, CopyrightProfile options) {
        return new UpdateXmlFileCopyright(project, module, file, options);
    }

    @Override
    public LanguageOptions getDefaultOptions() {
        return UpdateXmlCopyrightsProvider.createDefaultOptions(false);
    }

    public static class UpdateXmlFileCopyright
    extends UpdatePsiFileCopyright {
        private static final Logger logger = Logger.getInstance((String)UpdateXmlFileCopyright.class.getName());

        public UpdateXmlFileCopyright(Project project, Module module, VirtualFile root, CopyrightProfile options) {
            super(project, module, root, options);
        }

        @Override
        protected boolean accept() {
            return this.getFile() instanceof XmlFile;
        }

        @Override
        protected void scanFile() {
            logger.debug("updating " + this.getFile().getVirtualFile());
            XmlDoctype doctype = null;
            PsiElement root = null;
            XmlDocument doc = ((XmlFile)this.getFile()).getDocument();
            for (PsiElement elem = doc.getFirstChild(); elem != null; elem = elem.getNextSibling()) {
                if (elem instanceof XmlProlog) {
                    for (PsiElement prolog = elem.getFirstChild(); prolog != null; prolog = prolog.getNextSibling()) {
                        if (!(prolog instanceof XmlDoctype)) continue;
                        doctype = (XmlDoctype)prolog;
                    }
                    continue;
                }
                if (!(elem instanceof XmlTag) && !(elem instanceof XmlElementDecl) && !(elem instanceof XmlAttributeDecl)) continue;
                root = elem;
                break;
            }
            PsiElement first = doc.getFirstChild();
            if (root == null) {
                root = doc.getLastChild();
            }
            int location = this.getLanguageOptions().getFileLocation();
            if (doctype != null) {
                this.checkComments(first, (PsiElement)doctype, location == 1);
                first = doctype;
            } else if (location == 1) {
                location = 2;
            }
            if (root != null) {
                this.checkComments(first, root, location == 2);
            } else if (location == 2) {
                this.checkComments(first, first, true);
            }
        }

        @Override
        protected PsiElement getPreviousSibling(PsiElement element) {
            if (element == null) {
                return null;
            }
            PsiElement res = element.getPrevSibling();
            if (res != null) {
                if (res instanceof XmlProlog) {
                    XmlProlog prolog = (XmlProlog)res;
                    res = prolog.getChildren().length > 0 ? prolog.getLastChild() : prolog.getPrevSibling();
                }
            } else if (element.getParent() instanceof XmlProlog) {
                res = element.getParent().getPrevSibling();
            }
            return res;
        }

        @Override
        protected PsiElement getNextSibling(PsiElement element) {
            PsiElement res;
            if (element == null) {
                return null;
            }
            PsiElement psiElement = res = element instanceof XmlProlog ? element : element.getNextSibling();
            if (res != null) {
                if (res instanceof XmlProlog) {
                    XmlProlog prolog = (XmlProlog)res;
                    res = prolog.getChildren().length > 0 ? prolog.getFirstChild() : prolog.getNextSibling();
                }
            } else if (element.getParent() instanceof XmlProlog) {
                res = element.getParent().getNextSibling();
            }
            return res;
        }
    }
}

