/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ir.IrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J$\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FragmentSharedVariablesLowering;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "promoteParametersForCapturesToRefs", "", "Lorg/jetbrains/kotlin/ir/symbols/IrValueParameterSymbol;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "replaceUseOfPromotedParametersWithRefs", "promotedParameters", "visitFunctionNew", "Lorg/jetbrains/kotlin/ir/IrStatement;", "Companion", "backend.jvm.lower"})
public final class FragmentSharedVariablesLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    public static final String GENERATED_FUNCTION_NAME = "generated_for_debugger_fun";

    public FragmentSharedVariablesLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)irFile), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
    }

    @NotNull
    public IrStatement visitFunctionNew(@NotNull IrFunction declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!Intrinsics.areEqual((Object)declaration.getName().asString(), (Object)GENERATED_FUNCTION_NAME)) {
            return super.visitFunctionNew(declaration);
        }
        Map<IrValueParameterSymbol, IrValueParameterSymbol> promotedParameters = this.promoteParametersForCapturesToRefs(declaration);
        this.replaceUseOfPromotedParametersWithRefs(declaration, promotedParameters);
        return (IrStatement)declaration;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<IrValueParameterSymbol, IrValueParameterSymbol> promoteParametersForCapturesToRefs(IrFunction declaration) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map promotedParameters = new LinkedHashMap();
        Iterable iterable = declaration.getValueParameters();
        IrFunction irFunction = declaration;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrValueParameter irValueParameter;
            void it;
            IrValueParameter irValueParameter2 = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getOrigin(), (Object)IrDeclarationOrigin.SHARED_VARIABLE_IN_EVALUATOR_FRAGMENT.INSTANCE)) {
                IrType irType = this.context.getSharedVariablesManager().getIrType(it.getType());
                IrDeclarationOrigin.DEFINED dEFINED = IrDeclarationOrigin.DEFINED.INSTANCE;
                IrValueParameter newParameter = IrUtilsKt.copyTo$default((IrValueParameter)it, (IrFunction)declaration, (IrDeclarationOrigin)((IrDeclarationOrigin)dEFINED), (int)0, (int)0, (int)0, null, null, (IrType)irType, null, null, (boolean)false, (boolean)false, (boolean)false, (int)8060, null);
                promotedParameters.put(it.getSymbol(), newParameter.getSymbol());
                irValueParameter = newParameter;
            } else {
                irValueParameter = it;
            }
            collection.add(irValueParameter);
        }
        irFunction.setValueParameters((List)destination$iv$iv);
        return promotedParameters;
    }

    private final void replaceUseOfPromotedParametersWithRefs(IrFunction declaration, Map<IrValueParameterSymbol, ? extends IrValueParameterSymbol> promotedParameters) {
        IrBody irBody = declaration.getBody();
        Intrinsics.checkNotNull((Object)irBody);
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)irBody), (IrElementTransformerVoid)new IrElementTransformerVoid(promotedParameters, this){
            final /* synthetic */ Map<IrValueParameterSymbol, IrValueParameterSymbol> $promotedParameters;
            final /* synthetic */ FragmentSharedVariablesLowering this$0;
            {
                this.$promotedParameters = $promotedParameters;
                this.this$0 = $receiver;
            }

            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)expression2), (IrElementTransformerVoid)this);
                IrValueParameterSymbol irValueParameterSymbol = this.$promotedParameters.get(expression2.getSymbol());
                if (irValueParameterSymbol == null) {
                    return (IrExpression)expression2;
                }
                IrValueParameterSymbol newDeclaration = irValueParameterSymbol;
                return this.this$0.getContext().getSharedVariablesManager().getSharedValue((IrValueSymbol)newDeclaration, expression2);
            }

            @NotNull
            public IrExpression visitSetValue(@NotNull IrSetValue expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)expression2), (IrElementTransformerVoid)this);
                IrValueParameterSymbol irValueParameterSymbol = this.$promotedParameters.get(expression2.getSymbol());
                if (irValueParameterSymbol == null) {
                    return (IrExpression)expression2;
                }
                IrValueParameterSymbol newDeclaration = irValueParameterSymbol;
                return this.this$0.getContext().getSharedVariablesManager().setSharedValue((IrValueSymbol)newDeclaration, expression2);
            }
        });
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FragmentSharedVariablesLowering$Companion;", "", "()V", "GENERATED_FUNCTION_NAME", "", "backend.jvm.lower"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

