/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.coroutines.CoroutineUtilKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.inference.BuilderInferenceData;
import org.jetbrains.kotlin.resolve.calls.inference.BuilderInferenceUtilKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeTemplate;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.descriptorUtil.AnnotationsForResolveUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0003H\u0002\u001a\f\u0010\r\u001a\u00020\u0001*\u00020\u000eH\u0002\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u0006\u0012\u0002\b\u00030\u0011H\u0002\u001a\u000e\u0010\u0012\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0011\u00a8\u0006\u0013"}, d2={"isApplicableCallForBuilderInference", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "isBuilderInferenceCall", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "argument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "isGoodCallForOldBuilderInference", "resultingDescriptor", "containsTypeTemplate", "Lorg/jetbrains/kotlin/types/KotlinType;", "getBuilderInferenceData", "Lorg/jetbrains/kotlin/resolve/calls/inference/BuilderInferenceData;", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl;", "isResultWithBuilderInference", "frontend"})
public final class BuilderInferenceUtilKt {
    private static final boolean containsTypeTemplate(KotlinType $this$containsTypeTemplate) {
        return TypeUtilsKt.contains($this$containsTypeTemplate, (Function1<? super UnwrappedType, Boolean>)((Function1)containsTypeTemplate.1.INSTANCE));
    }

    public static final boolean isApplicableCallForBuilderInference(@NotNull CallableDescriptor descriptor2, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        if (languageVersionSettings.supportsFeature(LanguageFeature.UnrestrictedBuilderInference)) {
            return true;
        }
        if (!languageVersionSettings.supportsFeature(LanguageFeature.ExperimentalBuilderInference)) {
            return BuilderInferenceUtilKt.isGoodCallForOldBuilderInference(descriptor2);
        }
        if (DescriptorUtilsKt.isExtension(descriptor2) && !AnnotationsForResolveUtilsKt.hasBuilderInferenceAnnotation(descriptor2)) {
            Annotated annotated = descriptor2.getExtensionReceiverParameter();
            return annotated != null && (annotated = annotated.getType()) != null ? !BuilderInferenceUtilKt.containsTypeTemplate((KotlinType)annotated) : false;
        }
        KotlinType kotlinType = descriptor2.getReturnType();
        if (kotlinType == null) {
            return false;
        }
        KotlinType returnType = kotlinType;
        return !BuilderInferenceUtilKt.containsTypeTemplate(returnType);
    }

    private static final boolean isGoodCallForOldBuilderInference(CallableDescriptor resultingDescriptor) {
        boolean bl;
        block6: {
            KotlinType kotlinType = resultingDescriptor.getReturnType();
            if (kotlinType == null) {
                return false;
            }
            KotlinType returnType = kotlinType;
            if (BuilderInferenceUtilKt.containsTypeTemplate(returnType)) {
                return false;
            }
            if (!(resultingDescriptor instanceof FunctionDescriptor) || ((FunctionDescriptor)resultingDescriptor).isSuspend()) {
                return true;
            }
            List<ValueParameterDescriptor> list2 = ((FunctionDescriptor)resultingDescriptor).getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"resultingDescriptor.valueParameters");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    KotlinType kotlinType2 = it.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"it.type");
                    if (!BuilderInferenceUtilKt.containsTypeTemplate(kotlinType2)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return !bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isBuilderInferenceCall(@NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ValueArgument argument2, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)parameterDescriptor, (String)"parameterDescriptor");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        boolean parameterHasOptIn = languageVersionSettings.supportsFeature(LanguageFeature.ExperimentalBuilderInference) ? AnnotationsForResolveUtilsKt.hasBuilderInferenceAnnotation(parameterDescriptor) && CoroutineUtilKt.getHasFunctionOrSuspendFunctionType(parameterDescriptor) : CoroutineUtilKt.getHasSuspendFunctionType(parameterDescriptor);
        KtExpression pureExpression = argument2.getArgumentExpression();
        KtExpression baseExpression = pureExpression instanceof KtLabeledExpression ? ((KtLabeledExpression)pureExpression).getBaseExpression() : pureExpression;
        if (!parameterHasOptIn) return false;
        if (!(baseExpression instanceof KtLambdaExpression)) return false;
        KotlinType it = parameterDescriptor.getType();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        if (!FunctionTypesKt.isBuiltinFunctionalType(it)) return false;
        if (FunctionTypesKt.getReceiverTypeFromFunctionType(it) == null) return false;
        return true;
    }

    public static final boolean isResultWithBuilderInference(@NotNull OverloadResolutionResultsImpl<?> $this$isResultWithBuilderInference) {
        Intrinsics.checkNotNullParameter($this$isResultWithBuilderInference, (String)"<this>");
        return BuilderInferenceUtilKt.getBuilderInferenceData($this$isResultWithBuilderInference) != null;
    }

    private static final BuilderInferenceData getBuilderInferenceData(OverloadResolutionResultsImpl<?> $this$getBuilderInferenceData) {
        if (!$this$getBuilderInferenceData.isSingleResult()) {
            return null;
        }
        BuilderInferenceData builderInferenceData = BuilderInferenceUtilKt.getBuilderInferenceData$getData($this$getBuilderInferenceData.getResultingCall().getDispatchReceiver());
        if (builderInferenceData == null) {
            builderInferenceData = BuilderInferenceUtilKt.getBuilderInferenceData$getData($this$getBuilderInferenceData.getResultingCall().getExtensionReceiver());
        }
        return builderInferenceData;
    }

    private static final BuilderInferenceData getBuilderInferenceData$getData(ReceiverValue receiverValue) {
        Ref.ObjectRef builderInferenceData;
        block0: {
            builderInferenceData = new Ref.ObjectRef();
            Object object = receiverValue;
            if (object == null || (object = object.getType()) == null) break block0;
            TypeUtilsKt.contains((KotlinType)object, (Function1<? super UnwrappedType, Boolean>)((Function1)new Function1<UnwrappedType, Boolean>((Ref.ObjectRef<BuilderInferenceData>)builderInferenceData){
                final /* synthetic */ Ref.ObjectRef<BuilderInferenceData> $builderInferenceData;
                {
                    this.$builderInferenceData = $builderInferenceData;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull UnwrappedType it) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Object object = it instanceof TypeTemplate ? (TypeTemplate)it : null;
                        if (object == null || (object = ((TypeTemplate)object).getBuilderInferenceData()) == null) break block0;
                        Object object2 = object;
                        Ref.ObjectRef<BuilderInferenceData> objectRef = this.$builderInferenceData;
                        Object it2 = object2;
                        boolean bl = false;
                        objectRef.element = it2;
                    }
                    return false;
                }
            }));
        }
        return (BuilderInferenceData)builderInferenceData.element;
    }

    public static final /* synthetic */ BuilderInferenceData access$getBuilderInferenceData(OverloadResolutionResultsImpl $receiver) {
        return BuilderInferenceUtilKt.getBuilderInferenceData($receiver);
    }
}

