/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.selector;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigher;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateWeigh;

public class TextMateSelectorCachingWeigher
implements TextMateSelectorWeigher {
    @NotNull
    private final TextMateSelectorWeigher myOriginalWeigher;
    private final Cache<@NotNull CacheKey, @NotNull TextMateWeigh> myCache;

    public TextMateSelectorCachingWeigher(@NotNull TextMateSelectorWeigher originalWeigher) {
        if (originalWeigher == null) {
            TextMateSelectorCachingWeigher.$$$reportNull$$$0(0);
        }
        this.myOriginalWeigher = originalWeigher;
        this.myCache = Caffeine.newBuilder().maximumSize(100000L).expireAfterAccess(1L, TimeUnit.MINUTES).build();
    }

    @Override
    public TextMateWeigh weigh(@NotNull CharSequence scopeSelector, @NotNull TextMateScope scope) {
        if (scopeSelector == null) {
            TextMateSelectorCachingWeigher.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            TextMateSelectorCachingWeigher.$$$reportNull$$$0(2);
        }
        return (TextMateWeigh)this.myCache.get((Object)new CacheKey(scopeSelector, scope), this::weigh);
    }

    private TextMateWeigh weigh(@NotNull CacheKey pair) {
        if (pair == null) {
            TextMateSelectorCachingWeigher.$$$reportNull$$$0(3);
        }
        return this.myOriginalWeigher.weigh(pair.selector, pair.scope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalWeigher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeSelector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorCachingWeigher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "weigh";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class CacheKey {
        final CharSequence selector;
        final TextMateScope scope;

        private CacheKey(CharSequence selector, TextMateScope scope) {
            this.selector = selector;
            this.scope = scope;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey key = (CacheKey)o;
            return this.selector.equals(key.selector) && this.scope.equals(key.scope);
        }

        public int hashCode() {
            return Objects.hash(this.selector, this.scope);
        }
    }
}

