/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkin;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.checkin.CommitEventHandler;
import org.jetbrains.idea.svn.checkin.CommitEventType;

public class IdeaCommitHandler
implements CommitEventHandler,
ProgressTracker {
    private static final Logger LOG = Logger.getInstance(IdeaCommitHandler.class);
    @Nullable
    private final ProgressIndicator myProgress;
    @NotNull
    private final List<VirtualFile> myDeletedFiles = new ArrayList<VirtualFile>();
    private final boolean myCheckCancel;
    private final boolean myTrackDeletedFiles;

    public IdeaCommitHandler(@Nullable ProgressIndicator progress) {
        this(progress, false, false);
    }

    public IdeaCommitHandler(@Nullable ProgressIndicator progress, boolean checkCancel, boolean trackDeletedFiles) {
        this.myProgress = progress;
        this.myCheckCancel = checkCancel;
        this.myTrackDeletedFiles = trackDeletedFiles;
    }

    @NotNull
    public List<VirtualFile> getDeletedFiles() {
        List<VirtualFile> list = this.myDeletedFiles;
        if (list == null) {
            IdeaCommitHandler.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    public void commitEvent(CommitEventType type, File target) {
        if (this.myProgress == null) {
            return;
        }
        this.myProgress.checkCanceled();
        this.updateProgress(type, target.getPath());
    }

    @Override
    public void committedRevision(long revNum) {
        if (this.myProgress == null) {
            return;
        }
        this.myProgress.checkCanceled();
        this.myProgress.setText2(SvnBundle.message("status.text.committed.revision", revNum));
    }

    public void consume(ProgressEvent event) {
        String path = event.getPath();
        if (path != null) {
            CommitEventType eventType = IdeaCommitHandler.convert(event.getAction());
            if (CommitEventType.deleting.equals((Object)eventType) && this.myTrackDeletedFiles) {
                this.trackDeletedFile(event);
            }
            this.updateProgress(eventType, path);
        }
    }

    @Override
    public void checkCancelled() throws ProcessCanceledException {
        if (this.myCheckCancel && this.myProgress != null) {
            this.myProgress.checkCanceled();
        }
    }

    private void updateProgress(@NotNull CommitEventType type, @NotNull String target) {
        if (type == null) {
            IdeaCommitHandler.$$$reportNull$$$0(1);
        }
        if (target == null) {
            IdeaCommitHandler.$$$reportNull$$$0(2);
        }
        if (this.myProgress == null) {
            return;
        }
        if (CommitEventType.adding.equals((Object)type)) {
            this.myProgress.setText2(SvnBundle.message("progress.text2.adding", target));
        } else if (CommitEventType.deleting.equals((Object)type)) {
            this.myProgress.setText2(SvnBundle.message("progress.text2.deleting", target));
        } else if (CommitEventType.sending.equals((Object)type)) {
            this.myProgress.setText2(SvnBundle.message("progress.text2.sending", target));
        } else if (CommitEventType.replacing.equals((Object)type)) {
            this.myProgress.setText2(SvnBundle.message("progress.text2.replacing", target));
        } else if (CommitEventType.transmittingDeltas.equals((Object)type)) {
            this.myProgress.setText2(SvnBundle.message("progress.text2.transmitting.delta", target));
        }
    }

    private void trackDeletedFile(@NotNull ProgressEvent event) {
        String filePath;
        VirtualFile virtualFile;
        if (event == null) {
            IdeaCommitHandler.$$$reportNull$$$0(3);
        }
        if ((virtualFile = (VirtualFile)ReadAction.compute(() -> IdeaCommitHandler.lambda$trackDeletedFile$0(filePath = "file://" + event.getFile().getAbsolutePath().replace(File.separatorChar, '/')))) != null) {
            this.myDeletedFiles.add(virtualFile);
        }
    }

    @NotNull
    private static CommitEventType convert(@NotNull EventAction action) {
        if (action == null) {
            IdeaCommitHandler.$$$reportNull$$$0(4);
        }
        CommitEventType result = CommitEventType.unknown;
        if (EventAction.COMMIT_ADDED.equals((Object)action)) {
            result = CommitEventType.adding;
        } else if (EventAction.COMMIT_DELETED.equals((Object)action)) {
            result = CommitEventType.deleting;
        } else if (EventAction.COMMIT_MODIFIED.equals((Object)action)) {
            result = CommitEventType.sending;
        } else if (EventAction.COMMIT_REPLACED.equals((Object)action)) {
            result = CommitEventType.replacing;
        } else if (EventAction.COMMIT_DELTA_SENT.equals((Object)action)) {
            result = CommitEventType.transmittingDeltas;
        } else if (EventAction.SKIP.equals((Object)action)) {
            result = CommitEventType.skipped;
        } else if (EventAction.FAILED_OUT_OF_DATE.equals((Object)action)) {
            result = CommitEventType.failedOutOfDate;
        }
        if (CommitEventType.unknown.equals((Object)result)) {
            LOG.warn("Could not create commit event from action " + action);
        }
        CommitEventType commitEventType = result;
        if (commitEventType == null) {
            IdeaCommitHandler.$$$reportNull$$$0(5);
        }
        return commitEventType;
    }

    private static /* synthetic */ VirtualFile lambda$trackDeletedFile$0(String filePath) throws RuntimeException {
        return VirtualFileManager.getInstance().findFileByUrl(filePath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/checkin/IdeaCommitHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeletedFiles";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/checkin/IdeaCommitHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateProgress";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "trackDeletedFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

