/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.difftool;

import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.impl.DiffViewerWrapper;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffViewerWrapperProvider;
import com.intellij.util.ThreeState;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.difftool.SvnDiffViewerWrapper;
import org.jetbrains.idea.svn.difftool.properties.SvnPropertiesDiffRequest;
import org.jetbrains.idea.svn.history.PropertyRevision;
import org.jetbrains.idea.svn.properties.PropertyData;

public class SvnChangeDiffViewerProvider
implements ChangeDiffViewerWrapperProvider {
    private static final Logger LOG = Logger.getInstance(SvnChangeDiffViewerProvider.class);

    @NotNull
    public ThreeState isEquals(@NotNull Change change1, @NotNull Change change2) {
        if (change1 == null) {
            SvnChangeDiffViewerProvider.$$$reportNull$$$0(0);
        }
        if (change2 == null) {
            SvnChangeDiffViewerProvider.$$$reportNull$$$0(1);
        }
        Change layer1 = SvnChangeDiffViewerProvider.getSvnChangeLayer(change1);
        Change layer2 = SvnChangeDiffViewerProvider.getSvnChangeLayer(change2);
        if (!(layer1 == null && layer2 == null || layer1 != null && layer2 != null)) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                SvnChangeDiffViewerProvider.$$$reportNull$$$0(2);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            SvnChangeDiffViewerProvider.$$$reportNull$$$0(3);
        }
        return threeState;
    }

    public boolean canCreate(@Nullable Project project, @NotNull Change change) {
        if (change == null) {
            SvnChangeDiffViewerProvider.$$$reportNull$$$0(4);
        }
        return SvnChangeDiffViewerProvider.getSvnChangeLayer(change) != null;
    }

    @NotNull
    public DiffViewerWrapper process(@NotNull ChangeDiffRequestProducer presentable, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
        if (presentable == null) {
            SvnChangeDiffViewerProvider.$$$reportNull$$$0(5);
        }
        if (context == null) {
            SvnChangeDiffViewerProvider.$$$reportNull$$$0(6);
        }
        if (indicator == null) {
            SvnChangeDiffViewerProvider.$$$reportNull$$$0(7);
        }
        SvnPropertiesDiffRequest propertyRequest = SvnChangeDiffViewerProvider.createPropertyRequest(presentable.getChange(), indicator);
        return new SvnDiffViewerWrapper((DiffRequest)propertyRequest);
    }

    @NotNull
    private static SvnPropertiesDiffRequest createPropertyRequest(@NotNull Change change, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException {
        if (change == null) {
            SvnChangeDiffViewerProvider.$$$reportNull$$$0(8);
        }
        if (indicator == null) {
            SvnChangeDiffViewerProvider.$$$reportNull$$$0(9);
        }
        try {
            List<PropertyData> aContent;
            Change propertiesChange = SvnChangeDiffViewerProvider.getSvnChangeLayer(change);
            if (propertiesChange == null) {
                throw new DiffRequestProducerException(SvnBundle.message("diff.cant.get.properties.changes", new Object[0]));
            }
            ContentRevision bRevRaw = propertiesChange.getBeforeRevision();
            ContentRevision aRevRaw = propertiesChange.getAfterRevision();
            if (bRevRaw != null && !(bRevRaw instanceof PropertyRevision)) {
                LOG.warn("Before change is not PropertyRevision");
                throw new DiffRequestProducerException(SvnBundle.message("diff.cant.get.properties.changes", new Object[0]));
            }
            if (aRevRaw != null && !(aRevRaw instanceof PropertyRevision)) {
                LOG.warn("After change is not PropertyRevision");
                throw new DiffRequestProducerException(SvnBundle.message("diff.cant.get.properties.changes", new Object[0]));
            }
            PropertyRevision bRev = (PropertyRevision)bRevRaw;
            PropertyRevision aRev = (PropertyRevision)aRevRaw;
            indicator.checkCanceled();
            List<PropertyData> bContent = bRev != null ? bRev.getProperties() : null;
            indicator.checkCanceled();
            List<PropertyData> list = aContent = aRev != null ? aRev.getProperties() : null;
            if (aRev == null && bRev == null) {
                throw new DiffRequestProducerException(SvnBundle.message("diff.cant.get.properties.changes", new Object[0]));
            }
            ContentRevision bRevMain = change.getBeforeRevision();
            ContentRevision aRevMain = change.getAfterRevision();
            String title1 = bRevMain != null ? StringUtil.nullize((String)bRevMain.getRevisionNumber().asString()) : null;
            String title2 = aRevMain != null ? StringUtil.nullize((String)aRevMain.getRevisionNumber().asString()) : null;
            return new SvnPropertiesDiffRequest(bContent, aContent, title1, title2);
        }
        catch (VcsException e) {
            throw new DiffRequestProducerException((Throwable)e);
        }
    }

    @Nullable
    private static Change getSvnChangeLayer(@NotNull Change change) {
        if (change == null) {
            SvnChangeDiffViewerProvider.$$$reportNull$$$0(10);
        }
        for (Map.Entry entry : change.getOtherLayers().entrySet()) {
            if (!"Property".equals(entry.getKey())) continue;
            if (change.getOtherLayers().size() != 1) {
                LOG.warn("Some of change layers ignored");
            }
            return (Change)entry.getValue();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change2";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/difftool/SvnChangeDiffViewerProvider";
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/difftool/SvnChangeDiffViewerProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "isEquals";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEquals";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canCreate";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createPropertyRequest";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSvnChangeLayer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

