/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.services.impl;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.CollectionFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigOptionDescriptor;
import org.editorconfig.language.util.EditorConfigDescriptorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J!\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u0007H\u0086\u0002R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/editorconfig/language/services/impl/EditorConfigOptionDescriptorStorage;", "", "source", "", "Lorg/editorconfig/language/schema/descriptors/impl/EditorConfigOptionDescriptor;", "(Ljava/lang/Iterable;)V", "allDescriptors", "", "getAllDescriptors", "()Ljava/util/List;", "badDescriptors", "descriptors", "", "", "get", "key", "Lcom/intellij/psi/PsiElement;", "parts", "intellij.editorconfig"})
public final class EditorConfigOptionDescriptorStorage {
    @NotNull
    private final List<EditorConfigOptionDescriptor> allDescriptors;
    private final Map<String, List<EditorConfigOptionDescriptor>> descriptors;
    private final List<EditorConfigOptionDescriptor> badDescriptors;

    @NotNull
    public final List<EditorConfigOptionDescriptor> getAllDescriptors() {
        return this.allDescriptors;
    }

    @Nullable
    public final EditorConfigOptionDescriptor get(@NotNull PsiElement key, @NotNull List<String> parts) {
        Object v0;
        block4: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(parts, (String)"parts");
            for (String part : parts) {
                List<EditorConfigOptionDescriptor> partDescriptors;
                if (this.descriptors.get(part) == null) {
                    continue;
                }
                for (EditorConfigOptionDescriptor descriptor : partDescriptors) {
                    if (!descriptor.getKey().matches(key)) continue;
                    return descriptor;
                }
            }
            Iterable $this$firstOrNull$iv = this.badDescriptors;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                EditorConfigOptionDescriptor it = (EditorConfigOptionDescriptor)element$iv;
                boolean bl = false;
                if (!it.getKey().matches(key)) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        return v0;
    }

    public EditorConfigOptionDescriptorStorage(@NotNull Iterable<EditorConfigOptionDescriptor> source) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        List allDescriptors = new ArrayList();
        Map map = CollectionFactory.createCaseInsensitiveStringMap();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"CollectionFactory.create\u2026onfigOptionDescriptor>>()");
        Map descriptors = map;
        List badDescriptors = new ArrayList();
        for (EditorConfigOptionDescriptor optionDescriptor : source) {
            allDescriptors.add(optionDescriptor);
            List<String> constants = EditorConfigDescriptorUtil.INSTANCE.collectConstants(optionDescriptor.getKey());
            if (constants.isEmpty()) {
                badDescriptors.add(optionDescriptor);
                continue;
            }
            for (String constant : constants) {
                List list = (List)descriptors.get(constant);
                if (list == null) {
                    list = new ArrayList();
                    descriptors.put(constant, list);
                }
                list.add(optionDescriptor);
            }
        }
        this.allDescriptors = allDescriptors;
        this.descriptors = descriptors;
        this.badDescriptors = badDescriptors;
    }
}

