/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.util.core;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import org.editorconfig.language.psi.EditorConfigElementTypes;
import org.editorconfig.language.psi.EditorConfigHeader;
import org.editorconfig.language.psi.EditorConfigPsiFile;
import org.editorconfig.language.psi.EditorConfigSection;
import org.editorconfig.language.util.EditorConfigGlobUtilsKt;
import org.editorconfig.language.util.EditorConfigPsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ2\u0010\u000e\u001a\u0004\u0018\u0001H\u000f\"\b\b\u0000\u0010\u000f*\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u0001H\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0013H\u0086\u0010\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/editorconfig/language/util/core/EditorConfigPsiTreeUtilCore;", "", "()V", "findMatchingChildSections", "", "Lorg/editorconfig/language/psi/EditorConfigSection;", "section", "findMatchingParentSections", "findMatchingSections", "findRemovableRangeBackward", "Lkotlin/ranges/IntRange;", "pattern", "Lcom/intellij/psi/PsiElement;", "findRemovableRangeForward", "getOriginalFile", "T", "Lcom/intellij/psi/PsiFile;", "file", "cls", "Lkotlin/reflect/KClass;", "(Lcom/intellij/psi/PsiFile;Lkotlin/reflect/KClass;)Lcom/intellij/psi/PsiFile;", "intellij.editorconfig"})
public final class EditorConfigPsiTreeUtilCore {
    @NotNull
    public static final EditorConfigPsiTreeUtilCore INSTANCE;

    @NotNull
    public final List<EditorConfigSection> findMatchingSections(@NotNull EditorConfigSection section) {
        Intrinsics.checkNotNullParameter((Object)section, (String)"section");
        return CollectionsKt.plus((Collection)this.findMatchingParentSections(section), (Iterable)this.findMatchingChildSections(section));
    }

    /*
     * WARNING - void declaration
     */
    private final List<EditorConfigSection> findMatchingParentSections(EditorConfigSection section) {
        void $this$filterTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        PsiFile psiFile = section.getContainingFile();
        if (!(psiFile instanceof EditorConfigPsiFile)) {
            psiFile = null;
        }
        EditorConfigPsiFile editorConfigPsiFile = (EditorConfigPsiFile)psiFile;
        if (editorConfigPsiFile == null) {
            return CollectionsKt.emptyList();
        }
        EditorConfigPsiFile psiFile2 = editorConfigPsiFile;
        Iterable $this$flatMap$iv = EditorConfigPsiTreeUtil.INSTANCE.findAllParentsFiles((PsiFile)psiFile2);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            Object receiver = element$iv$iv = iterator.next();
            boolean bl = false;
            Iterable list$iv$iv = ((EditorConfigPsiFile)((Object)receiver)).getSections();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EditorConfigSection it = (EditorConfigSection)element$iv$iv;
            boolean bl = false;
            EditorConfigHeader editorConfigHeader = section.getHeader();
            Intrinsics.checkNotNullExpressionValue((Object)editorConfigHeader, (String)"section.header");
            EditorConfigHeader editorConfigHeader2 = it.getHeader();
            Intrinsics.checkNotNullExpressionValue((Object)editorConfigHeader2, (String)"it.header");
            if (!EditorConfigGlobUtilsKt.isSubcaseOf(editorConfigHeader, editorConfigHeader2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<EditorConfigSection> findMatchingChildSections(EditorConfigSection section) {
        void $this$filterTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        PsiFile psiFile = section.getContainingFile();
        if (!(psiFile instanceof EditorConfigPsiFile)) {
            psiFile = null;
        }
        EditorConfigPsiFile editorConfigPsiFile = (EditorConfigPsiFile)psiFile;
        if (editorConfigPsiFile == null) {
            return CollectionsKt.emptyList();
        }
        EditorConfigPsiFile psiFile2 = editorConfigPsiFile;
        Iterable $this$flatMap$iv = EditorConfigPsiTreeUtil.findAllChildrenFiles$default(EditorConfigPsiTreeUtil.INSTANCE, psiFile2, false, 2, null);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            Object receiver = element$iv$iv = iterator.next();
            boolean bl = false;
            Iterable list$iv$iv = ((EditorConfigPsiFile)((Object)receiver)).getSections();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EditorConfigSection it = (EditorConfigSection)element$iv$iv;
            boolean bl = false;
            EditorConfigHeader editorConfigHeader = it.getHeader();
            Intrinsics.checkNotNullExpressionValue((Object)editorConfigHeader, (String)"it.header");
            EditorConfigHeader editorConfigHeader2 = section.getHeader();
            Intrinsics.checkNotNullExpressionValue((Object)editorConfigHeader2, (String)"section.header");
            if (!EditorConfigGlobUtilsKt.isSubcaseOf(editorConfigHeader, editorConfigHeader2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final IntRange findRemovableRangeBackward(@NotNull PsiElement pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        PsiElement psiElement = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)pattern);
        if (psiElement == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"PsiTreeUtil.skipWhitespa\u2026d(pattern) ?: return null");
        PsiElement prevElement = psiElement;
        ASTNode aSTNode = prevElement.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"prevElement.node");
        if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)EditorConfigElementTypes.COMMA) ^ true) {
            return null;
        }
        PsiElement prevPrevElement = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)prevElement);
        if (prevPrevElement == null) {
            TextRange textRange = prevElement.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"prevElement.textRange");
            int start = textRange.getStartOffset();
            TextRange textRange2 = pattern.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"pattern.textRange");
            int end = textRange2.getEndOffset();
            return RangesKt.until((int)start, (int)end);
        }
        TextRange textRange = prevPrevElement.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"prevPrevElement.textRange");
        int start = textRange.getEndOffset();
        TextRange textRange3 = pattern.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange3, (String)"pattern.textRange");
        int end = textRange3.getEndOffset();
        return RangesKt.until((int)start, (int)end);
    }

    @Nullable
    public final IntRange findRemovableRangeForward(@NotNull PsiElement pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        PsiElement psiElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)pattern);
        if (psiElement == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"PsiTreeUtil.skipWhitespa\u2026d(pattern) ?: return null");
        PsiElement nextElement = psiElement;
        ASTNode aSTNode = nextElement.getNode();
        if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)EditorConfigElementTypes.COMMA) ^ true) {
            return null;
        }
        PsiElement nextNextElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)nextElement);
        if (nextNextElement == null) {
            TextRange textRange = pattern.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"pattern.textRange");
            int start = textRange.getStartOffset();
            TextRange textRange2 = nextElement.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"nextElement.textRange");
            int end = textRange2.getEndOffset();
            return RangesKt.until((int)start, (int)end);
        }
        TextRange textRange = pattern.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"pattern.textRange");
        int start = textRange.getStartOffset();
        TextRange textRange3 = nextNextElement.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange3, (String)"nextNextElement.textRange");
        int end = textRange3.getStartOffset();
        return RangesKt.until((int)start, (int)end);
    }

    @Nullable
    public final <T extends PsiFile> T getOriginalFile(@Nullable T file, @NotNull KClass<T> cls) {
        while (true) {
            Intrinsics.checkNotNullParameter(cls, (String)"cls");
            T t = file;
            PsiFile originalFile = (PsiFile)KClasses.safeCast(cls, (Object)(t != null ? t.getOriginalFile() : null));
            if (Intrinsics.areEqual(file, (Object)originalFile)) {
                return file;
            }
            file = originalFile;
        }
    }

    private EditorConfigPsiTreeUtilCore() {
    }

    static {
        EditorConfigPsiTreeUtilCore editorConfigPsiTreeUtilCore;
        INSTANCE = editorConfigPsiTreeUtilCore = new EditorConfigPsiTreeUtilCore();
    }
}

