/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.JavaCoverageOptionsProvider;
import com.intellij.openapi.project.Project;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.SaveHook;
import com.intellij.rt.coverage.util.ClassNameUtil;
import java.util.List;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;

public final class SourceLineCounterUtil {
    public static void collectSrcLinesForUntouchedFiles(List<? super Integer> uncoveredLines, byte[] content, boolean isSampling, Project project) {
        LineData[] lines;
        ClassReader reader = new ClassReader(content);
        String qualifiedName2 = ClassNameUtil.convertToFQName((String)reader.getClassName());
        ProjectData projectData = new ProjectData();
        boolean ignoreEmptyPrivateConstructors = JavaCoverageOptionsProvider.getInstance(project).ignoreEmptyPrivateConstructors();
        SaveHook.appendUnloadedClass((ProjectData)projectData, (String)qualifiedName2, (ClassReader)reader, (boolean)isSampling, (boolean)false, (boolean)ignoreEmptyPrivateConstructors);
        ClassData classData = projectData.getClassData(qualifiedName2);
        if (classData == null || classData.getLines() == null) {
            return;
        }
        for (LineData line : lines = (LineData[])classData.getLines()) {
            if (line == null) continue;
            String description = line.getMethodSignature();
            if (JavaCoverageOptionsProvider.getInstance(project).isGeneratedConstructor(qualifiedName2, description)) continue;
            uncoveredLines.add((Integer)(line.getLineNumber() - 1));
        }
    }
}

