/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.load.java.typeEnhancement.TypeEnhancementKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.jvm.JvmBindingContextSlices;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionInfo;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionsKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeCheckerKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J \u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\nH\u0002J\f\u0010\u001d\u001a\u00020\u001e*\u00020\u001fH\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/RuntimeAssertionsOnDeclarationBodyChecker;", "", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "bindingTrace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkFunction", "Lorg/jetbrains/kotlin/psi/KtFunction;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkLocalVariable", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "checkNullabilityAssertion", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "declarationType", "Lorg/jetbrains/kotlin/types/KotlinType;", "checkProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "checkPropertyAccessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "Lorg/jetbrains/kotlin/descriptors/PropertyAccessorDescriptor;", "canContainNull", "", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "frontend.java"})
public final class RuntimeAssertionsOnDeclarationBodyChecker {
    @NotNull
    public static final RuntimeAssertionsOnDeclarationBodyChecker INSTANCE = new RuntimeAssertionsOnDeclarationBodyChecker();

    private RuntimeAssertionsOnDeclarationBodyChecker() {
    }

    @JvmStatic
    public static final void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull BindingTrace bindingTrace, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)bindingTrace, (String)"bindingTrace");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        if (!languageVersionSettings.supportsFeature(LanguageFeature.StrictJavaNullabilityAssertions)) {
            return;
        }
        if (declaration instanceof KtProperty && descriptor2 instanceof VariableDescriptor) {
            INSTANCE.checkLocalVariable((KtProperty)declaration, (VariableDescriptor)descriptor2, bindingTrace);
        } else if (declaration instanceof KtFunction && descriptor2 instanceof FunctionDescriptor) {
            INSTANCE.checkFunction((KtFunction)declaration, (FunctionDescriptor)descriptor2, bindingTrace);
        } else if (declaration instanceof KtProperty && descriptor2 instanceof PropertyDescriptor) {
            INSTANCE.checkProperty((KtProperty)declaration, (PropertyDescriptor)descriptor2, bindingTrace);
        } else if (declaration instanceof KtPropertyAccessor && descriptor2 instanceof PropertyAccessorDescriptor) {
            INSTANCE.checkPropertyAccessor((KtPropertyAccessor)declaration, (PropertyAccessorDescriptor)descriptor2, bindingTrace);
        }
    }

    private final void checkLocalVariable(KtProperty declaration, VariableDescriptor descriptor2, BindingTrace bindingTrace) {
        if (declaration.getTypeReference() != null) {
            return;
        }
        KtExpression ktExpression = declaration.getInitializer();
        if (ktExpression == null) {
            return;
        }
        KotlinType kotlinType = descriptor2.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"descriptor.type");
        this.checkNullabilityAssertion(ktExpression, kotlinType, bindingTrace);
    }

    private final void checkFunction(KtFunction declaration, FunctionDescriptor descriptor2, BindingTrace bindingTrace) {
        if (declaration.getTypeReference() != null || declaration.hasBlockBody()) {
            return;
        }
        KtExpression ktExpression = declaration.getBodyExpression();
        if (ktExpression == null) {
            return;
        }
        KotlinType kotlinType = descriptor2.getReturnType();
        if (kotlinType == null) {
            return;
        }
        this.checkNullabilityAssertion(ktExpression, kotlinType, bindingTrace);
    }

    private final void checkProperty(KtProperty declaration, PropertyDescriptor descriptor2, BindingTrace bindingTrace) {
        if (declaration.getTypeReference() != null) {
            return;
        }
        if (declaration.hasDelegateExpression()) {
            return;
        }
        KtExpression ktExpression = declaration.getInitializer();
        if (ktExpression == null) {
            return;
        }
        KotlinType kotlinType = descriptor2.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"descriptor.type");
        this.checkNullabilityAssertion(ktExpression, kotlinType, bindingTrace);
    }

    private final void checkPropertyAccessor(KtPropertyAccessor declaration, PropertyAccessorDescriptor descriptor2, BindingTrace bindingTrace) {
        if (declaration.getProperty().getTypeReference() != null || declaration.hasBlockBody()) {
            return;
        }
        KtExpression ktExpression = declaration.getBodyExpression();
        if (ktExpression == null) {
            return;
        }
        KotlinType kotlinType = descriptor2.getCorrespondingProperty().getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"descriptor.correspondingProperty.type");
        this.checkNullabilityAssertion(ktExpression, kotlinType, bindingTrace);
    }

    private final void checkNullabilityAssertion(KtExpression expression, KotlinType declarationType, BindingTrace bindingTrace) {
        if (this.canContainNull(declarationType.unwrap())) {
            return;
        }
        KotlinType kotlinType = bindingTrace.getType(expression);
        if (kotlinType == null) {
            return;
        }
        KotlinType expressionType = kotlinType;
        if (KotlinTypeKt.isError((KotlinType)expressionType)) {
            return;
        }
        if (!TypeEnhancementKt.hasEnhancedNullability((KotlinType)expressionType)) {
            return;
        }
        bindingTrace.record(JvmBindingContextSlices.BODY_RUNTIME_ASSERTION_INFO, (Object)expression, (Object)new RuntimeAssertionInfo(true, RuntimeAssertionsKt.access$getTextForRuntimeAssertionInfo(expression)));
    }

    private final boolean canContainNull(UnwrappedType $this$canContainNull) {
        boolean bl;
        block7: {
            SimpleType upper = FlexibleTypesKt.upperIfFlexible((KotlinType)((KotlinType)$this$canContainNull));
            if (upper.isMarkedNullable()) {
                bl = true;
            } else if (NewKotlinTypeCheckerKt.isClassType((SimpleType)upper)) {
                bl = false;
            } else {
                Iterable $this$all$iv = TypeUtilsKt.immediateSupertypes((KotlinType)((KotlinType)upper));
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        KotlinType it = (KotlinType)element$iv;
                        boolean bl2 = false;
                        if (INSTANCE.canContainNull(it.unwrap())) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
            }
        }
        return bl;
    }
}

