/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.provider;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.augment.PsiExtensionMethod;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import de.plushnikov.intellij.plugin.processor.LombokProcessorManager;
import de.plushnikov.intellij.plugin.processor.Processor;
import de.plushnikov.intellij.plugin.processor.ValProcessor;
import de.plushnikov.intellij.plugin.processor.method.ExtensionMethodsHelper;
import de.plushnikov.intellij.plugin.processor.modifier.ModifierProcessor;
import de.plushnikov.intellij.plugin.util.LombokLibraryUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LombokAugmentProvider
extends PsiAugmentProvider {
    private static final Logger log = Logger.getInstance((String)LombokAugmentProvider.class.getName());
    private final ValProcessor valProcessor;
    private final Collection<ModifierProcessor> modifierProcessors;

    public LombokAugmentProvider() {
        log.debug("LombokAugmentProvider created");
        this.modifierProcessors = LombokProcessorManager.getLombokModifierProcessors();
        this.valProcessor = new ValProcessor();
    }

    @NotNull
    protected Set<String> transformModifiers(@NotNull PsiModifierList modifierList, @NotNull Set<String> modifiers) {
        if (modifierList == null) {
            LombokAugmentProvider.$$$reportNull$$$0(0);
        }
        if (modifiers == null) {
            LombokAugmentProvider.$$$reportNull$$$0(1);
        }
        if (!LombokLibraryUtil.hasLombokLibrary(modifierList.getProject())) {
            Set<String> set = modifiers;
            if (set == null) {
                LombokAugmentProvider.$$$reportNull$$$0(2);
            }
            return set;
        }
        HashSet<String> result = new HashSet<String>(modifiers);
        for (ModifierProcessor processor : this.modifierProcessors) {
            if (!processor.isSupported(modifierList)) continue;
            processor.transformModifiers(modifierList, result);
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            LombokAugmentProvider.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    public boolean canInferType(@NotNull PsiTypeElement typeElement) {
        if (typeElement == null) {
            LombokAugmentProvider.$$$reportNull$$$0(4);
        }
        return LombokLibraryUtil.hasLombokLibrary(typeElement.getProject()) && this.valProcessor.canInferType(typeElement);
    }

    protected boolean fieldInitializerMightBeChanged(@NotNull PsiField field) {
        if (field == null) {
            LombokAugmentProvider.$$$reportNull$$$0(5);
        }
        return PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)field, "lombok.Builder.Default");
    }

    @Nullable
    protected PsiType inferType(@NotNull PsiTypeElement typeElement) {
        if (typeElement == null) {
            LombokAugmentProvider.$$$reportNull$$$0(6);
        }
        return LombokLibraryUtil.hasLombokLibrary(typeElement.getProject()) ? this.valProcessor.inferType(typeElement) : null;
    }

    @NotNull
    public <Psi extends PsiElement> List<Psi> getAugments(@NotNull PsiElement element, @NotNull Class<Psi> type) {
        if (element == null) {
            LombokAugmentProvider.$$$reportNull$$$0(7);
        }
        if (type == null) {
            LombokAugmentProvider.$$$reportNull$$$0(8);
        }
        List<Psi> list = this.getAugments(element, type, null);
        if (list == null) {
            LombokAugmentProvider.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public <Psi extends PsiElement> List<Psi> getAugments(@NotNull PsiElement element, @NotNull Class<Psi> type, @Nullable String nameHint) {
        List<Psi> result;
        if (element == null) {
            LombokAugmentProvider.$$$reportNull$$$0(10);
        }
        if (type == null) {
            LombokAugmentProvider.$$$reportNull$$$0(11);
        }
        List emptyResult = Collections.emptyList();
        if (type != PsiClass.class && type != PsiField.class && type != PsiMethod.class || !(element instanceof PsiExtensibleClass)) {
            List list = emptyResult;
            if (list == null) {
                LombokAugmentProvider.$$$reportNull$$$0(12);
            }
            return list;
        }
        PsiClass psiClass = (PsiClass)element;
        if (!psiClass.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            List list = emptyResult;
            if (list == null) {
                LombokAugmentProvider.$$$reportNull$$$0(13);
            }
            return list;
        }
        if (psiClass.isAnnotationType() || psiClass.isInterface()) {
            List list = emptyResult;
            if (list == null) {
                LombokAugmentProvider.$$$reportNull$$$0(14);
            }
            return list;
        }
        if (!LombokLibraryUtil.hasLombokLibrary(element.getProject())) {
            List list = emptyResult;
            if (list == null) {
                LombokAugmentProvider.$$$reportNull$$$0(15);
            }
            return list;
        }
        List<Psi> list = result = LombokAugmentProvider.getPsis(psiClass, type, nameHint);
        if (list == null) {
            LombokAugmentProvider.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    private static <Psi extends PsiElement> List<Psi> getPsis(PsiClass psiClass, Class<Psi> type, String nameHint) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (Processor processor : LombokProcessorManager.getProcessors(type)) {
            List<? super PsiElement> generatedElements = processor.process(psiClass, nameHint);
            for (PsiElement psiElement : generatedElements) {
                result.add(psiElement);
            }
        }
        ArrayList<PsiElement> arrayList = result;
        if (arrayList == null) {
            LombokAugmentProvider.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    protected List<PsiExtensionMethod> getExtensionMethods(@NotNull PsiClass aClass, @NotNull String nameHint, @NotNull PsiElement context) {
        if (aClass == null) {
            LombokAugmentProvider.$$$reportNull$$$0(18);
        }
        if (nameHint == null) {
            LombokAugmentProvider.$$$reportNull$$$0(19);
        }
        if (context == null) {
            LombokAugmentProvider.$$$reportNull$$$0(20);
        }
        if (!LombokLibraryUtil.hasLombokLibrary(context.getProject())) {
            return Collections.emptyList();
        }
        return ExtensionMethodsHelper.getExtensionMethods(aClass, nameHint, context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/provider/LombokAugmentProvider";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameHint";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/provider/LombokAugmentProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "transformModifiers";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAugments";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsis";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "transformModifiers";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canInferType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fieldInitializerMightBeChanged";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "inferType";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAugments";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionMethods";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

