/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.comment;

import com.intellij.lang.Language;
import com.intellij.markdown.utils.lang.HtmlSyntaxHighlighter;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColorUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.github.pullrequest.comment.GHSuggestedChange;
import org.jetbrains.plugins.github.pullrequest.comment.GHSuggestionHtmlSyntaxHighlighter;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J*\u0010\f\u001a\u00020\b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/GHSuggestionHtmlSyntaxHighlighter;", "Lcom/intellij/markdown/utils/lang/HtmlSyntaxHighlighter;", "project", "Lcom/intellij/openapi/project/Project;", "suggestedChangeInfo", "Lorg/jetbrains/plugins/github/pullrequest/comment/GHSuggestedChange;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/pullrequest/comment/GHSuggestedChange;)V", "color", "Lcom/intellij/openapi/util/text/HtmlChunk;", "language", "", "rawContent", "createColoredChunk", "Lcom/intellij/lang/Language;", "textAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "Companion", "intellij.vcs.github"})
public final class GHSuggestionHtmlSyntaxHighlighter
implements HtmlSyntaxHighlighter {
    private final Project project;
    private final GHSuggestedChange suggestedChangeInfo;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public HtmlChunk color(@Nullable String language, @NotNull String rawContent) {
        LanguageFileType fileType;
        LanguageFileType languageFileType;
        Intrinsics.checkNotNullParameter((Object)rawContent, (String)"rawContent");
        String string = PathUtil.getFileName((String)this.suggestedChangeInfo.getFilePath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PathUtil.getFileName(suggestedChangeInfo.filePath)");
        String name = string;
        FileType fileType2 = FileTypeRegistry.getInstance().getFileTypeByFileName(name);
        if (!(fileType2 instanceof LanguageFileType)) {
            fileType2 = null;
        }
        if ((languageFileType = (LanguageFileType)fileType2) == null) {
            languageFileType = (LanguageFileType)PlainTextFileType.INSTANCE;
        }
        LanguageFileType languageFileType2 = fileType = languageFileType;
        Intrinsics.checkNotNullExpressionValue((Object)languageFileType2, (String)"fileType");
        Language language2 = languageFileType2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"fileType.language");
        Language fileLanguage = language2;
        String changedContent2 = CollectionsKt.joinToString$default((Iterable)this.suggestedChangeInfo.cutChangedContent(), (CharSequence)"\n", null, null, (int)0, null, (Function1)color.changedContent.1.INSTANCE, (int)30, null);
        HtmlBuilder htmlBuilder = new HtmlBuilder();
        String string2 = Companion.trimStartWithMinIndent(changedContent2);
        TextAttributesKey textAttributesKey = DiffColors.DIFF_DELETED;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"DiffColors.DIFF_DELETED");
        HtmlBuilder htmlBuilder2 = htmlBuilder.append(this.createColoredChunk(this.project, fileLanguage, string2, textAttributesKey));
        String string3 = Companion.trimStartWithMinIndent(rawContent);
        TextAttributesKey textAttributesKey2 = DiffColors.DIFF_INSERTED;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey2, (String)"DiffColors.DIFF_INSERTED");
        HtmlChunk htmlChunk = htmlBuilder2.append(this.createColoredChunk(this.project, fileLanguage, string3, textAttributesKey2)).toFragment();
        Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"HtmlBuilder()\n      .app\u2026TED))\n      .toFragment()");
        return htmlChunk;
    }

    private final HtmlChunk createColoredChunk(Project project, Language language, String rawContent, TextAttributesKey textAttributesKey) {
        EditorColorsScheme editorColorsScheme = EditorColorsUtil.getGlobalOrDefaultColorScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"EditorColorsUtil.getGlobalOrDefaultColorScheme()");
        EditorColorsScheme colorsScheme = editorColorsScheme;
        TextAttributes textAttributes = colorsScheme.getAttributes(textAttributesKey);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"colorsScheme.getAttributes(textAttributesKey)");
        Color backgroundColor = textAttributes.getBackgroundColor();
        String styles = StringsKt.trimIndent((String)("\n      background-color: " + ColorUtil.toHtmlColor((Color)backgroundColor) + "; \n      margin: 0;\n      padding: " + GHSuggestionHtmlSyntaxHighlighter.Companion.getPADDING() + " " + GHSuggestionHtmlSyntaxHighlighter.Companion.getPADDING() + ";\n    "));
        HtmlChunk.Element element = HtmlChunk.tag((String)"pre").style(styles).child(HtmlSyntaxHighlighter.Companion.colorHtmlChunk(project, language, rawContent));
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"HtmlChunk\n      .tag(\"pr\u2026t, language, rawContent))");
        return (HtmlChunk)element;
    }

    public GHSuggestionHtmlSyntaxHighlighter(@Nullable Project project, @NotNull GHSuggestedChange suggestedChangeInfo) {
        Intrinsics.checkNotNullParameter((Object)suggestedChangeInfo, (String)"suggestedChangeInfo");
        this.project = project;
        this.suggestedChangeInfo = suggestedChangeInfo;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/GHSuggestionHtmlSyntaxHighlighter$Companion;", "", "()V", "PADDING", "", "getPADDING", "()I", "trimStartWithMinIndent", "", "text", "intellij.vcs.github"})
    public static final class Companion {
        private final int getPADDING() {
            return JBUI.scale((int)2);
        }

        @VisibleForTesting
        @NotNull
        public final String trimStartWithMinIndent(@NotNull String text) {
            List list2;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            List it = list2 = StringsKt.lines((CharSequence)text);
            boolean bl = false;
            List list3 = Intrinsics.areEqual((Object)((String)CollectionsKt.last((List)it)), (Object)"") ? CollectionsKt.dropLast((List)it, (int)1) : it;
            List lines = list3;
            if (lines.isEmpty()) {
                return text;
            }
            int minIndent = Integer.MAX_VALUE;
            for (String line : lines) {
                char symbol;
                int currentIndent = 0;
                String string = line;
                int n = string.length();
                for (int i = 0; i < n && (symbol = string.charAt(i)) == ' '; ++i) {
                    ++currentIndent;
                }
                minIndent = Integer.min(minIndent, currentIndent);
            }
            String startIndent = StringsKt.repeat((CharSequence)" ", (int)minIndent);
            return CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(startIndent){
                final /* synthetic */ String $startIndent;

                @NotNull
                public final CharSequence invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return StringsKt.removePrefix((String)it, (CharSequence)this.$startIndent);
                }
                {
                    this.$startIndent = string;
                    super(1);
                }
            }), (int)30, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

