/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util.classFinder;

import com.intellij.rt.coverage.util.ClassNameUtil;
import java.util.List;
import java.util.regex.Pattern;

public interface ClassFilter {
    public boolean shouldInclude(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PatternFilter
    implements ClassFilter {
        private final List<Pattern> myIncludePatterns;
        private final List<Pattern> myExcludePatterns;

        public PatternFilter(List<Pattern> includePatterns, List<Pattern> excludePatterns) {
            this.myIncludePatterns = includePatterns;
            this.myExcludePatterns = excludePatterns;
        }

        @Override
        public boolean shouldInclude(String className) {
            if (ClassNameUtil.matchesPatterns(className, this.myExcludePatterns)) {
                return false;
            }
            String outerClassName = ClassNameUtil.getOuterClassName(className);
            if (ClassNameUtil.matchesPatterns(outerClassName, this.myIncludePatterns)) {
                return true;
            }
            return this.myIncludePatterns.isEmpty();
        }
    }
}

