/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.execution.CommandLineUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.Pair;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ReadEnv;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class EnvReader
extends EnvironmentUtil.ShellEnvReader {
    public EnvReader() {
    }

    public EnvReader(long timeoutMillis) {
        super(timeoutMillis);
    }

    @NotNull
    public Map<String, String> readBatEnv(@Nullable Path batchFile, List<String> args2) throws IOException {
        Map map = (Map)this.readBatOutputAndEnv((Path)batchFile, args2).second;
        if (map == null) {
            EnvReader.$$$reportNull$$$0(0);
        }
        return map;
    }

    @NotNull
    public final Pair<String, Map<String, String>> readBatOutputAndEnv(@Nullable Path batchFile, @Nullable List<@NotNull String> args2) throws IOException {
        return this.readBatOutputAndEnv(batchFile, args2, "cmd.exe");
    }

    @NotNull
    public final Pair<String, Map<String, String>> readBatOutputAndEnv(@Nullable Path batchFile, @Nullable List<@NotNull String> args2, @NotNull String cmdExePath) throws IOException {
        if (cmdExePath == null) {
            EnvReader.$$$reportNull$$$0(1);
        }
        Pair<String, Map<String, String>> pair = this.readBatOutputAndEnv(batchFile, args2, cmdExePath, it -> {});
        if (pair == null) {
            EnvReader.$$$reportNull$$$0(2);
        }
        return pair;
    }

    @NotNull
    public Pair<String, Map<String, String>> readBatOutputAndEnv(@Nullable Path batchFile, @Nullable List<@NotNull String> args2, @NotNull String cmdExePath, @NotNull @NotNull Consumer<@NotNull Map<String, String>> scriptEnvironmentProcessor) throws IOException {
        if (cmdExePath == null) {
            EnvReader.$$$reportNull$$$0(3);
        }
        if (scriptEnvironmentProcessor == null) {
            EnvReader.$$$reportNull$$$0(4);
        }
        if (batchFile != null && !Files.exists(batchFile, new LinkOption[0])) {
            throw new NoSuchFileException(batchFile.toString());
        }
        Path envDataFile = Files.createTempFile("intellij-cmd-env-data.", ".tmp", new FileAttribute[0]);
        ArrayList<String> callArgs = new ArrayList<String>();
        if (batchFile != null) {
            callArgs.add("call");
            callArgs.add(batchFile.toString());
            if (args2 != null) {
                callArgs.addAll(args2);
            }
            callArgs.add("1>&2");
            callArgs.add("&&");
        }
        callArgs.add((System.getProperty("java.home") + "/bin/java").replace('/', File.separatorChar));
        callArgs.add("-cp");
        callArgs.add(PathManager.getJarPathForClass(ReadEnv.class));
        callArgs.add(ReadEnv.class.getCanonicalName());
        callArgs.add(">");
        callArgs.add(envDataFile.toString());
        callArgs.add("||");
        callArgs.add("exit");
        callArgs.add("/B");
        callArgs.add("%ERRORLEVEL%");
        ArrayList<@NonNls String> cl = new ArrayList<String>();
        cl.add(cmdExePath);
        cl.add("/c");
        cl.add(EnvReader.prepareCallArgs(callArgs));
        Map.Entry<String, Map<String, String>> entry = this.runProcessAndReadOutputAndEnvs(cl, batchFile != null ? batchFile.getParent() : null, scriptEnvironmentProcessor, envDataFile);
        return new Pair((Object)entry.getKey(), entry.getValue());
    }

    @NotNull
    private static String prepareCallArgs(@NotNull List<String> callArgs) {
        if (callArgs == null) {
            EnvReader.$$$reportNull$$$0(5);
        }
        List<String> preparedCallArgs = CommandLineUtil.toCommandLine(callArgs);
        String firstArg = preparedCallArgs.remove(0);
        preparedCallArgs.add(0, CommandLineUtil.escapeParameterOnWindows(firstArg, false));
        String string2 = "\"" + String.join((CharSequence)" ", preparedCallArgs) + "\"";
        if (string2 == null) {
            EnvReader.$$$reportNull$$$0(6);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/EnvReader";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdExePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptEnvironmentProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "readBatEnv";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/EnvReader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "readBatOutputAndEnv";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareCallArgs";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readBatOutputAndEnv";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "prepareCallArgs";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

