/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.FilteringIterator;
import java.util.Collection;

@FunctionalInterface
public interface InternalIterator<T> {
    public boolean visit(T var1);

    public static class Filtering<T>
    implements InternalIterator<T> {
        private final Condition<? super T> myFilter;
        private final InternalIterator<? super T> myIterator;

        public Filtering(InternalIterator<? super T> iterator, Condition<? super T> filter) {
            this.myIterator = iterator;
            this.myFilter = filter;
        }

        @Override
        public boolean visit(T value) {
            return !this.myFilter.value(value) || this.myIterator.visit(value);
        }

        public static <T> InternalIterator<T> create(InternalIterator<? super T> iterator, Condition<? super T> filter) {
            return new Filtering<T>(iterator, filter);
        }

        public static <T, V extends T> InternalIterator<T> createInstanceOf(InternalIterator<V> iterator, FilteringIterator.InstanceOf<V> filter) {
            return new Filtering<Object>(iterator, filter);
        }

        public static <T> InternalIterator createInstanceOf(InternalIterator<T> iterator, Class<T> aClass) {
            return Filtering.createInstanceOf(iterator, FilteringIterator.instanceOf(aClass));
        }
    }

    public static class Collector<T>
    implements InternalIterator<T> {
        private final Collection<? super T> myCollection;

        public Collector(Collection<? super T> collection) {
            this.myCollection = collection;
        }

        @Override
        public boolean visit(T value) {
            return this.myCollection.add(value);
        }

        public static <T> InternalIterator<T> create(Collection<? super T> collection) {
            return new Collector<T>(collection);
        }
    }
}

