/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.UnInterruptibleFileChannelHandle;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public final class UnInterruptibleFileChannel
extends FileChannel {
    private final UnInterruptibleFileChannelHandle myFileChannelHandle;

    public UnInterruptibleFileChannel(@NotNull Path path, OpenOption ... openOptions) throws IOException {
        if (path == null) {
            UnInterruptibleFileChannel.$$$reportNull$$$0(0);
        }
        if (openOptions == null) {
            UnInterruptibleFileChannel.$$$reportNull$$$0(1);
        }
        this.myFileChannelHandle = new UnInterruptibleFileChannelHandle(path, openOptions);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.myFileChannelHandle.executeOperation(ch -> ch.read(dst));
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.myFileChannelHandle.executeOperation(ch -> ch.read(dsts, offset, length));
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.myFileChannelHandle.executeOperation(ch -> ch.write(src));
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.myFileChannelHandle.executeOperation(ch -> ch.write(srcs, offset, length));
    }

    @Override
    public long position() throws IOException {
        return this.myFileChannelHandle.executeOperation(ch -> ch.position());
    }

    @Override
    public FileChannel position(long newPosition) throws IOException {
        return this.myFileChannelHandle.executeOperation(ch -> ch.position(newPosition));
    }

    @Override
    public long size() throws IOException {
        return this.myFileChannelHandle.executeOperation(ch -> ch.size());
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        return this.myFileChannelHandle.executeOperation(ch -> ch.truncate(size));
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.myFileChannelHandle.executeOperation(ch -> {
            ch.force(metaData);
            return null;
        });
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        return this.myFileChannelHandle.executeOperation(ch -> ch.read(dst, position));
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        return this.myFileChannelHandle.executeOperation(ch -> ch.write(src, position));
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void implCloseChannel() throws IOException {
        this.myFileChannelHandle.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "path";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "openOptions";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/io/UnInterruptibleFileChannel";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

