/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.Hash;
import java.util.function.IntFunction;
import java.util.function.LongFunction;
import org.jetbrains.annotations.NotNull;

final class StrippedLongToObjectMap<V>
implements LongFunction<V> {
    private long[] keys;
    private V[] values;
    private int mask;
    private boolean containsNullKey;
    private int tableSize;
    private int maxFill;
    private int size;
    private final IntFunction<V[]> valueArrayFactory;

    StrippedLongToObjectMap(IntFunction<V[]> valueArrayFactory, int expectedCapacity) {
        this.valueArrayFactory = valueArrayFactory;
        this.tableSize = Hash.arraySize(expectedCapacity, 0.75f);
        this.mask = this.tableSize - 1;
        this.maxFill = Hash.maxFill(this.tableSize, 0.75f);
        this.keys = new long[this.tableSize + 1];
        this.values = valueArrayFactory.apply(this.tableSize + 1);
    }

    StrippedLongToObjectMap(StrippedLongToObjectMap<V> original) {
        this.valueArrayFactory = original.valueArrayFactory;
        this.tableSize = original.tableSize;
        this.mask = original.mask;
        this.maxFill = original.maxFill;
        this.size = original.size;
        this.keys = (long[])original.keys.clone();
        this.values = (Object[])original.values.clone();
        this.containsNullKey = original.containsNullKey;
    }

    private int realSize() {
        return this.containsNullKey ? this.size - 1 : this.size;
    }

    public int index(long key) {
        if (key == 0L) {
            return this.containsNullKey ? this.tableSize : -(this.tableSize + 1);
        }
        long[] keys = this.keys;
        int index = (int)Hash.mix(key) & this.mask;
        long current = keys[index];
        if (current == 0L) {
            return -(index + 1);
        }
        if (key == current) {
            return index;
        }
        do {
            if ((current = keys[index = index + 1 & this.mask]) != 0L) continue;
            return -(index + 1);
        } while (key != current);
        return index;
    }

    public void addByIndex(int index, long key, V value) {
        this.replaceByIndex(-index - 1, key, value);
        if (this.size++ >= this.maxFill) {
            this.rehash(Hash.arraySize(this.size + 1, 0.75f));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void replaceByIndex(int index, long key, @NotNull V v) {
        void value;
        if (v == null) {
            StrippedLongToObjectMap.$$$reportNull$$$0(0);
        }
        if (index == this.tableSize) {
            this.containsNullKey = true;
        }
        this.keys[index] = key;
        this.values[index] = value;
    }

    public V getByIndex(int index) {
        return this.values[index];
    }

    @Override
    public V apply(long k) {
        if (k == 0L) {
            return this.containsNullKey ? (V)this.values[this.tableSize] : null;
        }
        long[] key = this.keys;
        int pos = (int)Hash.mix(k) & this.mask;
        long curr = key[pos];
        if (curr == 0L) {
            return null;
        }
        if (k == curr) {
            return this.values[pos];
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0L) continue;
            return null;
        } while (k != curr);
        return this.values[pos];
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private void rehash(int newN) {
        long[] keys = this.keys;
        V[] values = this.values;
        int mask = newN - 1;
        long[] newKey = new long[newN + 1];
        V[] newValue = this.valueArrayFactory.apply(newN + 1);
        int i = this.tableSize;
        int j = this.realSize();
        while (j-- != 0) {
            while (keys[--i] == 0L) {
            }
            int pos = (int)Hash.mix(keys[i]) & mask;
            if (newKey[pos] != 0L) {
                while (newKey[pos = pos + 1 & mask] != 0L) {
                }
            }
            newKey[pos] = keys[i];
            newValue[pos] = values[i];
        }
        newValue[newN] = values[this.tableSize];
        this.tableSize = newN;
        this.mask = mask;
        this.maxFill = Hash.maxFill(this.tableSize, 0.75f);
        this.keys = newKey;
        this.values = newValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/lang/StrippedLongToObjectMap", "replaceByIndex"));
    }
}

