/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n.batch;

import com.intellij.codeInspection.i18n.JavaI18nizeQuickFixDialog;
import com.intellij.codeInspection.i18n.batch.I18nizedPropertyData;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.psi.I18nizedTextGenerator;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.ResourceBundleManager;
import com.intellij.lang.properties.references.I18nUtil;
import com.intellij.lang.properties.references.I18nizeQuickFixDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.TableUtil;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithStoredHistory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsagePreviewPanel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.UI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class I18nizeMultipleStringsDialog<D>
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(I18nizeMultipleStringsDialog.class);
    @NonNls
    private static final String LAST_USED_PROPERTIES_FILE = "LAST_USED_PROPERTIES_FILE";
    @NonNls
    private static final String LAST_USED_CONTEXT = "I18N_FIX_LAST_USED_CONTEXT";
    @NotNull
    private final Project myProject;
    private final List<I18nizedPropertyData<D>> myKeyValuePairs;
    @NotNull
    private final Function<? super D, ? extends List<UsageInfo>> myUsagePreviewProvider;
    private final Set<Module> myContextModules;
    private final ResourceBundleManager myResourceBundleManager;
    private JComboBox<String> myPropertiesFile;
    private UsagePreviewPanel myUsagePreviewPanel;
    private JBTable myTable;
    private final Icon myMarkAsNonNlsButtonIcon;
    private TextFieldWithHistory myRBEditorTextField;
    private boolean myShowCodeInfo;

    public I18nizeMultipleStringsDialog(@NotNull Project project, @NotNull List<I18nizedPropertyData<D>> keyValuePairs, @NotNull Set<PsiFile> contextFiles, @Nullable ResourceBundleManager bundleManager, @NotNull Function<? super D, ? extends List<UsageInfo>> usagePreviewProvider, Icon markAsNonNlsButtonIcon, boolean canShowCodeInfo) {
        if (project == null) {
            I18nizeMultipleStringsDialog.$$$reportNull$$$0(0);
        }
        if (keyValuePairs == null) {
            I18nizeMultipleStringsDialog.$$$reportNull$$$0(1);
        }
        if (contextFiles == null) {
            I18nizeMultipleStringsDialog.$$$reportNull$$$0(2);
        }
        if (usagePreviewProvider == null) {
            I18nizeMultipleStringsDialog.$$$reportNull$$$0(3);
        }
        super(project, true);
        this.myProject = project;
        this.myKeyValuePairs = keyValuePairs;
        this.myUsagePreviewProvider = usagePreviewProvider;
        this.myMarkAsNonNlsButtonIcon = markAsNonNlsButtonIcon;
        this.myContextModules = contextFiles.stream().map(ModuleUtilCore::findModuleForFile).filter(Objects::nonNull).collect(Collectors.toSet());
        this.myResourceBundleManager = bundleManager;
        if (bundleManager != null) {
            this.myShowCodeInfo = canShowCodeInfo && this.myResourceBundleManager.canShowJavaCodeInfo();
        }
        this.setTitle(PropertiesBundle.message((String)"i18nize.multiple.strings.dialog.title", (Object[])new Object[0]));
        this.init();
    }

    public String getI18NText(String propertyKey, String propertyValue, String paramsString) {
        I18nizedTextGenerator textGenerator = this.myResourceBundleManager.getI18nizedTextGenerator();
        if (textGenerator != null) {
            return textGenerator.getI18nizedConcatenationText(propertyKey, paramsString, this.getPropertiesFile(), null);
        }
        String templateName = paramsString.isEmpty() ? this.myResourceBundleManager.getTemplateName() : this.myResourceBundleManager.getConcatenationTemplateName();
        LOG.assertTrue(templateName != null);
        FileTemplate template = FileTemplateManager.getInstance((Project)this.myProject).getCodeTemplate(templateName);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("PROPERTY_KEY", propertyKey);
        attributes.put("RESOURCE_BUNDLE", this.myRBEditorTextField != null ? this.myRBEditorTextField.getText() : null);
        attributes.put("PROPERTY_VALUE", propertyValue);
        attributes.put("PARAMETERS", paramsString);
        try {
            return template.getText(attributes);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return "";
        }
    }

    protected String getDimensionServiceKey() {
        return "i18nInBatch";
    }

    protected JComponent createNorthPanel() {
        this.myPropertiesFile = new ComboBox();
        SwingUtilities.invokeLater(() -> ReadAction.nonBlocking(() -> this.myResourceBundleManager != null ? this.myResourceBundleManager.suggestPropertiesFiles(this.myContextModules) : I18nUtil.defaultSuggestPropertiesFiles((Project)this.myProject, this.myContextModules)).finishOnUiThread(ModalityState.stateForComponent(this.myPropertiesFile), files -> {
            this.myPropertiesFile.setModel(new DefaultComboBoxModel<String>(ArrayUtil.toStringArray((Collection)files)));
            if (!files.isEmpty()) {
                String contextString = this.getContextString();
                @NlsSafe String preselectedFile = contextString != null && contextString.equals(PropertiesComponent.getInstance((Project)this.myProject).getValue(LAST_USED_CONTEXT)) ? PropertiesComponent.getInstance((Project)this.myProject).getValue(LAST_USED_PROPERTIES_FILE) : null;
                this.myPropertiesFile.setSelectedItem(ObjectUtils.notNull(preselectedFile, (Object)((String)files.get(0))));
            }
        }).submit((Executor)AppExecutorUtil.getAppExecutorService()));
        new ComboboxSpeedSearch(this.myPropertiesFile);
        LabeledComponent component = new LabeledComponent();
        component.setText(JavaI18nBundle.message("property.file", new Object[0]));
        component.setComponent(this.myPropertiesFile);
        this.myPropertiesFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesFile propertiesFile = I18nizeMultipleStringsDialog.this.getPropertiesFile();
                if (propertiesFile != null) {
                    List pairs = I18nizeMultipleStringsDialog.this.myKeyValuePairs;
                    ReadAction.nonBlocking(() -> {
                        ArrayList result = new ArrayList();
                        for (I18nizedPropertyData data : pairs) {
                            result.add(data.changeKey(I18nizeQuickFixDialog.suggestUniquePropertyKey((String)data.getValue(), (String)data.getKey(), (PropertiesFile)propertiesFile)));
                        }
                        return result;
                    }).finishOnUiThread(ModalityState.stateForComponent(I18nizeMultipleStringsDialog.this.myPropertiesFile), datum -> {
                        for (int i = 0; i < datum.size(); ++i) {
                            I18nizeMultipleStringsDialog.this.myKeyValuePairs.set(i, (I18nizedPropertyData)datum.get(i));
                        }
                    }).submit((Executor)AppExecutorUtil.getAppExecutorService());
                }
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)component, "North");
        if (this.myShowCodeInfo && this.hasResourceBundleInTemplate()) {
            this.myRBEditorTextField = new TextFieldWithStoredHistory("RESOURCE_BUNDLE_KEYS");
            if (!this.myRBEditorTextField.getHistory().isEmpty()) {
                this.myRBEditorTextField.setSelectedIndex(0);
            }
            panel.add((Component)UI.PanelFactory.panel((JComponent)this.myRBEditorTextField).withLabel(JavaI18nBundle.message("i18n.quickfix.code.panel.resource.bundle.expression.label", new Object[0])).withComment(JavaI18nBundle.message("comment.if.the.resource.bundle.is.invalid.either.declare.it.as.an.object", new Object[0])).createPanel(), "South");
        }
        return panel;
    }

    private boolean hasResourceBundleInTemplate() {
        return JavaI18nizeQuickFixDialog.showResourceBundleTextField(this.myResourceBundleManager.getTemplateName(), this.myProject) || JavaI18nizeQuickFixDialog.showResourceBundleTextField(this.myResourceBundleManager.getConcatenationTemplateName(), this.myProject);
    }

    public PropertiesFile getPropertiesFile() {
        Object selectedItem = this.myPropertiesFile.getSelectedItem();
        if (selectedItem == null) {
            return null;
        }
        String path = FileUtil.toSystemIndependentName((String)((String)selectedItem));
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
        return virtualFile != null ? PropertiesImplUtil.getPropertiesFile((PsiFile)PsiManager.getInstance((Project)this.myProject).findFile(virtualFile)) : null;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JBSplitter splitter = new JBSplitter(true);
        this.myUsagePreviewPanel = new UsagePreviewPanel(this.myProject, new UsageViewPresentation());
        this.myTable = new JBTable((TableModel)new MyKeyValueModel());
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.putClientProperty("html.disable", Boolean.TRUE);
        this.myTable.setDefaultRenderer(String.class, (TableCellRenderer)renderer);
        this.myTable.getSelectionModel().addListSelectionListener(e -> this.updateUsagePreview(this.myTable));
        AnActionButtonRunnable removeAction = new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.removeSelectedItems((JTable)I18nizeMultipleStringsDialog.this.myTable);
                I18nizeMultipleStringsDialog.this.myTable.repaint();
                I18nizeMultipleStringsDialog.this.updateUsagePreview(I18nizeMultipleStringsDialog.this.myTable);
            }
        };
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)this.myTable).setRemoveAction(removeAction);
        if (this.myMarkAsNonNlsButtonIcon != null) {
            AnActionButton markAsNonNls = new AnActionButton(JavaI18nBundle.message("action.text.mark.as.nonnls", new Object[0]), this.myMarkAsNonNlsButtonIcon){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    TableUtil.stopEditing((JTable)I18nizeMultipleStringsDialog.this.myTable);
                    List selection = I18nizeMultipleStringsDialog.this.getSelectedDataWithIndices();
                    boolean mark = this.shouldMarkAsNonNls(selection);
                    for (Pair dataWithIndex : selection) {
                        I18nizeMultipleStringsDialog.this.myKeyValuePairs.set((Integer)dataWithIndex.first, ((I18nizedPropertyData)dataWithIndex.second).setMarkAsNonNls(mark));
                    }
                    I18nizeMultipleStringsDialog.this.myTable.repaint();
                }

                public void updateButton(@NotNull AnActionEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    List selection = I18nizeMultipleStringsDialog.this.getSelectedDataWithIndices();
                    e.getPresentation().setEnabled(!selection.isEmpty());
                    e.getPresentation().setText(this.shouldMarkAsNonNls(selection) ? JavaI18nBundle.message("action.text.mark.as.nonnls", new Object[0]) : JavaI18nBundle.message("action.text.unmark.as.nonnls", new Object[0]));
                }

                private boolean shouldMarkAsNonNls(List<Pair<Integer, I18nizedPropertyData<D>>> selection) {
                    return !selection.stream().allMatch(data -> ((I18nizedPropertyData)data.second).isMarkAsNonNls());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/codeInspection/i18n/batch/I18nizeMultipleStringsDialog$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "actionPerformed";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "updateButton";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            markAsNonNls.setShortcut((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(78, 512)));
            decorator.addExtraAction(markAsNonNls);
        }
        splitter.setFirstComponent((JComponent)decorator.createPanel());
        splitter.setSecondComponent((JComponent)this.myUsagePreviewPanel);
        return splitter;
    }

    @NotNull
    private List<Pair<Integer, I18nizedPropertyData<D>>> getSelectedDataWithIndices() {
        int[] rows = this.myTable.getSelectedRows();
        ArrayList<Pair<Integer, I18nizedPropertyData<D>>> selection = new ArrayList<Pair<Integer, I18nizedPropertyData<D>>>(rows.length);
        for (int row : rows) {
            if (0 > row || row >= this.myKeyValuePairs.size()) continue;
            selection.add(Pair.create((Object)row, this.myKeyValuePairs.get(row)));
        }
        ArrayList<Pair<Integer, I18nizedPropertyData<D>>> arrayList = selection;
        if (arrayList == null) {
            I18nizeMultipleStringsDialog.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private void updateUsagePreview(JBTable table) {
        int index = table.getSelectionModel().getLeadSelectionIndex();
        if (index != -1 && index < this.myKeyValuePairs.size()) {
            this.myUsagePreviewPanel.updateLayout(this.myUsagePreviewProvider.apply(this.myKeyValuePairs.get(index).getContextData()));
        } else {
            this.myUsagePreviewPanel.updateLayout(null);
        }
    }

    protected void doOKAction() {
        TableUtil.stopEditing((JTable)this.myTable);
        PropertiesComponent.getInstance((Project)this.myProject).setValue(LAST_USED_PROPERTIES_FILE, (String)this.myPropertiesFile.getSelectedItem());
        PropertiesComponent.getInstance((Project)this.myProject).setValue(LAST_USED_CONTEXT, this.getContextString());
        if (this.myRBEditorTextField != null) {
            this.myRBEditorTextField.addCurrentTextToHistory();
        }
        super.doOKAction();
    }

    @Nullable
    private String getContextString() {
        return this.myContextModules.stream().map(Module::getName).min(Comparator.naturalOrder()).orElse(null);
    }

    protected void dispose() {
        Disposer.dispose((Disposable)this.myUsagePreviewPanel);
        super.dispose();
    }

    public static ResourceBundleManager getResourceBundleManager(@NotNull Project project, @NotNull Set<PsiFile> contextFiles) {
        if (project == null) {
            I18nizeMultipleStringsDialog.$$$reportNull$$$0(5);
        }
        if (contextFiles == null) {
            I18nizeMultipleStringsDialog.$$$reportNull$$$0(6);
        }
        ResourceBundleManager bundleManager = null;
        try {
            bundleManager = ResourceBundleManager.getManager(contextFiles, project);
            LOG.assertTrue(bundleManager != null);
        }
        catch (ResourceBundleManager.ResourceBundleNotFoundException e) {
            LOG.error((Throwable)e);
        }
        return bundleManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValuePairs";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFiles";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usagePreviewProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/i18n/batch/I18nizeMultipleStringsDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/i18n/batch/I18nizeMultipleStringsDialog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDataWithIndices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getResourceBundleManager";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyKeyValueModel
    extends AbstractTableModel
    implements ItemRemovable {
        private MyKeyValueModel() {
        }

        @Override
        public int getRowCount() {
            return I18nizeMultipleStringsDialog.this.myKeyValuePairs.size();
        }

        @Override
        public String getColumnName(int column) {
            return column == 0 ? JavaI18nBundle.message("key.column.name", new Object[0]) : JavaI18nBundle.message("value.column.name", new Object[0]);
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0 && 0 <= rowIndex && rowIndex < I18nizeMultipleStringsDialog.this.myKeyValuePairs.size() && !I18nizeMultipleStringsDialog.this.myKeyValuePairs.get(rowIndex).isMarkAsNonNls();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            I18nizedPropertyData data = I18nizeMultipleStringsDialog.this.myKeyValuePairs.get(rowIndex);
            if (columnIndex == 0) {
                return data.isMarkAsNonNls() ? "will be marked as NonNls" : data.getKey();
            }
            return data.getValue();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                I18nizedPropertyData bean = I18nizeMultipleStringsDialog.this.myKeyValuePairs.get(rowIndex);
                I18nizeMultipleStringsDialog.this.myKeyValuePairs.set(rowIndex, bean.changeKey((String)aValue));
            }
        }

        public void removeRow(int idx) {
            I18nizeMultipleStringsDialog.this.myKeyValuePairs.remove(idx);
        }
    }
}

