/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractFilterChildren;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.ExecResult;
import org.jetbrains.idea.perforce.perforce.PerforcePhysicalConnectionParameters;
import org.jetbrains.idea.perforce.perforce.PerforcePhysicalConnectionParametersI;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.PerforceTimeoutException;
import org.jetbrains.idea.perforce.perforce.connections.P4ConfigFields;
import org.jetbrains.idea.perforce.perforce.connections.P4ConfigHelper;
import org.jetbrains.idea.perforce.perforce.connections.P4ConnectionParameters;
import org.jetbrains.idea.perforce.perforce.connections.PerforceLocalConnection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceMultipleConnections;

public class P4ConnectionCalculator {
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance(P4ConnectionCalculator.class);
    private PerforceMultipleConnections myMultipleConnections;
    private static final String ourInConfig = "(config";
    private static final String ourInEnvironment = "(set";
    private static final String ourInEnvironment2 = "(env";

    public P4ConnectionCalculator(Project project) {
        this.myProject = project;
    }

    public void execute() {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        PerforceVcs vcs = PerforceVcs.getInstance(this.myProject);
        PerforceSettings settings = PerforceSettings.getSettings(this.myProject);
        PerforcePhysicalConnectionParameters physicalParameters = new PerforcePhysicalConnectionParameters(settings.getPathToExec(), settings.getPathToIgnore(), this.myProject, settings.getServerTimeout(), settings.getCharsetName());
        List detailedVcsMappings = vcsManager.getDetailedVcsMappings((AbstractVcs)vcs);
        String p4ConfigFileName = detailedVcsMappings.isEmpty() ? P4ConfigHelper.getP4ConfigFileName() : this.runSetOnFile(physicalParameters, new P4ConnectionParameters(), ((VirtualFile)detailedVcsMappings.get(0)).getPath()).getConfigFileName();
        LOG.debug("Using p4config file name: " + p4ConfigFileName);
        Map<VirtualFile, File> configsMap = p4ConfigFileName == null ? Collections.emptyMap() : P4ConnectionCalculator.fillConfigsMap(detailedVcsMappings, p4ConfigFileName);
        HashMap<VirtualFile, P4ConnectionParameters> connectionSettings = new HashMap<VirtualFile, P4ConnectionParameters>();
        P4ConnectionParameters defaultParameters = new P4ConnectionParameters();
        ApplicationManager.getApplication().runReadAction(() -> {
            P4ConnectionCalculator.filterByConfigFiles(configsMap, detailedVcsMappings);
            for (VirtualFile mapping : detailedVcsMappings) {
                P4ConnectionParameters value;
                File configParentDir = (File)configsMap.get(mapping);
                if (configParentDir == null) {
                    value = new P4ConnectionParameters();
                    value.setNoConfigFound(true);
                } else {
                    assert (p4ConfigFileName != null);
                    value = P4ConnectionCalculator.getParametersFromConfig(configParentDir, p4ConfigFileName);
                }
                value.setConfigFileName(p4ConfigFileName);
                LOG.debug("Using " + value + " for " + mapping);
                connectionSettings.put(mapping, value);
            }
            this.fillDefaultValues(physicalParameters, detailedVcsMappings, defaultParameters);
        });
        P4ConnectionCalculator.filterSimilarConfigFiles(connectionSettings, detailedVcsMappings);
        connectionSettings.keySet().retainAll(detailedVcsMappings);
        configsMap.keySet().retainAll(detailedVcsMappings);
        this.myMultipleConnections = new PerforceMultipleConnections(p4ConfigFileName, defaultParameters, connectionSettings, configsMap);
    }

    @NotNull
    public PerforceMultipleConnections getMultipleConnections() {
        PerforceMultipleConnections perforceMultipleConnections = this.myMultipleConnections;
        if (perforceMultipleConnections == null) {
            P4ConnectionCalculator.$$$reportNull$$$0(0);
        }
        return perforceMultipleConnections;
    }

    private static void filterSimilarConfigFiles(final Map<VirtualFile, P4ConnectionParameters> connectionSettings, List<VirtualFile> detailedVcsMappings) {
        AbstractFilterChildren<VirtualFile> filter = new AbstractFilterChildren<VirtualFile>(){

            protected void sortAscending(List<? extends VirtualFile> list) {
                list.sort((Comparator<? extends VirtualFile>)FilePathComparator.getInstance());
            }

            protected boolean isAncestor(VirtualFile parent, VirtualFile child) {
                P4ConnectionParameters parentSettings = (P4ConnectionParameters)connectionSettings.get(parent);
                P4ConnectionParameters childSettings = (P4ConnectionParameters)connectionSettings.get(child);
                if (parentSettings.hasProblems() || childSettings.hasProblems()) {
                    return false;
                }
                if (!VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)child, (boolean)false)) {
                    return false;
                }
                return parentSettings.equals(childSettings);
            }
        };
        filter.doFilter(detailedVcsMappings);
    }

    private void fillDefaultValues(PerforcePhysicalConnectionParametersI physicalParameters, List<VirtualFile> detailedVcsMappings, P4ConnectionParameters defaultParameters) {
        if (P4ConfigHelper.hasP4ConfigSettingInEnvironment()) {
            for (VirtualFile vcsMapping : detailedVcsMappings) {
                P4ConnectionParameters parameters = this.runSetOnFile(physicalParameters, defaultParameters, vcsMapping.getPath());
                P4ConnectionCalculator.takeProblemsInfoDefaultParams(parameters, defaultParameters);
                if (!defaultParameters.allFieldsDefined()) continue;
                break;
            }
        } else {
            String path;
            VirtualFile file = this.myProject.getBaseDir();
            if (file == null) {
                File[] roots = File.listRoots();
                if (roots == null || roots.length == 0) {
                    LOG.info("File.listRoots() returned empty array");
                    return;
                }
                path = roots[0].getPath();
            } else {
                path = file.getPath();
            }
            P4ConnectionParameters params = this.runSetOnFile(physicalParameters, defaultParameters, path);
            P4ConnectionCalculator.takeProblemsInfoDefaultParams(params, defaultParameters);
        }
    }

    private static void takeProblemsInfoDefaultParams(P4ConnectionParameters params, P4ConnectionParameters defaultParameters) {
        if (params.hasProblems()) {
            if (params.getException() != null) {
                defaultParameters.setException(params.getException());
            }
            if (!params.getWarnings().isEmpty()) {
                for (String warning : params.getWarnings()) {
                    defaultParameters.addWarning(warning);
                }
            }
        }
    }

    private static void filterByConfigFiles(final Map<VirtualFile, File> configsMap, List<VirtualFile> detailedVcsMappings) {
        AbstractFilterChildren<VirtualFile> filter = new AbstractFilterChildren<VirtualFile>(){

            protected void sortAscending(List<? extends VirtualFile> list) {
                list.sort((Comparator<? extends VirtualFile>)FilePathComparator.getInstance());
            }

            protected boolean isAncestor(VirtualFile parent, VirtualFile child) {
                if (!Comparing.equal((Object)((File)configsMap.get(parent)), (Object)((File)configsMap.get(child)))) {
                    return false;
                }
                return VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)child, (boolean)false);
            }
        };
        filter.doFilter(detailedVcsMappings);
    }

    private static Map<VirtualFile, File> fillConfigsMap(List<VirtualFile> detailedVcsMappings, @NotNull String p4ConfigFileName) {
        if (p4ConfigFileName == null) {
            P4ConnectionCalculator.$$$reportNull$$$0(1);
        }
        P4ConfigHelper p4ConfigHelper = new P4ConfigHelper();
        HashMap<VirtualFile, File> result = new HashMap<VirtualFile, File>();
        for (VirtualFile vcsMapping : detailedVcsMappings) {
            result.put(vcsMapping, p4ConfigHelper.findDirWithP4ConfigFile(vcsMapping, p4ConfigFileName));
        }
        return result;
    }

    private P4ConnectionParameters runSetOnFile(PerforcePhysicalConnectionParametersI settings, P4ConnectionParameters defaultParameters, String file) {
        P4ConnectionParameters parameters = new P4ConnectionParameters();
        ExecResult retVal = new ExecResult();
        if (!this.runSetImpl(settings, file, parameters, retVal)) {
            return parameters;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("p4 set output: " + retVal);
        }
        P4ConnectionCalculator.parseSetOutput(defaultParameters, parameters, retVal.getStdout());
        return parameters;
    }

    public static void parseSetOutput(P4ConnectionParameters defaultParameters, P4ConnectionParameters parameters, String output) {
        Map<String, P4ConfigFields> fields = P4ConnectionCalculator.p4FieldsAsMap();
        for (String line : StringUtil.splitByLines((String)output)) {
            int valueEnd;
            String value;
            String key;
            P4ConfigFields fieldType;
            int eqIdx = line.indexOf("=");
            if (eqIdx == -1 || (fieldType = fields.get(StringUtil.toLowerCase((String)(key = line.substring(0, eqIdx))))) == null) continue;
            int configIdx = line.indexOf(ourInConfig, eqIdx + 1);
            int envIdx = line.indexOf(ourInEnvironment, eqIdx + 1);
            if (envIdx < 0) {
                envIdx = line.indexOf(ourInEnvironment2, eqIdx + 1);
            }
            if ((value = line.substring(eqIdx + 1, valueEnd = envIdx > 0 ? envIdx : (configIdx > 0 ? configIdx : line.length())).trim()).isEmpty()) continue;
            P4ConnectionCalculator.setField(fieldType, value, parameters);
            if (configIdx >= 0) continue;
            P4ConnectionCalculator.setField(fieldType, value, defaultParameters);
        }
    }

    private static Map<String, P4ConfigFields> p4FieldsAsMap() {
        P4ConfigFields[] p4ConfigFields = P4ConfigFields.values();
        HashMap<String, P4ConfigFields> fields = new HashMap<String, P4ConfigFields>();
        for (P4ConfigFields configField : p4ConfigFields) {
            fields.put(StringUtil.toLowerCase((String)configField.getName()), configField);
        }
        return fields;
    }

    public static P4ConnectionParameters getParametersFromConfig(File configParentDir, @NotNull String name) {
        if (name == null) {
            P4ConnectionCalculator.$$$reportNull$$$0(2);
        }
        P4ConnectionParameters parameters = new P4ConnectionParameters();
        JBIterable allConfigs = JBIterable.generate((Object)configParentDir, File::getParentFile).map(dir -> new File((File)dir, name)).filter(File::exists);
        try {
            for (File ioFile : ContainerUtil.reverse((List)allConfigs.toList())) {
                String data = String.valueOf(FileUtil.loadFileText((File)ioFile));
                Map<String, P4ConfigFields> fields = P4ConnectionCalculator.p4FieldsAsMap();
                for (String line : StringUtil.splitByLines((String)data)) {
                    ArrayList split = Lists.newArrayList((Iterable)Splitter.on((char)'=').limit(2).trimResults().split((CharSequence)line));
                    if (split.size() != 2) continue;
                    String key = (String)split.get(0);
                    P4ConfigFields p4ConfigField = fields.get(StringUtil.toLowerCase((String)key));
                    P4ConnectionCalculator.setField(p4ConfigField, (String)split.get(1), parameters);
                }
            }
        }
        catch (IOException e) {
            parameters.setException(e);
        }
        return parameters;
    }

    private boolean runSetImpl(PerforcePhysicalConnectionParametersI settings, String file, P4ConnectionParameters parameters, ExecResult retVal) {
        PerforceLocalConnection localConnection = new PerforceLocalConnection(file);
        try {
            localConnection.runP4Command(settings, new String[]{"set"}, retVal, null);
        }
        catch (VcsException | IOException | InterruptedException | PerforceTimeoutException e) {
            parameters.setException(e);
            return false;
        }
        try {
            PerforceRunner.checkError(retVal, new PerforceSettings(this.myProject), localConnection);
        }
        catch (VcsException e) {
            parameters.setException(e);
            return false;
        }
        return true;
    }

    private static void setField(P4ConfigFields fieldType, String value, P4ConnectionParameters parameters) {
        if (P4ConfigFields.P4CLIENT.equals((Object)fieldType)) {
            parameters.setClient(value);
        } else if (P4ConfigFields.P4PASSWD.equals((Object)fieldType)) {
            parameters.setPassword(value);
        } else if (P4ConfigFields.P4PORT.equals((Object)fieldType)) {
            parameters.setServer(value);
        } else if (P4ConfigFields.P4USER.equals((Object)fieldType)) {
            parameters.setUser(value);
        } else if (P4ConfigFields.P4CHARSET.equals((Object)fieldType)) {
            parameters.setCharset(value);
        } else if (P4ConfigFields.P4CONFIG.equals((Object)fieldType)) {
            parameters.setConfigFileName(value);
        } else if (P4ConfigFields.P4IGNORE.equals((Object)fieldType)) {
            parameters.setIgnoreFileName(value);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/perforce/connections/P4ConnectionCalculator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p4ConfigFileName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMultipleConnections";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/perforce/connections/P4ConnectionCalculator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fillConfigsMap";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getParametersFromConfig";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

