/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.login;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.NlsContexts;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.perforce.login.LoginPerformer;
import org.jetbrains.idea.perforce.perforce.login.LoginState;
import org.jetbrains.idea.perforce.perforce.login.LoginStateListener;

public final class AttemptsStateMachine {
    private static final Logger LOG = Logger.getInstance(AttemptsStateMachine.class);
    private static final long ourTimeToRelogin = 3600000L;
    private static final long ourSuccessBlindInterval = 600000L;
    private static final long ourCredentialsBlindInterval = 1000L;
    private static final long ourNetworkBlindInterval = 600000L;
    private final LoginPerformer myPerformer;
    private final LoginStateListener myLoginStateListener;
    private boolean myConnectionProblem;
    private @NlsContexts.DialogMessage String myErrorMessage;
    private boolean mySuccess;
    private long myRecentTime;
    private final Object myLock = new Object();

    public AttemptsStateMachine(LoginPerformer performer, LoginStateListener loginStateListener) {
        this.myPerformer = performer;
        this.myLoginStateListener = loginStateListener;
        this.myRecentTime = -1L;
    }

    private void fillTime() {
        this.myRecentTime = System.currentTimeMillis();
    }

    public LoginState login(String password) {
        LOG.debug("login called");
        return this.executeUnderLock(() -> this.myPerformer.login(password));
    }

    private void registerResult(LoginState state) {
        if (this.myRecentTime > 0L && this.mySuccess == state.isSuccess() && Objects.equals(this.myErrorMessage, state.getError()) && this.myConnectionProblem == (state.getError() != null)) {
            if (System.currentTimeMillis() - this.myRecentTime > 600000L) {
                this.fillTime();
            }
            LOG.debug("register result: login state didn't changed");
            return;
        }
        this.fillTime();
        this.mySuccess = state.isSuccess();
        this.myErrorMessage = state.getError();
        this.myConnectionProblem = this.myErrorMessage != null;
        LOG.debug("register result: success = " + this.mySuccess + ", network = " + this.myConnectionProblem);
    }

    private LoginState checkState() {
        LOG.debug("try checkState");
        LoginState state = this.myPerformer.getLoginState();
        if (state.isSuccess()) {
            LOG.debug("login state success");
            long timeLeft = state.getTimeLeft();
            if (timeLeft > 0L && 3600000L > timeLeft) {
                LOG.debug("doing preventing relogin");
                return this.myPerformer.loginWithStoredPassword();
            }
        }
        return state;
    }

    private LoginState checkLoggedOrSilent() {
        LOG.debug("try checkLoggedOrSilent");
        LoginState state = this.checkState();
        if (state.isSuccess()) {
            LOG.debug("login state success (checkLoggedOrSilent)");
            return state;
        }
        LOG.debug("login state not logged");
        if (state.getError() != null) {
            LOG.debug("error not null -> must be connection problem");
            return state;
        }
        LOG.debug("silent login allowed, logging");
        return this.myPerformer.loginWithStoredPassword();
    }

    private LoginState silentReconnect() {
        LOG.debug("try silent reconnect");
        return this.myPerformer.loginWithStoredPassword();
    }

    private LoginState ensureImpl(boolean ignoreDelays) {
        try {
            boolean inBlindInterval;
            if (this.myRecentTime == -1L) {
                LOG.debug("init state");
                return this.checkLoggedOrSilent();
            }
            long time = System.currentTimeMillis() - this.myRecentTime;
            LOG.debug("ensure, recent time: " + this.myRecentTime + ", time: " + time + ", ignoreDelays: " + ignoreDelays);
            boolean bl = inBlindInterval = !ignoreDelays && time < 600000L;
            if (this.mySuccess) {
                LOG.debug("currently success");
                if (inBlindInterval) {
                    LOG.debug("success blind interval");
                    return LoginState.SUCCESS;
                }
                return this.checkLoggedOrSilent();
            }
            LoginState currentState = this.checkState();
            if (currentState.isSuccess()) {
                LOG.debug("turned out state is success");
                return LoginState.SUCCESS;
            }
            if (!this.myConnectionProblem) {
                LOG.debug("currently credentials problem");
                if (!ignoreDelays && !this.myPerformer.isCredentialsChanged() && time < 1000L) {
                    LOG.debug("credentials hasn't changed");
                    return LoginState.SUCCESS;
                }
                return this.silentReconnect();
            }
            LOG.debug("currently connection problem");
            if (time < 600000L) {
                LOG.debug("connection blind interval");
                return new LoginState(false, -1L, currentState.getError() != null ? currentState.getError() : this.myErrorMessage);
            }
            return this.silentReconnect();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.info(e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoginState executeUnderLock(Supplier<LoginState> getter) {
        boolean triggerChangesUpdate;
        LoginState result;
        Object object = this.myLock;
        synchronized (object) {
            boolean wasLogged = this.mySuccess;
            result = getter.get();
            this.registerResult(result);
            triggerChangesUpdate = !wasLogged && this.mySuccess;
        }
        if (triggerChangesUpdate) {
            LOG.debug("reconnected");
            this.myLoginStateListener.reconnected(this.myPerformer.getMyConnection());
        }
        return result;
    }

    public LoginState ensure(boolean ignoreDelays) {
        return this.executeUnderLock(() -> this.ensureImpl(ignoreDelays));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed(boolean connectionProblem, @Nullable @NlsContexts.DialogMessage String errorMessage) {
        Object object = this.myLock;
        synchronized (object) {
            this.myConnectionProblem = connectionProblem;
            this.myErrorMessage = errorMessage;
            this.mySuccess = false;
            this.fillTime();
            this.logSuccessOrFailure(false);
        }
    }

    private void logSuccessOrFailure(boolean success) {
        LOG.debug("Reported: " + (success ? "logged" : "not logged") + ", time: " + this.myRecentTime);
    }
}

