/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.BuildIssueEventImpl;
import com.intellij.build.issue.BuildIssue;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.pom.Navigatable;
import com.intellij.pom.java.LanguageLevel;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenParsingContext;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenSpyLoggedEventParser;
import org.jetbrains.idea.maven.externalSystemIntegration.output.parsers.MavenEventType;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.SetupModuleSdkQuickFix;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\tH\u0002J2\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\t2\u0010\u0010\u0014\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u00160\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/InvalidTargetReleaseQuickFix;", "Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenSpyLoggedEventParser;", "()V", "getBuildIssue", "Lcom/intellij/build/issue/BuildIssue;", "sourceLanguageLevel", "Lcom/intellij/pom/java/LanguageLevel;", "moduleProjectLanguageLevel", "errorMessage", "", "moduleRootManager", "Lcom/intellij/openapi/roots/ModuleRootManager;", "getLanguageLevelFromLog", "logLine", "processLogLine", "", "parentId", "", "parsingContext", "Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenParsingContext;", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "supportsType", "type", "Lorg/jetbrains/idea/maven/externalSystemIntegration/output/parsers/MavenEventType;", "intellij.maven"})
public final class InvalidTargetReleaseQuickFix
implements MavenSpyLoggedEventParser {
    @Override
    public boolean supportsType(@NotNull MavenEventType type2) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        return type2 == MavenEventType.MOJO_FAILED;
    }

    @Override
    public boolean processLogLine(@NotNull Object parentId, @NotNull MavenParsingContext parsingContext, @NotNull String logLine, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        block11: {
            Sdk sdk;
            ModuleRootManager moduleRootManager;
            block13: {
                block12: {
                    Sdk sdk2;
                    Object v0;
                    block10: {
                        Iterable iterable;
                        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
                        Intrinsics.checkNotNullParameter((Object)parsingContext, (String)"parsingContext");
                        Intrinsics.checkNotNullParameter((Object)logLine, (String)"logLine");
                        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
                        if (!StringsKt.contains$default((CharSequence)logLine, (CharSequence)"invalid target release:", (boolean)false, (int)2, null)) break block11;
                        String lastErrorProject = (String)CollectionsKt.last((List)parsingContext.getStartedProjects()) + ":";
                        Iterable iterable2 = iterable = (Iterable)parsingContext.getProjectsInReactor();
                        for (Object t : iterable2) {
                            String it = (String)t;
                            boolean bl = false;
                            if (!StringsKt.startsWith$default((String)it, (String)lastErrorProject, (boolean)false, (int)2, null)) continue;
                            v0 = t;
                            break block10;
                        }
                        v0 = null;
                    }
                    String string = v0;
                    if (string == null) {
                        return false;
                    }
                    String failedProject = string;
                    Project project2 = parsingContext.getIdeaProject();
                    MavenProject mavenProject2 = MavenProjectsManager.getInstance(project2).findProject(new MavenId(failedProject));
                    if (mavenProject2 == null) {
                        return false;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)mavenProject2, (String)"MavenProjectsManager.get\u2026Project)) ?: return false");
                    MavenProject mavenProject3 = mavenProject2;
                    MavenId mavenId = mavenProject3.getMavenId();
                    Intrinsics.checkNotNullExpressionValue((Object)mavenId, (String)"mavenProject.mavenId");
                    if (mavenId.getArtifactId() == null) {
                        return false;
                    }
                    ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
                    MavenId mavenId2 = mavenProject3.getMavenId();
                    Intrinsics.checkNotNullExpressionValue((Object)mavenId2, (String)"mavenProject.mavenId");
                    String string2 = mavenId2.getArtifactId();
                    Intrinsics.checkNotNull((Object)string2);
                    Module module = moduleManager.findModuleByName(string2);
                    if (module == null) {
                        return false;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)module, (String)"ModuleManager.getInstanc\u2026factId!!) ?: return false");
                    Module module2 = module;
                    ModuleRootManager moduleRootManager2 = ModuleRootManager.getInstance((Module)module2);
                    if (moduleRootManager2 == null) {
                        return false;
                    }
                    moduleRootManager = moduleRootManager2;
                    Sdk moduleJdk = moduleRootManager.getSdk();
                    sdk = moduleJdk;
                    if (sdk == null) break block12;
                    Sdk it = sdk2 = sdk;
                    boolean bl = false;
                    sdk = LanguageLevel.parse((String)it.getVersionString());
                    if (sdk != null) break block13;
                }
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"moduleJdk?.let { Languag\u2026String) } ?: return false");
            Sdk moduleProjectLanguageLevel = sdk;
            LanguageLevel languageLevel2 = this.getLanguageLevelFromLog(logLine);
            if (languageLevel2 == null) {
                return false;
            }
            LanguageLevel sourceLanguageLevel = languageLevel2;
            messageConsumer.accept((BuildEvent)new BuildIssueEventImpl(parentId, this.getBuildIssue(sourceLanguageLevel, (LanguageLevel)moduleProjectLanguageLevel, logLine, moduleRootManager), MessageEvent.Kind.ERROR));
            return true;
        }
        return false;
    }

    private final LanguageLevel getLanguageLevelFromLog(String logLine) {
        Object object = CollectionsKt.last((List)StringsKt.split$default((CharSequence)logLine, (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null));
        String it = (String)object;
        boolean bl = false;
        return LanguageLevel.parse((String)it);
    }

    private final BuildIssue getBuildIssue(LanguageLevel sourceLanguageLevel, LanguageLevel moduleProjectLanguageLevel, String errorMessage, ModuleRootManager moduleRootManager) {
        Module module = moduleRootManager.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"moduleRootManager.module");
        String string = module.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"moduleRootManager.module.name");
        String moduleName = string;
        SetupModuleSdkQuickFix setupModuleSdkQuickFix = new SetupModuleSdkQuickFix(moduleName, moduleRootManager.isSdkInherited());
        List quickFixes = CollectionsKt.listOf((Object)setupModuleSdkQuickFix);
        StringBuilder issueDescription = new StringBuilder(errorMessage);
        issueDescription.append("\n\n");
        issueDescription.append(MavenProjectBundle.message("maven.quickfix.source.version.great", moduleName, moduleProjectLanguageLevel.toJavaVersion(), sourceLanguageLevel.toJavaVersion(), setupModuleSdkQuickFix.getId()));
        return new BuildIssue(errorMessage, issueDescription, quickFixes){
            @NotNull
            private final String title;
            @NotNull
            private final String description;
            @NotNull
            private final List<SetupModuleSdkQuickFix> quickFixes;
            final /* synthetic */ String $errorMessage;
            final /* synthetic */ StringBuilder $issueDescription;
            final /* synthetic */ List $quickFixes;

            @NotNull
            public String getTitle() {
                return this.title;
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public List<SetupModuleSdkQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                return null;
            }
            {
                this.$errorMessage = $captured_local_variable$0;
                this.$issueDescription = $captured_local_variable$1;
                this.$quickFixes = $captured_local_variable$2;
                this.title = $captured_local_variable$0;
                String string = $captured_local_variable$1.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"issueDescription.toString()");
                this.description = string;
                this.quickFixes = $captured_local_variable$2;
            }
        };
    }
}

