/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.tree;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenModuleImporter;
import org.jetbrains.idea.maven.importing.tree.MavenModuleImportDataWithDependencies;
import org.jetbrains.idea.maven.importing.tree.MavenProjectImportData;
import org.jetbrains.idea.maven.importing.tree.SplittedMainAndTestModules;
import org.jetbrains.idea.maven.importing.tree.dependency.BaseDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.MavenImportDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.ModuleDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.SystemDependency;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.SupportedRequestType;

public class MavenModuleImportDependencyProvider {
    public static final int INITIAL_CAPACITY_TEST_DEPENDENCY_LIST = 4;
    @NotNull
    private final Project project;
    @NotNull
    private final Map<MavenId, MavenProjectImportData> moduleImportDataByMavenId;
    @NotNull
    private final Set<String> dependencyTypesFromSettings;
    @NotNull
    private final MavenProjectsTree myProjectTree;

    public MavenModuleImportDependencyProvider(@NotNull Project project2, @NotNull Map<MavenId, MavenProjectImportData> moduleImportDataByMavenId, @NotNull MavenImportingSettings importingSettings, @NotNull MavenProjectsTree projectTree) {
        if (project2 == null) {
            MavenModuleImportDependencyProvider.$$$reportNull$$$0(0);
        }
        if (moduleImportDataByMavenId == null) {
            MavenModuleImportDependencyProvider.$$$reportNull$$$0(1);
        }
        if (importingSettings == null) {
            MavenModuleImportDependencyProvider.$$$reportNull$$$0(2);
        }
        if (projectTree == null) {
            MavenModuleImportDependencyProvider.$$$reportNull$$$0(3);
        }
        this.project = project2;
        this.moduleImportDataByMavenId = moduleImportDataByMavenId;
        this.dependencyTypesFromSettings = importingSettings.getDependencyTypesAsSet();
        this.myProjectTree = projectTree;
    }

    @NotNull
    public MavenModuleImportDataWithDependencies getDependencies(MavenProjectImportData importData) {
        MavenProject mavenProject2 = importData.getMavenProject();
        ArrayList mainDependencies = new ArrayList(mavenProject2.getDependencies().size());
        ArrayList testDependencies = new ArrayList(4);
        MavenModuleImportDependencyProvider.addMainDependencyToTestModule(importData, mavenProject2, testDependencies);
        boolean hasSeparateTestModule = importData.getSplittedMainAndTestModules() != null;
        for (MavenArtifact artifact : mavenProject2.getDependencies()) {
            MavenImportDependency<?> dependency = this.getDependency(artifact, mavenProject2);
            if (dependency == null) continue;
            if (hasSeparateTestModule && dependency.getScope() == DependencyScope.TEST) {
                testDependencies.add(dependency);
                continue;
            }
            mainDependencies.add(dependency);
        }
        return new MavenModuleImportDataWithDependencies(importData, mainDependencies, testDependencies);
    }

    private static void addMainDependencyToTestModule(MavenProjectImportData importData, MavenProject mavenProject2, List<MavenImportDependency<?>> testDependencies) {
        if (importData.getSplittedMainAndTestModules() != null) {
            testDependencies.add(new ModuleDependency(null, mavenProject2, importData.getSplittedMainAndTestModules().getMainData().getModuleName(), DependencyScope.COMPILE, false));
        }
    }

    @Nullable
    private MavenImportDependency<?> getDependency(MavenArtifact artifact, MavenProject mavenProject2) {
        String dependencyType = artifact.getType();
        if (!this.dependencyTypesFromSettings.contains(dependencyType) && !mavenProject2.getDependencyTypesFromImporters(SupportedRequestType.FOR_IMPORT).contains(dependencyType)) {
            return null;
        }
        DependencyScope scope = MavenModuleImporter.selectScope(artifact.getScope());
        MavenProject depProject = this.myProjectTree.findProject(artifact.getMavenId());
        if (depProject != null) {
            if (depProject == mavenProject2) {
                return null;
            }
            MavenProjectImportData mavenProjectImportData = this.moduleImportDataByMavenId.get(depProject.getMavenId());
            if (mavenProjectImportData == null || this.myProjectTree.isIgnored(depProject)) {
                return new BaseDependency(MavenModuleImporter.createCopyForLocalRepo(artifact, mavenProject2), scope);
            }
            boolean isTestJar = "test-jar".equals(dependencyType) || "tests".equals(artifact.getClassifier());
            String moduleName = MavenModuleImportDependencyProvider.getModuleName(mavenProjectImportData);
            MavenArtifact a = null;
            String classifier = artifact.getClassifier();
            if (classifier != null && MavenModuleImporter.IMPORTED_CLASSIFIERS.contains(classifier) && !isTestJar && !"system".equals(artifact.getScope()) && !"false".equals(System.getProperty("idea.maven.classifier.dep"))) {
                a = MavenModuleImporter.createCopyForLocalRepo(artifact, mavenProject2);
            }
            return new ModuleDependency(a, mavenProject2, moduleName, scope, isTestJar);
        }
        if ("system".equals(artifact.getScope())) {
            return new SystemDependency(artifact, scope);
        }
        if ("bundle".equals(dependencyType)) {
            artifact = new MavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getBaseVersion(), "jar", artifact.getClassifier(), artifact.getScope(), artifact.isOptional(), "jar", null, mavenProject2.getLocalRepository(), false, false);
        }
        return new BaseDependency(artifact, scope);
    }

    private static String getModuleName(MavenProjectImportData data) {
        SplittedMainAndTestModules modules2 = data.getSplittedMainAndTestModules();
        return modules2 == null ? data.getModuleData().getModuleName() : modules2.getMainData().getModuleName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "moduleImportDataByMavenId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "importingSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "projectTree";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/maven/importing/tree/MavenModuleImportDependencyProvider";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

