/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.tree.workspace;

import com.intellij.openapi.util.io.FileUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.tree.workspace.ContentRootCollector;
import org.jetbrains.idea.maven.importing.tree.workspace.ContentRootDataHolder;
import org.jetbrains.idea.maven.importing.tree.workspace.GeneratedFoldersHolder;
import org.jetbrains.idea.maven.importing.tree.workspace.SourceFolder;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000bH\u0002JF\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0016\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007JN\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0016\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J2\u0010\u0017\u001a\u00020\f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0018\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/idea/maven/importing/tree/workspace/ContentRootCollector;", "", "()V", "addGeneratedContentRoots", "", "generatedFoldersHolder", "Lorg/jetbrains/idea/maven/importing/tree/workspace/GeneratedFoldersHolder;", "sortedPotentialContentRootSet", "Ljava/util/TreeSet;", "", "contentRootDataHolderByPath", "", "Lorg/jetbrains/idea/maven/importing/tree/workspace/ContentRootDataHolder;", "collect", "", "baseContentRoot", "folderItemMap", "", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "excludedFolders", "", "createContentRootForTarget", "", "getGeneratedContentRootDataHolder", "folder", "intellij.maven"})
public final class ContentRootCollector {
    @NotNull
    public static final ContentRootCollector INSTANCE;

    @JvmStatic
    @NotNull
    public static final Collection<ContentRootDataHolder> collect(@NotNull String baseContentRoot, @NotNull Map<String, ? extends JpsModuleSourceRootType<?>> folderItemMap, @NotNull List<String> excludedFolders, @Nullable GeneratedFoldersHolder generatedFoldersHolder) {
        Intrinsics.checkNotNullParameter((Object)baseContentRoot, (String)"baseContentRoot");
        Intrinsics.checkNotNullParameter(folderItemMap, (String)"folderItemMap");
        Intrinsics.checkNotNullParameter(excludedFolders, (String)"excludedFolders");
        return ContentRootCollector.collect(baseContentRoot, folderItemMap, excludedFolders, generatedFoldersHolder, false);
    }

    @JvmStatic
    @NotNull
    public static final Collection<ContentRootDataHolder> collect(@NotNull String baseContentRoot, @NotNull Map<String, ? extends JpsModuleSourceRootType<?>> folderItemMap, @NotNull List<String> excludedFolders, @Nullable GeneratedFoldersHolder generatedFoldersHolder, boolean createContentRootForTarget) {
        ContentRootDataHolder answer$iv;
        Object value$iv;
        String key$iv;
        Map $this$getOrPut$iv;
        boolean $i$f$getOrPut;
        Intrinsics.checkNotNullParameter((Object)baseContentRoot, (String)"baseContentRoot");
        Intrinsics.checkNotNullParameter(folderItemMap, (String)"folderItemMap");
        Intrinsics.checkNotNullParameter(excludedFolders, (String)"excludedFolders");
        TreeSet<String> sortedPotentialContentRootSet2 = new TreeSet<String>(collect.sortedPotentialContentRootSet.1.INSTANCE);
        sortedPotentialContentRootSet2.add(baseContentRoot);
        Map<String, JpsModuleSourceRootType<?>> $this$forEach$iv = folderItemMap;
        boolean bl = false;
        Iterator<Object> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, JpsModuleSourceRootType<?>> entry;
            Map.Entry<String, JpsModuleSourceRootType<?>> it = entry = iterator.next();
            boolean bl2 = false;
            sortedPotentialContentRootSet2.add(it.getKey());
        }
        Map contentRootDataHolderByPath = new LinkedHashMap();
        Map<String, JpsModuleSourceRootType<?>> map2 = folderItemMap;
        block1: for (Map.Entry<String, JpsModuleSourceRootType<?>> entry : map2.entrySet()) {
            for (String string : sortedPotentialContentRootSet2) {
                Object object;
                if (!FileUtil.isAncestor((String)string, (String)entry.getKey(), (boolean)false)) continue;
                Map map3 = contentRootDataHolderByPath;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"contentRootPath");
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    answer$iv = new ContentRootDataHolder(string);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ContentRootDataHolder contentRootDataHolder = (ContentRootDataHolder)object;
                contentRootDataHolder.getSourceFolders().add(new SourceFolder(entry.getKey(), entry.getValue()));
                continue block1;
            }
        }
        block3: for (String string : excludedFolders) {
            for (String string2 : sortedPotentialContentRootSet2) {
                if (!FileUtil.isAncestor((String)string2, (String)string, (boolean)false)) continue;
                if (createContentRootForTarget) {
                    Object object;
                    $this$getOrPut$iv = contentRootDataHolderByPath;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"contentRootPath");
                    $i$f$getOrPut = false;
                    value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl4 = false;
                        answer$iv = new ContentRootDataHolder(string2);
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ContentRootDataHolder contentRootDataHolder = (ContentRootDataHolder)object;
                    contentRootDataHolder.getExcludedPaths().add(string);
                    continue block3;
                }
                Object object = (ContentRootDataHolder)contentRootDataHolderByPath.get(string2);
                if (object == null || (object = ((ContentRootDataHolder)object).getExcludedPaths()) == null) continue block3;
                object.add(string);
                continue block3;
            }
        }
        INSTANCE.addGeneratedContentRoots(generatedFoldersHolder, sortedPotentialContentRootSet2, contentRootDataHolderByPath);
        return contentRootDataHolderByPath.values();
    }

    private final void addGeneratedContentRoots(GeneratedFoldersHolder generatedFoldersHolder, TreeSet<String> sortedPotentialContentRootSet2, Map<String, ContentRootDataHolder> contentRootDataHolderByPath) {
        ContentRootDataHolder contentRootHolder;
        String folder;
        if (generatedFoldersHolder == null) {
            return;
        }
        if (generatedFoldersHolder.getAnnotationProcessorDirectory() != null) {
            folder = generatedFoldersHolder.getAnnotationProcessorDirectory();
            contentRootHolder = this.getGeneratedContentRootDataHolder(sortedPotentialContentRootSet2, folder, contentRootDataHolderByPath);
            List<SourceFolder> list = contentRootHolder.getAnnotationProcessorFolders();
            JavaSourceRootType javaSourceRootType = JavaSourceRootType.SOURCE;
            Intrinsics.checkNotNullExpressionValue((Object)javaSourceRootType, (String)"JavaSourceRootType.SOURCE");
            list.add(new SourceFolder(folder, (JpsModuleSourceRootType)javaSourceRootType));
        }
        if (generatedFoldersHolder.getAnnotationProcessorTestDirectory() != null) {
            folder = generatedFoldersHolder.getAnnotationProcessorTestDirectory();
            contentRootHolder = this.getGeneratedContentRootDataHolder(sortedPotentialContentRootSet2, folder, contentRootDataHolderByPath);
            List<SourceFolder> list = contentRootHolder.getAnnotationProcessorFolders();
            JavaSourceRootType javaSourceRootType = JavaSourceRootType.TEST_SOURCE;
            Intrinsics.checkNotNullExpressionValue((Object)javaSourceRootType, (String)"JavaSourceRootType.TEST_SOURCE");
            list.add(new SourceFolder(folder, (JpsModuleSourceRootType)javaSourceRootType));
        }
        if (generatedFoldersHolder.getGeneratedSourceFolder() != null) {
            folder = generatedFoldersHolder.getGeneratedSourceFolder();
            contentRootHolder = this.getGeneratedContentRootDataHolder(sortedPotentialContentRootSet2, folder, contentRootDataHolderByPath);
            List<SourceFolder> list = contentRootHolder.getGeneratedFolders();
            JavaSourceRootType javaSourceRootType = JavaSourceRootType.SOURCE;
            Intrinsics.checkNotNullExpressionValue((Object)javaSourceRootType, (String)"JavaSourceRootType.SOURCE");
            list.add(new SourceFolder(folder, (JpsModuleSourceRootType)javaSourceRootType));
        }
        if (generatedFoldersHolder.getGeneratedTestSourceFolder() != null) {
            folder = generatedFoldersHolder.getGeneratedTestSourceFolder();
            contentRootHolder = this.getGeneratedContentRootDataHolder(sortedPotentialContentRootSet2, folder, contentRootDataHolderByPath);
            List<SourceFolder> list = contentRootHolder.getGeneratedFolders();
            JavaSourceRootType javaSourceRootType = JavaSourceRootType.TEST_SOURCE;
            Intrinsics.checkNotNullExpressionValue((Object)javaSourceRootType, (String)"JavaSourceRootType.TEST_SOURCE");
            list.add(new SourceFolder(folder, (JpsModuleSourceRootType)javaSourceRootType));
        }
    }

    private final ContentRootDataHolder getGeneratedContentRootDataHolder(TreeSet<String> sortedPotentialContentRootSet2, String folder, Map<String, ContentRootDataHolder> contentRootDataHolderByPath) {
        ContentRootDataHolder contentRootHolder = null;
        for (String contentRootPath : sortedPotentialContentRootSet2) {
            if (!FileUtil.isAncestor((String)contentRootPath, (String)folder, (boolean)false)) continue;
            contentRootHolder = contentRootDataHolderByPath.get(contentRootPath);
            break;
        }
        if (contentRootHolder == null) {
            contentRootHolder = new ContentRootDataHolder(folder);
            contentRootDataHolderByPath.put(folder, contentRootHolder);
        }
        return contentRootHolder;
    }

    private ContentRootCollector() {
    }

    static {
        ContentRootCollector contentRootCollector;
        INSTANCE = contentRootCollector = new ContentRootCollector();
    }
}

