/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;

public class MavenProjectReaderResult {
    @NotNull
    public final MavenModel mavenModel;
    public final Map<String, String> nativeModelMap;
    public final MavenExplicitProfiles activatedProfiles;
    @Nullable
    public final NativeMavenProjectHolder nativeMavenProject;
    public final Collection<MavenProjectProblem> readingProblems;
    public final Set<MavenId> unresolvedArtifactIds;
    @NotNull
    public final Collection<MavenProjectProblem> unresolvedProblems;

    public MavenProjectReaderResult(@NotNull MavenModel mavenModel, Map<String, String> nativeModelMap, MavenExplicitProfiles activatedProfiles, @Nullable NativeMavenProjectHolder nativeMavenProject, Collection<MavenProjectProblem> readingProblems, Set<MavenId> unresolvedArtifactIds) {
        if (mavenModel == null) {
            MavenProjectReaderResult.$$$reportNull$$$0(0);
        }
        this(mavenModel, nativeModelMap, activatedProfiles, nativeMavenProject, readingProblems, unresolvedArtifactIds, Collections.emptyList());
    }

    public MavenProjectReaderResult(@NotNull MavenModel mavenModel, Map<String, String> nativeModelMap, MavenExplicitProfiles activatedProfiles, @Nullable NativeMavenProjectHolder nativeMavenProject, Collection<MavenProjectProblem> readingProblems, Set<MavenId> unresolvedArtifactIds, @NotNull Collection<MavenProjectProblem> unresolvedProblems) {
        if (mavenModel == null) {
            MavenProjectReaderResult.$$$reportNull$$$0(1);
        }
        if (unresolvedProblems == null) {
            MavenProjectReaderResult.$$$reportNull$$$0(2);
        }
        this.mavenModel = mavenModel;
        this.nativeModelMap = nativeModelMap;
        this.activatedProfiles = activatedProfiles;
        this.nativeMavenProject = nativeMavenProject;
        this.readingProblems = readingProblems;
        this.unresolvedArtifactIds = unresolvedArtifactIds;
        this.unresolvedProblems = unresolvedProblems;
    }

    public static boolean shouldResetDependenciesAndFolders(MavenProjectReaderResult result) {
        if (Registry.is((String)"maven.always.reset")) {
            return true;
        }
        MavenProjectProblem unrecoverable = (MavenProjectProblem)ContainerUtil.find(result.readingProblems, it -> !it.isRecoverable());
        return unrecoverable == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "mavenModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "unresolvedProblems";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/maven/project/MavenProjectReaderResult";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

