/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.jetbrains.annotations.Nullable;

public final class ComboBoxUtil {
    public static void addToModel(DefaultComboBoxModel model2, Object value, String label) {
        model2.addElement(new Item(value, label));
    }

    public static <T> void setModel(JComboBox comboBox, DefaultComboBoxModel model2, Collection<? extends T> values, Function<? super T, ? extends Pair<String, ?>> func) {
        model2.removeAllElements();
        for (T each : values) {
            Pair pair = (Pair)func.fun(each);
            ComboBoxUtil.addToModel(model2, pair.second, (String)pair.first);
        }
        comboBox.setModel(model2);
    }

    public static void select(DefaultComboBoxModel model2, Object value) {
        for (int i = 0; i < model2.getSize(); ++i) {
            Item comboBoxUtil = (Item)model2.getElementAt(i);
            if (!comboBoxUtil.getValue().equals(value)) continue;
            model2.setSelectedItem(comboBoxUtil);
            return;
        }
        if (model2.getSize() != 0) {
            model2.setSelectedItem(model2.getElementAt(0));
        }
    }

    @Nullable
    public static String getSelectedString(DefaultComboBoxModel model2) {
        return String.valueOf(ComboBoxUtil.getSelectedValue(model2));
    }

    @Nullable
    public static Object getSelectedValue(DefaultComboBoxModel model2) {
        Object item = model2.getSelectedItem();
        return item != null ? ((Item)item).getValue() : null;
    }

    private static final class Item {
        private final Object value;
        private final String label;

        private Item(Object value, String label) {
            this.value = value;
            this.label = label;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return this.label;
        }
    }
}

