/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX;

import com.intellij.codeInsight.daemon.ProjectSdkSetupValidator;
import com.intellij.codeInsight.daemon.impl.JavaProjectSdkSetupValidator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.Consumer;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.JavaFXBundle;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;

public class JavaFxProjectSdkSetupValidator
implements ProjectSdkSetupValidator {
    public boolean isApplicableFor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            JavaFxProjectSdkSetupValidator.$$$reportNull$$$0(0);
        }
        if (file == null) {
            JavaFxProjectSdkSetupValidator.$$$reportNull$$$0(1);
        }
        return JavaFxFileTypeFactory.isFxml(file);
    }

    @Nullable
    public String getErrorMessage(@NotNull Project project, @NotNull VirtualFile file) {
        String javaErrorMessage;
        if (project == null) {
            JavaFxProjectSdkSetupValidator.$$$reportNull$$$0(2);
        }
        if (file == null) {
            JavaFxProjectSdkSetupValidator.$$$reportNull$$$0(3);
        }
        if ((javaErrorMessage = JavaProjectSdkSetupValidator.INSTANCE.getErrorMessage(project, file)) != null) {
            return javaErrorMessage;
        }
        if (DumbService.isDumb((Project)project)) {
            return null;
        }
        PsiClass nodeClass = JavaPsiFacade.getInstance((Project)project).findClass("javafx.scene.Node", GlobalSearchScope.allScope((Project)project));
        if (nodeClass == null) {
            return JavaFXBundle.message("javafx.project.sdk.setup.validator.runtime.not.configured.error", new Object[0]);
        }
        return null;
    }

    @NotNull
    public EditorNotificationPanel.ActionHandler getFixHandler(final @NotNull Project project, final @NotNull VirtualFile file) {
        if (project == null) {
            JavaFxProjectSdkSetupValidator.$$$reportNull$$$0(4);
        }
        if (file == null) {
            JavaFxProjectSdkSetupValidator.$$$reportNull$$$0(5);
        }
        return new EditorNotificationPanel.ActionHandler(){

            public void handlePanelActionClick(@NotNull EditorNotificationPanel panel, @NotNull HyperlinkEvent event) {
                if (panel == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                JavaFxProjectSdkSetupValidator.doFix(project, file, (Consumer<EditorNotificationPanel.ActionHandler>)((Consumer)handler -> handler.handlePanelActionClick(panel, event)));
            }

            public void handleQuickFixClick(@NotNull Editor editor, @NotNull PsiFile psiFile) {
                if (editor == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (psiFile == null) {
                    1.$$$reportNull$$$0(3);
                }
                JavaFxProjectSdkSetupValidator.doFix(project, file, (Consumer<EditorNotificationPanel.ActionHandler>)((Consumer)handler -> handler.handleQuickFixClick(editor, psiFile)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "panel";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiFile";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/javaFX/JavaFxProjectSdkSetupValidator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handlePanelActionClick";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleQuickFixClick";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static void doFix(@NotNull Project project, @NotNull VirtualFile file, @NotNull Consumer<EditorNotificationPanel.ActionHandler> action) {
        String javaErrorMessage;
        if (project == null) {
            JavaFxProjectSdkSetupValidator.$$$reportNull$$$0(6);
        }
        if (file == null) {
            JavaFxProjectSdkSetupValidator.$$$reportNull$$$0(7);
        }
        if (action == null) {
            JavaFxProjectSdkSetupValidator.$$$reportNull$$$0(8);
        }
        if ((javaErrorMessage = JavaProjectSdkSetupValidator.INSTANCE.getErrorMessage(project, file)) != null) {
            action.consume((Object)JavaProjectSdkSetupValidator.INSTANCE.getFixHandler(project, file));
            return;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        String moduleName = module != null && !module.isDisposed() ? module.getName() : null;
        ProjectSettingsService.getInstance((Project)project).showModuleConfigurationDialog(moduleName, ClasspathEditor.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/javaFX/JavaFxProjectSdkSetupValidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableFor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getErrorMessage";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getFixHandler";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "doFix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

