/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.library.KotlinAbiVersion;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/CompatibilityMode;", "", "abiVersion", "Lorg/jetbrains/kotlin/library/KotlinAbiVersion;", "(Lorg/jetbrains/kotlin/library/KotlinAbiVersion;)V", "getAbiVersion", "()Lorg/jetbrains/kotlin/library/KotlinAbiVersion;", "oldSignatures", "", "getOldSignatures", "()Z", "Companion", "ir.serialization.common"})
public final class CompatibilityMode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KotlinAbiVersion abiVersion;
    @NotNull
    private static final KotlinAbiVersion LAST_PRIVATE_SIG_ABI_VERSION = new KotlinAbiVersion(1, 5, 0);
    @NotNull
    private static final CompatibilityMode WITH_PRIVATE_SIG = new CompatibilityMode(LAST_PRIVATE_SIG_ABI_VERSION);
    @NotNull
    private static final CompatibilityMode WITH_COMMON_SIG;
    @NotNull
    private static final CompatibilityMode CURRENT;

    public CompatibilityMode(@NotNull KotlinAbiVersion abiVersion) {
        Intrinsics.checkNotNullParameter(abiVersion, "abiVersion");
        this.abiVersion = abiVersion;
        boolean bl = this.abiVersion.isCompatible();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    @NotNull
    public final KotlinAbiVersion getAbiVersion() {
        return this.abiVersion;
    }

    public final boolean getOldSignatures() {
        if (this.abiVersion.getMinor() == LAST_PRIVATE_SIG_ABI_VERSION.getMinor()) {
            return this.abiVersion.getPatch() <= LAST_PRIVATE_SIG_ABI_VERSION.getPatch();
        }
        return this.abiVersion.getMinor() < LAST_PRIVATE_SIG_ABI_VERSION.getMinor();
    }

    static {
        CURRENT = WITH_COMMON_SIG = new CompatibilityMode(KotlinAbiVersion.Companion.getCURRENT());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/CompatibilityMode$Companion;", "", "()V", "CURRENT", "Lorg/jetbrains/kotlin/backend/common/serialization/CompatibilityMode;", "getCURRENT", "()Lorg/jetbrains/kotlin/backend/common/serialization/CompatibilityMode;", "LAST_PRIVATE_SIG_ABI_VERSION", "Lorg/jetbrains/kotlin/library/KotlinAbiVersion;", "getLAST_PRIVATE_SIG_ABI_VERSION", "()Lorg/jetbrains/kotlin/library/KotlinAbiVersion;", "WITH_COMMON_SIG", "getWITH_COMMON_SIG", "WITH_PRIVATE_SIG", "getWITH_PRIVATE_SIG", "ir.serialization.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinAbiVersion getLAST_PRIVATE_SIG_ABI_VERSION() {
            return LAST_PRIVATE_SIG_ABI_VERSION;
        }

        @NotNull
        public final CompatibilityMode getWITH_PRIVATE_SIG() {
            return WITH_PRIVATE_SIG;
        }

        @NotNull
        public final CompatibilityMode getWITH_COMMON_SIG() {
            return WITH_COMMON_SIG;
        }

        @NotNull
        public final CompatibilityMode getCURRENT() {
            return CURRENT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

