/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.diagnostics.MutableDiagnosticContext;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.CallableIdUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.CustomAnnotationTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.AnnotationTargetList;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J0\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J*\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\"\u0010\u0019\u001a\u00020\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "deprecatedClassId", "Lorg/jetbrains/kotlin/name/FqName;", "deprecatedSinceKotlinClassId", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkAnnotationTarget", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "checkAnnotationUseSiteTarget", "annotated", "target", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "checkDeprecatedCalls", "deprecatedSinceKotlin", "deprecated", "checkRepeatedAnnotations", "annotationContainer", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkRepeatedAnnotationsInProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "checkers"})
public final class FirAnnotationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirAnnotationChecker INSTANCE = new FirAnnotationChecker();
    @NotNull
    private static final FqName deprecatedClassId = new FqName("kotlin.Deprecated");
    @NotNull
    private static final FqName deprecatedSinceKotlinClassId = new FqName("kotlin.DeprecatedSinceKotlin");

    private FirAnnotationChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirAnnotation deprecated = null;
        FirAnnotation deprecatedSinceKotlin = null;
        for (FirAnnotation annotation2 : declaration.getAnnotations()) {
            boolean bl;
            CheckerContext it;
            FqName fqName2;
            if (CallableIdUtilsKt.fqName(annotation2, context.getSession()) == null) continue;
            if (Intrinsics.areEqual(fqName2, deprecatedClassId)) {
                deprecated = annotation2;
            } else if (Intrinsics.areEqual(fqName2, deprecatedSinceKotlinClassId)) {
                deprecatedSinceKotlin = annotation2;
            }
            boolean $i$f$withSuppressedDiagnostics = false;
            List<String> arguments$iv = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(annotation2);
            if (arguments$iv != null) {
                DiagnosticContext diagnosticContext = ((MutableDiagnosticContext)context).addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
                if (diagnosticContext == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
                }
                it = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext));
                bl = false;
                INSTANCE.checkAnnotationTarget(declaration, annotation2, it, reporter);
                continue;
            }
            it = (CheckerContext)((MutableDiagnosticContext)context);
            bl = false;
            INSTANCE.checkAnnotationTarget(declaration, annotation2, it, reporter);
        }
        if (deprecatedSinceKotlin != null) {
            FirAnnotationContainer annotationContainer$iv = deprecatedSinceKotlin;
            boolean $i$f$withSuppressedDiagnostics = false;
            List<String> arguments$iv = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(annotationContainer$iv);
            if (arguments$iv != null) {
                DiagnosticContext diagnosticContext = ((MutableDiagnosticContext)context).addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
                if (diagnosticContext == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
                }
                CheckerContext it = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext));
                boolean bl = false;
                INSTANCE.checkDeprecatedCalls(deprecatedSinceKotlin, deprecated, it, reporter);
            } else {
                CheckerContext it = (CheckerContext)((MutableDiagnosticContext)context);
                boolean bl = false;
                INSTANCE.checkDeprecatedCalls(deprecatedSinceKotlin, deprecated, it, reporter);
            }
        }
        this.checkRepeatedAnnotations(declaration, context, reporter);
        if (declaration instanceof FirProperty) {
            this.checkRepeatedAnnotationsInProperty((FirProperty)declaration, context, reporter);
        } else if (declaration instanceof FirCallableDeclaration) {
            KtSourceElement ktSourceElement = declaration.getSource();
            if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind)) {
                FirTypeRef $this$coneTypeSafe$iv = ((FirCallableDeclaration)declaration).getReturnTypeRef();
                boolean $i$f$coneTypeSafe = false;
                FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                if (!(coneKotlinType instanceof ConeKotlinType)) {
                    coneKotlinType = null;
                }
                this.checkRepeatedAnnotations(coneKotlinType, context, reporter);
            }
        } else if (declaration instanceof FirTypeAlias) {
            this.checkRepeatedAnnotations(FirTypeUtilsKt.getConeType(((FirTypeAlias)declaration).getExpandedTypeRef()), context, reporter);
        }
    }

    private final void checkAnnotationTarget(FirDeclaration declaration, FirAnnotation annotation2, CheckerContext context, DiagnosticReporter reporter) {
        Object targetDescription;
        AnnotationTargetList actualTargets = FirHelpersKt.getActualTargetList(declaration);
        Set<KotlinTarget> applicableTargets = FirAnnotationHelpersKt.getAllowedAnnotationTargets(annotation2, context.getSession());
        AnnotationUseSiteTarget useSiteTarget = annotation2.getUseSiteTarget();
        if (useSiteTarget != null) {
            this.checkAnnotationUseSiteTarget(declaration, annotation2, useSiteTarget, context, reporter);
        }
        if (FirAnnotationChecker.checkAnnotationTarget$check(applicableTargets, useSiteTarget, actualTargets.getDefaultTargets()) || FirAnnotationChecker.checkAnnotationTarget$check(applicableTargets, useSiteTarget, actualTargets.getCanBeSubstituted()) || FirAnnotationChecker.checkAnnotationTarget$checkWithUseSiteTargets(useSiteTarget, actualTargets, applicableTargets)) {
            return;
        }
        Object object = CollectionsKt.firstOrNull(actualTargets.getDefaultTargets());
        if (object == null || (object = object.getDescription()) == null) {
            object = targetDescription = "unidentified target";
        }
        if (useSiteTarget != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET(), targetDescription, (Object)useSiteTarget.getRenderName(), (DiagnosticContext)context, null, 32, null);
        } else {
            if (declaration instanceof FirProperty) {
                KtSourceElement ktSourceElement = declaration.getSource();
                if (Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.PropertyFromParameter.INSTANCE)) {
                    return;
                }
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET(), targetDescription, (DiagnosticContext)context, null, 16, null);
        }
    }

    private final void checkAnnotationUseSiteTarget(FirDeclaration annotated, FirAnnotation annotation2, AnnotationUseSiteTarget target, CheckerContext context, DiagnosticReporter reporter) {
        KtSourceElement ktSourceElement = annotation2.getSource();
        if (Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.FromUseSiteTarget.INSTANCE)) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[target.ordinal()]) {
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                if (!(annotated instanceof FirProperty) || ((FirProperty)annotated).getDelegateFieldSymbol() == null || DeclarationAttributesKt.getHasBackingField((FirProperty)annotated)) break;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_TARGET_PROPERTY_HAS_NO_BACKING_FIELD(), (DiagnosticContext)context, null, 8, null);
                break;
            }
            case 4: {
                if (!(annotated instanceof FirProperty) || ((FirProperty)annotated).getDelegateFieldSymbol() != null) break;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_TARGET_PROPERTY_HAS_NO_DELEGATE(), (DiagnosticContext)context, null, 8, null);
                break;
            }
            case 5: 
            case 6: {
                if (!(annotated instanceof FirProperty) || ((FirProperty)annotated).isLocal()) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_TARGET_ON_PROPERTY(), (Object)target.getRenderName(), (DiagnosticContext)context, null, 16, null);
                    break;
                }
                if (((FirProperty)annotated).isVar()) break;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_TARGET_PROPERTY_IMMUTABLE(), (Object)target.getRenderName(), (DiagnosticContext)context, null, 16, null);
                break;
            }
            case 7: {
                if (annotated instanceof FirValueParameter) {
                    FirDeclaration container = CollectionsKt.lastOrNull(context.getContainingDeclarations());
                    if (container instanceof FirConstructor && ((FirConstructor)container).isPrimary()) {
                        KtSourceElement ktSourceElement2 = annotated.getSource();
                        if (ktSourceElement2 != null ? LightTreePositioningStrategiesKt.hasValOrVar(ktSourceElement2) : false) break;
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getREDUNDANT_ANNOTATION_TARGET(), (Object)target.getRenderName(), (DiagnosticContext)context, null, 16, null);
                        break;
                    }
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_PARAM_TARGET(), (DiagnosticContext)context, null, 8, null);
                    break;
                }
                if (annotated instanceof FirProperty) {
                    KtSourceElement ktSourceElement3 = annotated.getSource();
                    if (Intrinsics.areEqual(ktSourceElement3 != null ? ktSourceElement3.getKind() : null, KtFakeSourceElementKind.PropertyFromParameter.INSTANCE)) break;
                }
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_PARAM_TARGET(), (DiagnosticContext)context, null, 8, null);
                break;
            }
            case 8: {
                if (annotated instanceof FirFile) break;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_FILE_TARGET(), (DiagnosticContext)context, null, 8, null);
                break;
            }
            case 9: {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET(), (Object)"declaration", (Object)target.getRenderName(), (DiagnosticContext)context, null, 32, null);
            }
        }
    }

    private final void checkDeprecatedCalls(FirAnnotation deprecatedSinceKotlin, FirAnnotation deprecated, CheckerContext context, DiagnosticReporter reporter) {
        FirFile closestFirFile;
        FirElement firElement;
        block7: {
            CheckerContext $this$findClosest_u24default$iv = context;
            boolean $i$f$findClosest = false;
            for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                FirElement firElement2;
                FirDeclaration firDeclaration = it$iv;
                if (!(firDeclaration instanceof FirFile)) {
                    firDeclaration = null;
                }
                if ((firElement = (FirElement)((FirFile)firDeclaration)) == null) continue;
                FirElement firElement3 = firElement2 = firElement;
                boolean bl = false;
                FirElement it = firElement3;
                firElement = true ? firElement2 : null;
                if (firElement == null) {
                    continue;
                }
                break block7;
            }
            firElement = null;
        }
        if ((closestFirFile = (FirFile)firElement) != null && !UtilsKt.getPackageFqName(closestFirFile).startsWith(StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE().shortName())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)deprecatedSinceKotlin.getSource(), FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_OUTSIDE_KOTLIN_SUBPACKAGE(), (DiagnosticContext)context, null, 8, null);
        }
        if (deprecated == null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)deprecatedSinceKotlin.getSource(), FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_WITHOUT_DEPRECATED(), (DiagnosticContext)context, null, 8, null);
        } else {
            Map<Name, FirExpression> argumentMapping = deprecated.getArgumentMapping().getMapping();
            for (Name name : argumentMapping.keySet()) {
                if (!Intrinsics.areEqual(name.getIdentifier(), "level")) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)deprecatedSinceKotlin.getSource(), FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_WITH_DEPRECATED_LEVEL(), (DiagnosticContext)context, null, 8, null);
                break;
            }
        }
    }

    private final void checkRepeatedAnnotations(FirAnnotationContainer annotationContainer, CheckerContext context, DiagnosticReporter reporter) {
        FirAnnotationHelpersKt.checkRepeatedAnnotation(annotationContainer, annotationContainer.getAnnotations(), context, reporter);
    }

    private final void checkRepeatedAnnotations(ConeKotlinType type2, CheckerContext context, DiagnosticReporter reporter) {
        if (type2 == null) {
            return;
        }
        ConeKotlinType fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType(type2, context.getSession());
        FirAnnotationHelpersKt.checkRepeatedAnnotation(null, CustomAnnotationTypeAttributeKt.getCustomAnnotations(fullyExpandedType2.getAttributes()), context, reporter);
        for (ConeTypeProjection typeArgument : fullyExpandedType2.getTypeArguments()) {
            if (!(typeArgument instanceof ConeKotlinType)) continue;
            this.checkRepeatedAnnotations((ConeKotlinType)typeArgument, context, reporter);
        }
    }

    private final void checkRepeatedAnnotationsInProperty(FirProperty property2, CheckerContext context, DiagnosticReporter reporter) {
        Pair[] pairArray = new Pair[3];
        FirPropertyAccessor firPropertyAccessor = property2.getGetter();
        pairArray[0] = TuplesKt.to(AnnotationUseSiteTarget.PROPERTY_GETTER, firPropertyAccessor != null ? FirAnnotationChecker.checkRepeatedAnnotationsInProperty$getAnnotationTypes(firPropertyAccessor) : null);
        FirPropertyAccessor firPropertyAccessor2 = property2.getSetter();
        pairArray[1] = TuplesKt.to(AnnotationUseSiteTarget.PROPERTY_SETTER, firPropertyAccessor2 != null ? FirAnnotationChecker.checkRepeatedAnnotationsInProperty$getAnnotationTypes(firPropertyAccessor2) : null);
        Object object = property2.getSetter();
        pairArray[2] = TuplesKt.to(AnnotationUseSiteTarget.SETTER_PARAMETER, FirAnnotationChecker.checkRepeatedAnnotationsInProperty$getAnnotationTypes(object != null && (object = ((FirPropertyAccessor)object).getValueParameters()) != null ? (FirValueParameter)CollectionsKt.single(object) : null));
        Map propertyAnnotations = MapsKt.mapOf(pairArray);
        boolean isError = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context.getSession()).supportsFeature(LanguageFeature.ProhibitRepeatedUseSiteTargetAnnotations);
        for (FirAnnotation annotation2 : property2.getAnnotations()) {
            List existingAnnotations;
            AnnotationUseSiteTarget useSiteTarget;
            AnnotationUseSiteTarget annotationUseSiteTarget = annotation2.getUseSiteTarget();
            if (annotationUseSiteTarget == null) {
                annotationUseSiteTarget = FirAnnotationHelpersKt.getDefaultUseSiteTarget(property2, annotation2, context);
            }
            if ((List)propertyAnnotations.get((Object)(useSiteTarget = annotationUseSiteTarget)) == null || !existingAnnotations.contains(FirTypeUtilsKt.getConeType(annotation2.getAnnotationTypeRef())) || FirAnnotationHelpersKt.isRepeatable(annotation2, context.getSession())) continue;
            KtDiagnosticFactory0 factory2 = isError ? FirErrors.INSTANCE.getREPEATED_ANNOTATION() : FirErrors.INSTANCE.getREPEATED_ANNOTATION_WARNING();
            KtSourceElement ktSourceElement = annotation2.getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), factory2, (DiagnosticContext)context, null, 8, null);
        }
    }

    private static final boolean checkAnnotationTarget$check(Set<? extends KotlinTarget> applicableTargets, AnnotationUseSiteTarget useSiteTarget, List<? extends KotlinTarget> targets) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = targets;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinTarget it = (KotlinTarget)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(applicableTargets.contains((Object)it) && (useSiteTarget == null || KotlinTarget.Companion.getUSE_SITE_MAPPING().get((Object)useSiteTarget) == it))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean checkAnnotationTarget$checkWithUseSiteTargets(AnnotationUseSiteTarget useSiteTarget, AnnotationTargetList actualTargets, Set<? extends KotlinTarget> applicableTargets) {
        boolean bl;
        block4: {
            if (useSiteTarget == null) {
                return false;
            }
            KotlinTarget useSiteMapping = KotlinTarget.Companion.getUSE_SITE_MAPPING().get((Object)useSiteTarget);
            Iterable $this$any$iv = actualTargets.getOnlyWithUseSiteTarget();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinTarget it = (KotlinTarget)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(applicableTargets.contains((Object)it) && it == useSiteMapping)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ConeKotlinType> checkRepeatedAnnotationsInProperty$getAnnotationTypes(FirAnnotationContainer $this$checkRepeatedAnnotationsInProperty_u24getAnnotationTypes) {
        List list2;
        Object object = $this$checkRepeatedAnnotationsInProperty_u24getAnnotationTypes;
        if (object != null && (object = object.getAnnotations()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirAnnotation firAnnotation = (FirAnnotation)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(FirTypeUtilsKt.getConeType(it.getAnnotationTypeRef()));
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnnotationUseSiteTarget.values().length];
            nArray[AnnotationUseSiteTarget.PROPERTY.ordinal()] = 1;
            nArray[AnnotationUseSiteTarget.PROPERTY_GETTER.ordinal()] = 2;
            nArray[AnnotationUseSiteTarget.FIELD.ordinal()] = 3;
            nArray[AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD.ordinal()] = 4;
            nArray[AnnotationUseSiteTarget.PROPERTY_SETTER.ordinal()] = 5;
            nArray[AnnotationUseSiteTarget.SETTER_PARAMETER.ordinal()] = 6;
            nArray[AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER.ordinal()] = 7;
            nArray[AnnotationUseSiteTarget.FILE.ordinal()] = 8;
            nArray[AnnotationUseSiteTarget.RECEIVER.ordinal()] = 9;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

