/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractImportingScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u000eH\u0014J.\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u000e2\u001c\u0010\u001b\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001a0\u001cH\u0016J$\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u000e2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u001a0 H\u0016J(\u0010\"\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u000e2\u0016\u0010\u001b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030#\u0012\u0004\u0012\u00020\u001a0 H\u0016R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirAbstractStarImportingScope;", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirAbstractImportingScope;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "lookupInFir", "", "excludedImportNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;ZLjava/util/Set;)V", "absentClassifierNames", "", "Lorg/jetbrains/kotlin/name/Name;", "getExcludedImportNames", "()Ljava/util/Set;", "starImports", "", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedImport;", "getStarImports", "()Ljava/util/List;", "isExcluded", "import", "name", "processClassifiersByNameWithSubstitution", "", "processor", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "processFunctionsByName", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "processPropertiesByName", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "providers"})
public abstract class FirAbstractStarImportingScope
extends FirAbstractImportingScope {
    @NotNull
    private final Set<FqName> excludedImportNames;
    @NotNull
    private final Set<Name> absentClassifierNames;

    public FirAbstractStarImportingScope(@NotNull FirSession session2, @NotNull ScopeSession scopeSession, boolean lookupInFir, @NotNull Set<FqName> excludedImportNames) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        Intrinsics.checkNotNullParameter(excludedImportNames, "excludedImportNames");
        super(session2, scopeSession, lookupInFir);
        this.excludedImportNames = excludedImportNames;
        this.absentClassifierNames = new LinkedHashSet();
    }

    @NotNull
    public final Set<FqName> getExcludedImportNames() {
        return this.excludedImportNames;
    }

    @NotNull
    public abstract List<FirResolvedImport> getStarImports();

    @Override
    protected boolean isExcluded(@NotNull FirResolvedImport firResolvedImport, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(firResolvedImport, "import");
        Intrinsics.checkNotNullParameter(name, "name");
        if (!((Collection)this.excludedImportNames).isEmpty()) {
            FqName fqName2 = firResolvedImport.getImportedFqName();
            Intrinsics.checkNotNull(fqName2);
            return this.excludedImportNames.contains(fqName2.child(name));
        }
        return false;
    }

    @Override
    public void processClassifiersByNameWithSubstitution(@NotNull Name name, @NotNull Function2<? super FirClassifierSymbol<?>, ? super ConeSubstitutor, Unit> processor2) {
        block6: {
            block5: {
                block4: {
                    Intrinsics.checkNotNullParameter(name, "name");
                    Intrinsics.checkNotNullParameter(processor2, "processor");
                    if (name.isSpecial()) break block4;
                    String string2 = name.getIdentifier();
                    Intrinsics.checkNotNullExpressionValue(string2, "name.identifier");
                    if (((CharSequence)string2).length() == 0) break block5;
                }
                if (!this.getStarImports().isEmpty() && !this.absentClassifierNames.contains(name)) break block6;
            }
            return;
        }
        Ref.BooleanRef foundAny = new Ref.BooleanRef();
        this.processImportsByName(name, this.getStarImports(), new Function1<FirClassLikeSymbol<?>, Unit>(foundAny, processor2){
            final /* synthetic */ Ref.BooleanRef $foundAny;
            final /* synthetic */ Function2<FirClassifierSymbol<?>, ConeSubstitutor, Unit> $processor;
            {
                this.$foundAny = $foundAny;
                this.$processor = $processor;
                super(1);
            }

            public final void invoke(@NotNull FirClassLikeSymbol<?> symbol2) {
                Intrinsics.checkNotNullParameter(symbol2, "symbol");
                this.$foundAny.element = true;
                this.$processor.invoke(symbol2, ConeSubstitutor.Empty.INSTANCE);
            }
        });
        if (!foundAny.element) {
            ((Collection)this.absentClassifierNames).add(name);
        }
    }

    @Override
    public void processFunctionsByName(@NotNull Name name, @NotNull Function1<? super FirNamedFunctionSymbol, Unit> processor2) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(processor2, "processor");
        this.processFunctionsByName(name, this.getStarImports(), processor2);
    }

    @Override
    public void processPropertiesByName(@NotNull Name name, @NotNull Function1<? super FirVariableSymbol<?>, Unit> processor2) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(processor2, "processor");
        this.processPropertiesByName(name, this.getStarImports(), processor2);
    }
}

