/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgEncodingUtil;

public abstract class HgCommitTypeCommand {
    @NonNls
    private static final String TEMP_FILE_NAME = ".hg4idea-commit.tmp";
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final HgRepository myRepository;
    @NotNull
    private final String myMessage;
    @NotNull
    private final Charset myCharset;
    protected final boolean myAmend;
    private Set<HgFile> myFiles;

    public HgCommitTypeCommand(@NotNull Project project, @NotNull HgRepository repository, @NotNull String message, boolean amend) {
        if (project == null) {
            HgCommitTypeCommand.$$$reportNull$$$0(0);
        }
        if (repository == null) {
            HgCommitTypeCommand.$$$reportNull$$$0(1);
        }
        if (message == null) {
            HgCommitTypeCommand.$$$reportNull$$$0(2);
        }
        this.myFiles = Collections.emptySet();
        this.myProject = project;
        this.myRepository = repository;
        this.myMessage = message;
        this.myAmend = amend;
        this.myCharset = HgEncodingUtil.getDefaultCharset(this.myProject);
    }

    public void setFiles(@NotNull Set<HgFile> files) {
        if (files == null) {
            HgCommitTypeCommand.$$$reportNull$$$0(3);
        }
        this.myFiles = files;
    }

    protected File saveCommitMessage() throws VcsException {
        File systemDir = new File(PathManager.getSystemPath());
        File tempFile = new File(systemDir, TEMP_FILE_NAME);
        try {
            FileUtil.writeToFile((File)tempFile, (byte[])this.myMessage.getBytes(this.myCharset));
        }
        catch (IOException e) {
            throw new VcsException(HgBundle.message("action.hg4idea.Commit.cant.prepare.commit.message.file", new Object[0]), (Throwable)e);
        }
        return tempFile;
    }

    public void executeInCurrentThread() throws HgCommandException, VcsException {
        if (StringUtil.isEmptyOrSpaces((String)this.myMessage)) {
            throw new HgCommandException(HgBundle.message("hg4idea.commit.error.messageEmpty", new Object[0]));
        }
        if (this.myFiles.isEmpty()) {
            this.executeChunked(Collections.emptyList());
        } else {
            List relativePaths = ContainerUtil.map2List(this.myFiles, file -> file.getRelativePath());
            List chunkedCommits = VcsFileUtil.chunkArguments((List)relativePaths);
            this.executeChunked(chunkedCommits);
        }
        this.myRepository.update();
        ((HgUpdater)BackgroundTaskUtil.syncPublisher((Project)this.myProject, HgVcs.REMOTE_TOPIC)).update(this.myProject, null);
    }

    protected abstract void executeChunked(@NotNull List<List<String>> var1) throws VcsException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "org/zmlx/hg4idea/command/HgCommitTypeCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

