/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.export;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.roots.impl.storage.ClasspathStorageProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jdom.output.EclipseJDOMUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.eclipse.EclipseBundle;
import org.jetbrains.idea.eclipse.config.EclipseModuleManagerImpl;
import org.jetbrains.idea.eclipse.conversion.DotProjectFileHelper;
import org.jetbrains.idea.eclipse.conversion.EclipseClasspathWriter;
import org.jetbrains.idea.eclipse.conversion.EclipseUserLibrariesHelper;
import org.jetbrains.idea.eclipse.conversion.IdeaSpecificSettings;
import org.jetbrains.idea.eclipse.export.ExportEclipseProjectsDialog;

public class ExportEclipseProjectsAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(ExportEclipseProjectsAction.class);

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ExportEclipseProjectsAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabled(e.getProject() != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ExportEclipseProjectsAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ExportEclipseProjectsAction.$$$reportNull$$$0(2);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        project.save();
        SmartList modules = new SmartList();
        SmartList incompatibleModules = new SmartList();
        for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
            if (EclipseModuleManagerImpl.isEclipseStorage(module2)) continue;
            try {
                ClasspathStorageProvider provider = ClasspathStorage.getProvider((String)"eclipse");
                if (provider != null) {
                    provider.assertCompatible((ModuleRootModel)ModuleRootManager.getInstance((Module)module2));
                }
                modules.add(module2);
            }
            catch (ConfigurationException ignored) {
                incompatibleModules.add(module2);
            }
        }
        if (incompatibleModules.isEmpty()) {
            if (modules.isEmpty()) {
                Messages.showInfoMessage((Project)project, (String)EclipseBundle.message("eclipse.export.nothing.to.do", new Object[0]), (String)EclipseBundle.message("eclipse.export.dialog.title", new Object[0]));
                return;
            }
        } else if (Messages.showOkCancelDialog((Project)project, (String)EclipseBundle.message("dialog.message.incompatible.modules.found", StringUtil.join((Collection)incompatibleModules, module -> module.getName(), (String)"<br><li>")), (String)EclipseBundle.message("eclipse.export.dialog.title", new Object[0]), (Icon)Messages.getWarningIcon()) != 0) {
            return;
        }
        modules.addAll(incompatibleModules);
        ExportEclipseProjectsDialog dialog = new ExportEclipseProjectsDialog(project, (List<? extends Module>)modules);
        if (!dialog.showAndGet()) {
            return;
        }
        if (dialog.isLink()) {
            for (Module module3 : dialog.getSelectedModules()) {
                ClasspathStorage.setStorageType((ModuleRootModel)ModuleRootManager.getInstance((Module)module3), (String)"eclipse");
            }
        } else {
            String storageRoot;
            LinkedHashMap module2StorageRoot = new LinkedHashMap();
            for (Module module2 : dialog.getSelectedModules()) {
                VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module2).getContentRoots();
                storageRoot = contentRoots.length == 1 ? contentRoots[0].getPath() : ClasspathStorage.getStorageRootFromOptions((Module)module2);
                module2StorageRoot.put((Object)module2, (Object)storageRoot);
                try {
                    DotProjectFileHelper.saveDotProjectFile(module2, storageRoot);
                }
                catch (Exception e1) {
                    LOG.error((Throwable)e1);
                }
            }
            for (Module module2 : module2StorageRoot.keySet()) {
                ModuleRootManager model = ModuleRootManager.getInstance((Module)module2);
                storageRoot = (String)module2StorageRoot.get((Object)module2);
                try {
                    File emlFile;
                    Element classpathElement = new EclipseClasspathWriter().writeClasspath((ModuleRootModel)model);
                    File classpathFile = new File(storageRoot, ".classpath");
                    if (!FileUtil.createIfDoesntExist((File)classpathFile)) continue;
                    EclipseJDOMUtil.output(classpathElement, classpathFile, project);
                    Element ideaSpecific = new Element("component");
                    if (!IdeaSpecificSettings.writeIdeaSpecificClasspath(ideaSpecific, (ModuleRootModel)model) || !FileUtil.createIfDoesntExist((File)(emlFile = new File(storageRoot, module2.getName() + ".eml")))) continue;
                    EclipseJDOMUtil.output(ideaSpecific, emlFile, project);
                }
                catch (Exception e1) {
                    LOG.error((Throwable)e1);
                }
            }
        }
        try {
            EclipseUserLibrariesHelper.appendProjectLibraries(project, dialog.getUserLibrariesFile());
        }
        catch (IOException e1) {
            LOG.error((Throwable)e1);
        }
        project.save();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/eclipse/export/ExportEclipseProjectsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/eclipse/export/ExportEclipseProjectsAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

