/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.actions.AbstractGuiEditorAction;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.propertyInspector.properties.BindingProperty;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CreateListenerAction
extends AbstractGuiEditorAction {
    private static final Logger LOG = Logger.getInstance(CreateListenerAction.class);

    @Override
    protected void actionPerformed(GuiEditor editor, List<? extends RadComponent> selection, AnActionEvent e) {
        DefaultActionGroup actionGroup = this.prepareActionGroup(selection);
        JComponent selectedComponent = selection.get(0).getDelegee();
        DataContext context = DataManager.getInstance().getDataContext((Component)selectedComponent);
        JBPopupFactory factory = JBPopupFactory.getInstance();
        ListPopup popup = factory.createActionGroupPopup(UIDesignerBundle.message("create.listener.title", new Object[0]), (ActionGroup)actionGroup, context, JBPopupFactory.ActionSelectionAid.NUMBERING, true);
        FormEditingUtil.showPopupUnderComponent((JBPopup)popup, selection.get(0));
    }

    private DefaultActionGroup prepareActionGroup(List<? extends RadComponent> selection) {
        EventSetDescriptor[] eventSetDescriptors;
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(selection.get(0).getComponentClass());
            eventSetDescriptors = beanInfo.getEventSetDescriptors();
        }
        catch (IntrospectionException e) {
            LOG.error((Throwable)e);
            return null;
        }
        EventSetDescriptor[] sortedDescriptors = (EventSetDescriptor[])eventSetDescriptors.clone();
        Arrays.sort(sortedDescriptors, Comparator.comparing(o -> o.getListenerType().getName()));
        for (EventSetDescriptor descriptor : sortedDescriptors) {
            actionGroup.add((AnAction)new MyCreateListenerAction(selection, descriptor));
        }
        return actionGroup;
    }

    @Override
    protected void update(@NotNull GuiEditor editor, ArrayList<? extends RadComponent> selection, AnActionEvent e) {
        if (editor == null) {
            CreateListenerAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabled(CreateListenerAction.canCreateListener(selection));
    }

    private static boolean canCreateListener(ArrayList<? extends RadComponent> selection) {
        if (selection.size() == 0) {
            return false;
        }
        RadRootContainer root = (RadRootContainer)FormEditingUtil.getRoot(selection.get(0));
        if (root.getClassToBind() == null) {
            return false;
        }
        String componentClass = selection.get(0).getComponentClassName();
        for (RadComponent radComponent : selection) {
            if (!radComponent.getComponentClassName().equals(componentClass) || radComponent.getBinding() == null) {
                return false;
            }
            if (BindingProperty.findBoundField(root, radComponent.getBinding()) != null) continue;
            return false;
        }
        return true;
    }

    @NlsSafe
    private static String getEventDescriptorName(EventSetDescriptor descriptor) {
        return descriptor.getListenerType().getSimpleName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/uiDesigner/actions/CreateListenerAction", "update"));
    }

    private static class MyCreateListenerAction
    extends AnAction {
        private final List<? extends RadComponent> mySelection;
        private final EventSetDescriptor myDescriptor;
        @NonNls
        private static final String LISTENER_SUFFIX = "Listener";
        @NonNls
        private static final String ADAPTER_SUFFIX = "Adapter";

        MyCreateListenerAction(List<? extends RadComponent> selection, EventSetDescriptor descriptor) {
            super(CreateListenerAction.getEventDescriptorName(descriptor));
            this.mySelection = selection;
            this.myDescriptor = descriptor;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyCreateListenerAction.$$$reportNull$$$0(0);
            }
            CommandProcessor.getInstance().executeCommand(this.mySelection.get(0).getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> this.createListener()), UIDesignerBundle.message("create.listener.command", new Object[0]), null);
        }

        private void createListener() {
            RadRootContainer root = (RadRootContainer)FormEditingUtil.getRoot(this.mySelection.get(0));
            PsiField[] boundFields = new PsiField[this.mySelection.size()];
            for (int i = 0; i < this.mySelection.size(); ++i) {
                boundFields[i] = BindingProperty.findBoundField(root, this.mySelection.get(i).getBinding());
            }
            final PsiClass myClass = boundFields[0].getContainingClass();
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)myClass)) {
                return;
            }
            try {
                PsiMethod constructor = this.findConstructorToInsert(myClass);
                Module module = ModuleUtil.findModuleForPsiElement((PsiElement)myClass);
                PsiClass listenerClass = null;
                String listenerClassName = this.myDescriptor.getListenerType().getName();
                if (listenerClassName.endsWith(LISTENER_SUFFIX)) {
                    String adapterClassName = listenerClassName.substring(0, listenerClassName.length() - LISTENER_SUFFIX.length()) + ADAPTER_SUFFIX;
                    listenerClass = JavaPsiFacade.getInstance((Project)myClass.getProject()).findClass(adapterClassName, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
                }
                if (listenerClass == null) {
                    listenerClass = JavaPsiFacade.getInstance((Project)myClass.getProject()).findClass(listenerClassName, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
                }
                if (listenerClass == null) {
                    Messages.showErrorDialog((Project)myClass.getProject(), (String)UIDesignerBundle.message("create.listener.class.not.found", new Object[0]), (String)CommonBundle.getErrorTitle());
                    return;
                }
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)myClass.getProject()).getElementFactory();
                PsiCodeBlock body = constructor.getBody();
                LOG.assertTrue(body != null);
                @NonNls StringBuilder builder = new StringBuilder();
                String variableName = null;
                if (boundFields.length == 1) {
                    builder.append(boundFields[0].getName());
                    builder.append(".");
                    builder.append(this.myDescriptor.getAddListenerMethod().getName());
                    builder.append("(");
                } else {
                    builder.append(listenerClass.getQualifiedName()).append(" ");
                    if (body.getLastBodyElement() == null) {
                        variableName = "listener";
                    } else {
                        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)myClass.getProject());
                        variableName = codeStyleManager.suggestUniqueVariableName("listener", body.getLastBodyElement(), false);
                    }
                    builder.append(variableName).append("=");
                }
                builder.append("new ");
                builder.append(listenerClass.getQualifiedName());
                builder.append("() { } ");
                if (boundFields.length == 1) {
                    builder.append(");");
                } else {
                    builder.append(";");
                }
                PsiStatement stmt = factory.createStatementFromText(builder.toString(), (PsiElement)constructor);
                stmt = (PsiStatement)body.addAfter((PsiElement)stmt, body.getLastBodyElement());
                stmt = (PsiStatement)JavaCodeStyleManager.getInstance((Project)body.getProject()).shortenClassReferences((PsiElement)stmt);
                if (boundFields.length > 1) {
                    PsiStatement anchor = stmt;
                    for (PsiField field : boundFields) {
                        PsiStatement addStmt = factory.createStatementFromText(field.getName() + "." + this.myDescriptor.getAddListenerMethod().getName() + "(" + variableName + ");", (PsiElement)constructor);
                        anchor = addStmt = body.addAfter((PsiElement)addStmt, (PsiElement)anchor);
                    }
                }
                final SmartPsiElementPointer ptr = SmartPointerManager.getInstance((Project)myClass.getProject()).createSmartPsiElementPointer((PsiElement)stmt);
                VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)myClass);
                final FileEditor[] fileEditors = virtualFile != null ? FileEditorManager.getInstance((Project)myClass.getProject()).openFile(virtualFile, true, true) : null;
                IdeFocusManager.findInstance().doWhenFocusSettlesDown(new Runnable(){

                    @Override
                    public void run() {
                        PsiElement anonymousClassStatement = ptr.getElement();
                        if (anonymousClassStatement == null) {
                            return;
                        }
                        final Ref newClassRef = new Ref();
                        anonymousClassStatement.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                            public void visitClass(PsiClass aClass) {
                                newClassRef.set((Object)aClass);
                            }
                        });
                        PsiClass newClass = (PsiClass)newClassRef.get();
                        Editor editor = this.getEditor();
                        if (editor != null && newClass != null) {
                            PsiElement brace = newClass.getLBrace();
                            if (brace != null) {
                                editor.getCaretModel().moveToOffset(brace.getTextOffset());
                            }
                            CommandProcessor.getInstance().executeCommand(myClass.getProject(), () -> {
                                if (!OverrideImplementExploreUtil.getMethodSignaturesToImplement((PsiClass)newClass).isEmpty()) {
                                    OverrideImplementUtil.chooseAndImplementMethods((Project)newClass.getProject(), (Editor)editor, (PsiClass)newClass);
                                } else {
                                    OverrideImplementUtil.chooseAndOverrideMethods((Project)newClass.getProject(), (Editor)editor, (PsiClass)newClass);
                                }
                            }, "", null);
                        }
                    }

                    private Editor getEditor() {
                        if (fileEditors != null) {
                            for (FileEditor fileEditor : fileEditors) {
                                if (!(fileEditor instanceof TextEditor)) continue;
                                return ((TextEditor)fileEditor).getEditor();
                            }
                        }
                        return null;
                    }
                }, ModalityState.current());
            }
            catch (IncorrectOperationException ex) {
                LOG.error((Throwable)ex);
            }
        }

        private PsiMethod findConstructorToInsert(PsiClass aClass) throws IncorrectOperationException {
            PsiMethod[] constructors = aClass.getConstructors();
            if (constructors.length == 0) {
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory();
                PsiMethod newConstructor = factory.createMethodFromText("public " + aClass.getName() + "() { }", (PsiElement)aClass);
                PsiMethod[] psiMethods = aClass.getMethods();
                PsiMethod firstMethod = psiMethods.length == 0 ? null : psiMethods[0];
                return (PsiMethod)aClass.addBefore((PsiElement)newConstructor, (PsiElement)firstMethod);
            }
            for (PsiMethod method : constructors) {
                if (!method.getParameterList().isEmpty()) continue;
                return method;
            }
            return constructors[0];
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/uiDesigner/actions/CreateListenerAction$MyCreateListenerAction", "actionPerformed"));
        }
    }
}

